/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import javax.swing.Icon;

public class SourcesOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, true, false, true, true);
        return new SourcesPathEditor(sdk, descriptor2);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.SourceFolder;
    }

    public String getNodeText() {
        return ProjectBundle.message((String)"library.sources.node", (Object[])new Object[0]);
    }

    private static class SourcesPathEditor
    extends SdkPathEditor {
        private final Sdk mySdk;

        public SourcesPathEditor(Sdk sdk, FileChooserDescriptor descriptor2) {
            super(ProjectBundle.message((String)"sdk.configure.sourcepath.tab", (Object[])new Object[0]), OrderRootType.SOURCES, descriptor2);
            this.mySdk = sdk;
        }

        protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files) {
            if (this.mySdk.getSdkType() instanceof JavaSdkType) {
                return LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(component, files);
            }
            return super.adjustAddedFileSet(component, files);
        }
    }
}

