/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureProblemDescription {
    private final String myMessage;
    private final String myDescription;
    private final PlaceInProjectStructure myPlace;
    private final List<? extends ConfigurationErrorQuickFix> myFixes;
    private final ProjectStructureProblemType myProblemType;
    private final ProblemLevel myProblemLevel;
    private final boolean myCanShowPlace;

    public ProjectStructureProblemDescription(@NotNull String message2, @Nullable String description, @NotNull PlaceInProjectStructure place, @NotNull ProjectStructureProblemType problemType, @NotNull List<? extends ConfigurationErrorQuickFix> fixes) {
        if (message2 == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(1);
        }
        if (problemType == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(2);
        }
        if (fixes == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(3);
        }
        this(message2, description, place, problemType, ProblemLevel.PROJECT, fixes, true);
    }

    public ProjectStructureProblemDescription(@NotNull String message2, @Nullable String description, @NotNull PlaceInProjectStructure place, @NotNull ProjectStructureProblemType problemType, @NotNull ProblemLevel level, @NotNull List<? extends ConfigurationErrorQuickFix> fixes, boolean canShowPlace) {
        if (message2 == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(4);
        }
        if (place == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(5);
        }
        if (problemType == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(6);
        }
        if (level == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(7);
        }
        if (fixes == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(8);
        }
        this.myMessage = message2;
        this.myDescription = description;
        this.myPlace = place;
        this.myFixes = fixes;
        this.myProblemType = problemType;
        this.myProblemLevel = level;
        this.myCanShowPlace = canShowPlace;
    }

    public ProblemLevel getProblemLevel() {
        return this.myProblemLevel;
    }

    public String getMessage(boolean includePlace) {
        if (includePlace && this.myCanShowPlace) {
            return this.myPlace.getContainingElement().getPresentableText() + ": " + StringUtil.decapitalize((String)this.myMessage);
        }
        return this.myMessage;
    }

    public boolean canShowPlace() {
        return this.myCanShowPlace;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public List<? extends ConfigurationErrorQuickFix> getFixes() {
        return this.myFixes;
    }

    public ProjectStructureProblemType.Severity getSeverity() {
        return this.myProblemType.getSeverity();
    }

    @NotNull
    public PlaceInProjectStructure getPlace() {
        PlaceInProjectStructure placeInProjectStructure = this.myPlace;
        if (placeInProjectStructure == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(9);
        }
        return placeInProjectStructure;
    }

    public String getId() {
        String placePath = this.myPlace.getPlacePath();
        return this.myProblemType.getId() + "(" + this.myPlace.getContainingElement().getId() + (placePath != null ? "," + placePath : "") + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemType";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ProblemLevel {
        PROJECT,
        GLOBAL;

    }
}

