/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="UnknownFeatures", storages={@Storage(value="$WORKSPACE_FILE$")})
public class UnknownFeaturesCollector
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String FEATURE_ID = "featureType";
    @NonNls
    private static final String IMPLEMENTATION_NAME = "implementationName";
    private final Set<UnknownFeature> myUnknownFeatures = new HashSet<UnknownFeature>();
    private final Set<UnknownFeature> myIgnoredUnknownFeatures = new HashSet<UnknownFeature>();

    public static UnknownFeaturesCollector getInstance(Project project2) {
        return (UnknownFeaturesCollector)ServiceManager.getService((Project)project2, UnknownFeaturesCollector.class);
    }

    public void registerUnknownRunConfiguration(String configurationId) {
        this.registerUnknownFeature("com.intellij.configurationType", configurationId, "Run Configuration");
    }

    public void registerUnknownFeature(String featureType, String implementationName, String featureDisplayName) {
        UnknownFeature feature = new UnknownFeature(featureType, featureDisplayName, implementationName);
        if (!this.isIgnored(feature)) {
            this.myUnknownFeatures.add(feature);
        }
    }

    public boolean isIgnored(UnknownFeature feature) {
        return this.myIgnoredUnknownFeatures.contains(feature);
    }

    public void ignoreFeature(UnknownFeature feature) {
        this.myIgnoredUnknownFeatures.add(feature);
    }

    public Set<UnknownFeature> getUnknownFeatures() {
        return this.myUnknownFeatures;
    }

    @Nullable
    public Element getState() {
        if (this.myIgnoredUnknownFeatures.isEmpty()) {
            return null;
        }
        Element ignored = new Element("ignored");
        for (UnknownFeature feature : this.myIgnoredUnknownFeatures) {
            Element option = new Element("option");
            option.setAttribute(FEATURE_ID, feature.getFeatureType());
            option.setAttribute(IMPLEMENTATION_NAME, feature.getImplementationName());
            ignored.addContent(option);
        }
        return ignored;
    }

    public void loadState(Element state) {
        this.myIgnoredUnknownFeatures.clear();
        for (Element element : state.getChildren()) {
            this.myIgnoredUnknownFeatures.add(new UnknownFeature(element.getAttributeValue(FEATURE_ID), null, element.getAttributeValue(IMPLEMENTATION_NAME)));
        }
    }
}

