/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFilePath
implements FilePath {
    private static final TObjectHashingStrategy<String> CASE_SENSITIVE_STRATEGY = FilePathHashingStrategy.create((boolean)true);
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public RemoteFilePath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            RemoteFilePath.$$$reportNull$$$0(0);
        }
        this.myPath = path;
        this.myIsDirectory = isDirectory;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        return null;
    }

    @NotNull
    public File getIOFile() {
        File file2 = new File(this.myPath);
        if (file2 == null) {
            RemoteFilePath.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.myPath);
        if (string == null) {
            RemoteFilePath.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.getPath();
        if (string == null) {
            RemoteFilePath.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Document getDocument() {
        return null;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            RemoteFilePath.$$$reportNull$$$0(4);
        }
        return charset;
    }

    @NotNull
    public Charset getCharset(@Nullable Project project2) {
        EncodingManager em = project2 == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project2);
        Charset charset = em.getDefaultCharset();
        if (charset == null) {
            RemoteFilePath.$$$reportNull$$$0(5);
        }
        return charset;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
        if (fileType == null) {
            RemoteFilePath.$$$reportNull$$$0(6);
        }
        return fileType;
    }

    public void refresh() {
    }

    public void hardRefresh() {
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            RemoteFilePath.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            RemoteFilePath.$$$reportNull$$$0(8);
        }
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new RemoteFilePath(parent, true);
    }

    public boolean isNonLocal() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteFilePath other = (RemoteFilePath)o;
        if (this.myIsDirectory != other.myIsDirectory) {
            return false;
        }
        return CASE_SENSITIVE_STRATEGY.equals((Object)this.myPath, (Object)other.myPath);
    }

    public int hashCode() {
        int result2 = CASE_SENSITIVE_STRATEGY.computeHashCode((Object)this.myPath);
        result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/RemoteFilePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/RemoteFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIOFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

