/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThreeState;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListsIndexes");
    private final Map<FilePath, Data> myMap;
    private final TreeSet<FilePath> myAffectedPaths;

    public ChangeListsIndexes() {
        this.myMap = new HashMap<FilePath, Data>();
        this.myAffectedPaths = new TreeSet<FilePath>(HierarchicalFilePathComparator.SYSTEM_CASE_SENSITIVE);
    }

    public ChangeListsIndexes(@NotNull ChangeListsIndexes idx) {
        if (idx == null) {
            ChangeListsIndexes.$$$reportNull$$$0(0);
        }
        this.myMap = new HashMap<FilePath, Data>(idx.myMap);
        this.myAffectedPaths = new TreeSet<FilePath>((SortedSet<FilePath>)idx.myAffectedPaths);
    }

    private void add(@NotNull FilePath file2, @NotNull FileStatus status, @Nullable VcsKey key2, @NotNull VcsRevisionNumber number) {
        if (file2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(1);
        }
        if (status == null) {
            ChangeListsIndexes.$$$reportNull$$$0(2);
        }
        if (number == null) {
            ChangeListsIndexes.$$$reportNull$$$0(3);
        }
        this.myMap.put(file2, new Data(status, key2, number));
        this.myAffectedPaths.add(file2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set status " + status + " for " + file2);
        }
    }

    public void remove(FilePath file2) {
        this.myMap.remove(file2);
        this.myAffectedPaths.remove(file2);
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(4);
        }
        return this.getStatus(VcsUtil.getFilePath((VirtualFile)file2));
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file2) {
        Data data;
        if (file2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(5);
        }
        return (data = this.myMap.get(file2)) != null ? data.status : null;
    }

    public void changeAdded(@NotNull Change change, VcsKey key2) {
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(6);
        }
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null && afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key2, beforeRevision.getRevisionNumber());
            if (!Comparing.equal((Object)beforeRevision.getFile(), (Object)afterRevision.getFile())) {
                this.add(beforeRevision.getFile(), FileStatus.DELETED, key2, beforeRevision.getRevisionNumber());
            }
        } else if (afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key2, VcsRevisionNumber.NULL);
        } else if (beforeRevision != null) {
            this.add(beforeRevision.getFile(), change.getFileStatus(), key2, beforeRevision.getRevisionNumber());
        }
    }

    public void changeRemoved(@NotNull Change change) {
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(7);
        }
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    @Nullable
    public VcsKey getVcsFor(@NotNull Change change) {
        VcsKey key2;
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(8);
        }
        if ((key2 = this.getVcsForRevision(change.getAfterRevision())) != null) {
            return key2;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private VcsKey getVcsForRevision(@Nullable ContentRevision revision) {
        if (revision != null) {
            Data data = this.myMap.get(revision.getFile());
            return data != null ? data.vcsKey : null;
        }
        return null;
    }

    public void getDelta(ChangeListsIndexes newIndexes, Set<BaseRevision> toRemove2, Set<BaseRevision> toAdd, Set<BeforeAfter<BaseRevision>> toModify) {
        FilePath s;
        Map<FilePath, Data> oldMap = this.myMap;
        Map<FilePath, Data> newMap = newIndexes.myMap;
        for (Map.Entry<FilePath, Data> entry : oldMap.entrySet()) {
            s = entry.getKey();
            Data oldData = entry.getValue();
            Data newData = newMap.get(s);
            if (newData != null) {
                if (oldData.sameRevisions(newData)) continue;
                toModify.add((BeforeAfter<BaseRevision>)new BeforeAfter((Object)ChangeListsIndexes.createBaseRevision(s, oldData), (Object)ChangeListsIndexes.createBaseRevision(s, newData)));
                continue;
            }
            toRemove2.add(ChangeListsIndexes.createBaseRevision(s, oldData));
        }
        for (Map.Entry<FilePath, Data> entry : newMap.entrySet()) {
            s = entry.getKey();
            Data newData = entry.getValue();
            if (oldMap.containsKey(s)) continue;
            toAdd.add(ChangeListsIndexes.createBaseRevision(s, newData));
        }
    }

    @NotNull
    public ThreeState haveChangesUnder(@NotNull FilePath dir) {
        FilePath changeCandidate;
        if (dir == null) {
            ChangeListsIndexes.$$$reportNull$$$0(9);
        }
        if ((changeCandidate = this.myAffectedPaths.ceiling(dir)) == null) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ChangeListsIndexes.$$$reportNull$$$0(10);
            }
            return threeState;
        }
        ThreeState threeState = FileUtil.isAncestorThreeState((String)dir.getPath(), (String)changeCandidate.getPath(), (boolean)false);
        if (threeState == null) {
            ChangeListsIndexes.$$$reportNull$$$0(11);
        }
        return threeState;
    }

    private static BaseRevision createBaseRevision(@NotNull FilePath path, @NotNull Data data) {
        if (path == null) {
            ChangeListsIndexes.$$$reportNull$$$0(12);
        }
        if (data == null) {
            ChangeListsIndexes.$$$reportNull$$$0(13);
        }
        return new BaseRevision(data.vcsKey, data.revision, path);
    }

    @NotNull
    public List<BaseRevision> getAffectedFilesUnderVcs() {
        ArrayList<BaseRevision> result2 = new ArrayList<BaseRevision>();
        for (Map.Entry<FilePath, Data> entry : this.myMap.entrySet()) {
            Data value2 = entry.getValue();
            result2.add(ChangeListsIndexes.createBaseRevision(entry.getKey(), value2));
        }
        ArrayList<BaseRevision> arrayList = result2;
        if (arrayList == null) {
            ChangeListsIndexes.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public void clear() {
        this.myMap.clear();
        this.myAffectedPaths.clear();
    }

    @NotNull
    public Set<FilePath> getAffectedPaths() {
        Set<FilePath> set2 = Collections.unmodifiableSet(this.myMap.keySet());
        if (set2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(15);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFilesUnderVcs";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeAdded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBaseRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Data {
        @NotNull
        public final FileStatus status;
        public final VcsKey vcsKey;
        @NotNull
        public final VcsRevisionNumber revision;

        public Data(@NotNull FileStatus status, VcsKey vcsKey, @NotNull VcsRevisionNumber revision) {
            if (status == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.status = status;
            this.vcsKey = vcsKey;
            this.revision = revision;
        }

        public boolean sameRevisions(@NotNull Data data) {
            if (data == null) {
                Data.$$$reportNull$$$0(2);
            }
            return Comparing.equal((Object)this.vcsKey, (Object)data.vcsKey) && Comparing.equal((Object)this.revision, (Object)data.revision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes$Data";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sameRevisions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

