/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToNewDiffUtil {
    @NotNull
    public static DiffRequest convertRequest(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        DiffRequest request;
        if (oldRequest == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(0);
        }
        if ((request = MigrateToNewDiffUtil.convertRequestFair(oldRequest)) != null) {
            DiffRequest diffRequest = request;
            if (diffRequest == null) {
                MigrateToNewDiffUtil.$$$reportNull$$$0(1);
            }
            return diffRequest;
        }
        ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((DiffRequestProducer)new MyDiffRequestProducer(oldRequest), "Can't convert from old-style request");
        if (errorDiffRequest == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(2);
        }
        return errorDiffRequest;
    }

    @Nullable
    private static DiffRequest convertRequestFair(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(3);
        }
        if (oldRequest.getOnOkRunnable() != null) {
            return null;
        }
        com.intellij.openapi.diff.DiffContent[] contents = oldRequest.getContents();
        String[] titles = oldRequest.getContentTitles();
        ArrayList<DiffContent> newContents = new ArrayList<DiffContent>(contents.length);
        for (int i = 0; i < contents.length; ++i) {
            DiffContent convertedContent = MigrateToNewDiffUtil.convertContent(oldRequest.getProject(), contents[i]);
            if (convertedContent == null) {
                return null;
            }
            newContents.add(convertedContent);
        }
        SimpleDiffRequest newRequest = new SimpleDiffRequest(oldRequest.getWindowTitle(), newContents, Arrays.asList(titles));
        DiffNavigationContext navigationContext = (DiffNavigationContext)oldRequest.getGenericData().get(DiffTool.SCROLL_TO_LINE.getName());
        if (navigationContext != null) {
            newRequest.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, (Object)navigationContext);
        }
        return newRequest;
    }

    @Nullable
    private static DiffContent convertContent(@Nullable Project project2, final @NotNull com.intellij.openapi.diff.DiffContent oldContent) {
        if (oldContent == null) {
            MigrateToNewDiffUtil.$$$reportNull$$$0(4);
        }
        if (oldContent.isEmpty()) {
            return new EmptyContent();
        }
        if (oldContent.isBinary()) {
            VirtualFile file2 = oldContent.getFile();
            if (file2 == null) {
                return null;
            }
            return new FileContentImpl(project2, file2);
        }
        final Document document = oldContent.getDocument();
        if (document == null) {
            return null;
        }
        return new DocumentContentImpl(project2, document, oldContent.getContentType(), oldContent.getFile(), oldContent.getLineSeparator(), null, null){

            @Override
            @Nullable
            public Navigatable getNavigatable(@NotNull LineCol position) {
                if (position == null) {
                    1.$$$reportNull$$$0(0);
                }
                return oldContent.getOpenFileDescriptor(position.toOffset(document));
            }

            public void onAssigned(boolean isAssigned) {
                oldContent.onAssigned(isAssigned);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$1", "getNavigatable"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRequest";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertRequest";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertRequestFair";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final com.intellij.openapi.diff.DiffRequest myRequest;

        public MyDiffRequestProducer(@NotNull com.intellij.openapi.diff.DiffRequest request) {
            if (request == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(0);
            }
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myRequest.getWindowTitle());
            if (string == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            if (context == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(3);
            }
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((DiffRequestProducer)this, "Can't convert from old-style request");
            if (errorDiffRequest == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(4);
            }
            return errorDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/migrate/MigrateToNewDiffUtil$MyDiffRequestProducer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

