/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.concurrency.JobScheduler;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CachesHolder;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedListsSequencesZipper;
import com.intellij.openapi.vcs.changes.committed.CompositeCommittedChangesProvider;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipperAdapter;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.MessageBusUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.ProgressManagerQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CommittedChangesCache", storages={@Storage(value="$WORKSPACE_FILE$")})
public class CommittedChangesCache
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.CommittedChangesCache");
    private final Project myProject;
    private final MessageBus myBus;
    private final ProgressManagerQueue myTaskQueue;
    private final MessageBusConnection myConnection;
    private boolean myRefreshingIncomingChanges = false;
    private int myPendingUpdateCount = 0;
    private State myState = new State();
    private ScheduledFuture myFuture;
    private List<CommittedChangeList> myCachedIncomingChangeLists;
    private final Set<CommittedChangeList> myNewIncomingChanges = new LinkedHashSet<CommittedChangeList>();
    private final ProjectLevelVcsManager myVcsManager;
    private MyRefreshRunnable myRefresnRunnable;
    private final Map<String, Pair<Long, List<CommittedChangeList>>> myExternallyLoadedChangeLists;
    private final CachesHolder myCachesHolder;
    private final RepositoryLocationCache myLocationCache;
    public static final Topic<CommittedChangesListener> COMMITTED_TOPIC = new Topic("committed changes updates", CommittedChangesListener.class);

    public static CommittedChangesCache getInstance(Project project2) {
        return (CommittedChangesCache)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, CommittedChangesCache.class);
    }

    public CommittedChangesCache(Project project2, MessageBus bus, ProjectLevelVcsManager vcsManager) {
        this.myProject = project2;
        this.myBus = bus;
        this.myConnection = this.myBus.connect();
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                CommittedChangesCache.this.myLocationCache.reset();
                CommittedChangesCache.this.refreshAllCachesAsync(false, true);
                CommittedChangesCache.this.refreshIncomingChangesAsync();
                CommittedChangesCache.this.myTaskQueue.run(() -> {
                    for (ChangesCacheFile file2 : CommittedChangesCache.this.myCachesHolder.getAllCaches()) {
                        RepositoryLocation location = file2.getLocation();
                        CommittedChangesCache.this.fireChangesLoaded(location, Collections.emptyList());
                    }
                    CommittedChangesCache.this.fireIncomingReloaded();
                });
            }
        };
        this.myLocationCache = new RepositoryLocationCache(project2);
        this.myCachesHolder = new CachesHolder(project2, this.myLocationCache);
        this.myTaskQueue = new ProgressManagerQueue(project2, VcsBundle.message((String)"committed.changes.refresh.progress", (Object[])new Object[0]));
        ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.COMMITTED_CHANGES_CACHE, () -> ApplicationManager.getApplication().runReadAction(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myTaskQueue.start();
            this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
            this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)vcsListener);
        }));
        this.myVcsManager = vcsManager;
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                CommittedChangesCache.this.cancelRefreshTimer();
                CommittedChangesCache.this.myConnection.disconnect();
            }
        });
        this.myExternallyLoadedChangeLists = ContainerUtil.newConcurrentMap();
    }

    public MessageBus getMessageBus() {
        return this.myBus;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        this.updateRefreshTimer();
    }

    @Nullable
    public CommittedChangesProvider getProviderForProject() {
        AbstractVcs[] vcss = this.myVcsManager.getAllActiveVcss();
        ArrayList<AbstractVcs> vcsWithProviders = new ArrayList<AbstractVcs>();
        for (AbstractVcs vcs : vcss) {
            if (vcs.getCommittedChangesProvider() == null) continue;
            vcsWithProviders.add(vcs);
        }
        if (vcsWithProviders.isEmpty()) {
            return null;
        }
        if (vcsWithProviders.size() == 1) {
            return ((AbstractVcs)vcsWithProviders.get(0)).getCommittedChangesProvider();
        }
        return new CompositeCommittedChangesProvider(this.myProject, vcsWithProviders.toArray(new AbstractVcs[vcsWithProviders.size()]));
    }

    public boolean isMaxCountSupportedForProject() {
        for (AbstractVcs vcs : this.myVcsManager.getAllActiveVcss()) {
            CachingCommittedChangesProvider cachingProvider;
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (!(provider instanceof CachingCommittedChangesProvider) || (cachingProvider = (CachingCommittedChangesProvider)provider).isMaxCountSupported()) continue;
            return false;
        }
        return true;
    }

    public void getProjectChangesAsync(ChangeBrowserSettings settings, int maxCount, boolean cacheOnly, Consumer<List<CommittedChangeList>> consumer, Consumer<List<VcsException>> errorConsumer) {
        MyProjectChangesLoader loader = new MyProjectChangesLoader(settings, maxCount, cacheOnly, consumer, errorConsumer);
        this.myTaskQueue.run(loader);
    }

    @Nullable
    public List<CommittedChangeList> getChanges(ChangeBrowserSettings settings, VirtualFile file2, @NotNull AbstractVcs vcs, int maxCount, boolean cacheOnly, CommittedChangesProvider provider, RepositoryLocation location) throws VcsException {
        if (vcs == null) {
            CommittedChangesCache.$$$reportNull$$$0(0);
        }
        if (settings instanceof CompositeCommittedChangesProvider.CompositeChangeBrowserSettings) {
            settings = ((CompositeCommittedChangesProvider.CompositeChangeBrowserSettings)settings).get(vcs);
        }
        if (provider instanceof CachingCommittedChangesProvider) {
            try {
                if (cacheOnly) {
                    ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, file2, location);
                    if (!cacheFile.isEmpty()) {
                        RepositoryLocation fileLocation = cacheFile.getLocation();
                        fileLocation.onBeforeBatch();
                        List<CommittedChangeList> committedChangeLists = cacheFile.readChanges(settings, maxCount);
                        fileLocation.onAfterBatch();
                        return committedChangeLists;
                    }
                    return null;
                }
                if (this.canGetFromCache(vcs, settings, file2, location, maxCount)) {
                    return this.getChangesWithCaching(vcs, settings, file2, location, maxCount);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return provider.getCommittedChanges(settings, location, maxCount);
    }

    private boolean canGetFromCache(AbstractVcs vcs, ChangeBrowserSettings settings, VirtualFile root, RepositoryLocation location, int maxCount) throws IOException {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        if (cacheFile.isEmpty()) {
            return true;
        }
        if (settings.USE_DATE_BEFORE_FILTER && !settings.USE_DATE_AFTER_FILTER) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_CHANGE_BEFORE_FILTER && !settings.USE_CHANGE_AFTER_FILTER) {
            return cacheFile.hasCompleteHistory();
        }
        boolean hasDateFilter = settings.USE_DATE_AFTER_FILTER || settings.USE_DATE_BEFORE_FILTER || settings.USE_CHANGE_AFTER_FILTER || settings.USE_CHANGE_BEFORE_FILTER;
        boolean hasNonDateFilter = settings.isNonDateFilterSpecified();
        if (!hasDateFilter && hasNonDateFilter) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_DATE_AFTER_FILTER && settings.getDateAfter().getTime() < cacheFile.getFirstCachedDate().getTime()) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_CHANGE_AFTER_FILTER && settings.getChangeAfterFilter() < cacheFile.getFirstCachedChangelist()) {
            return cacheFile.hasCompleteHistory();
        }
        return true;
    }

    public void hasCachesForAnyRoot(@Nullable Consumer<Boolean> continuation) {
        this.myTaskQueue.run(() -> {
            Ref success = new Ref();
            try {
                success.set((Object)this.hasCachesWithEmptiness(false));
            }
            catch (ProcessCanceledException e) {
                success.set((Object)true);
            }
            ApplicationManager.getApplication().invokeLater(() -> continuation.consume(success.get()), this.myProject.getDisposed());
        });
    }

    public boolean hasEmptyCaches() {
        try {
            return this.hasCachesWithEmptiness(true);
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    private boolean hasCachesWithEmptiness(boolean emptiness) {
        Ref resultRef = new Ref((Object)Boolean.FALSE);
        this.myCachesHolder.iterateAllCaches((Processor<ChangesCacheFile>)((Processor)changesCacheFile -> {
            try {
                if (changesCacheFile.isEmpty() == emptiness) {
                    resultRef.set((Object)true);
                    return false;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            return true;
        }));
        return (Boolean)resultRef.get();
    }

    @Nullable
    public Iterator<ChangesBunch> getBackBunchedIterator(AbstractVcs vcs, VirtualFile root, RepositoryLocation location, int bunchSize) {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        try {
            if (!cacheFile.isEmpty()) {
                return cacheFile.getBackBunchedIterator(bunchSize);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private List<CommittedChangeList> getChangesWithCaching(AbstractVcs vcs, ChangeBrowserSettings settings, VirtualFile root, RepositoryLocation location, int maxCount) throws VcsException, IOException {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        if (cacheFile.isEmpty()) {
            List<CommittedChangeList> changes = this.initCache(cacheFile);
            if (this.canGetFromCache(vcs, settings, root, location, maxCount)) {
                settings.filterChanges(changes);
                return CommittedChangesCache.trimToSize(changes, maxCount);
            }
            return cacheFile.getProvider().getCommittedChanges(settings, location, maxCount);
        }
        RepositoryLocation fileLocation = cacheFile.getLocation();
        fileLocation.onBeforeBatch();
        List<CommittedChangeList> changes = cacheFile.readChanges(settings, maxCount);
        fileLocation.onAfterBatch();
        List<CommittedChangeList> newChanges = this.refreshCache(cacheFile);
        settings.filterChanges(newChanges);
        changes.addAll(newChanges);
        return CommittedChangesCache.trimToSize(changes, maxCount);
    }

    public void refreshAllCaches() throws IOException, VcsException {
        CommittedChangesCache.debug("Start refreshing all caches");
        Collection<ChangesCacheFile> files = this.myCachesHolder.getAllCaches();
        CommittedChangesCache.debug(files.size() + " caches found");
        for (ChangesCacheFile file2 : files) {
            if (file2.isEmpty()) {
                this.initCache(file2);
                continue;
            }
            this.refreshCache(file2);
        }
        CommittedChangesCache.debug("Finished refreshing all caches");
    }

    private List<CommittedChangeList> initCache(ChangesCacheFile cacheFile) throws VcsException, IOException {
        CommittedChangesCache.debug("Initializing cache for " + cacheFile.getLocation());
        CachingCommittedChangesProvider provider = cacheFile.getProvider();
        RepositoryLocation location = cacheFile.getLocation();
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        int maxCount = 0;
        if (this.isMaxCountSupportedForProject()) {
            maxCount = this.myState.getInitialCount();
        } else {
            settings.USE_DATE_AFTER_FILTER = true;
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -this.myState.getInitialDays());
            settings.setDateAfter(calendar.getTime());
        }
        List changes = provider.getCommittedChanges(settings, location, maxCount);
        CommittedChangesCache.writeChangesInReadAction(cacheFile, changes);
        if (maxCount > 0 && changes.size() < this.myState.getInitialCount()) {
            cacheFile.setHaveCompleteHistory(true);
        }
        if (changes.size() > 0) {
            this.fireChangesLoaded(location, changes);
        }
        return changes;
    }

    private void fireChangesLoaded(RepositoryLocation location, List<CommittedChangeList> changes) {
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher(this.myProject, COMMITTED_TOPIC, listener2 -> listener2.changesLoaded(location, changes));
    }

    private void fireIncomingReloaded() {
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher(this.myProject, COMMITTED_TOPIC, listener2 -> listener2.incomingChangesUpdated(Collections.emptyList()));
    }

    private List<CommittedChangeList> refreshCache(ChangesCacheFile cacheFile) throws VcsException, IOException {
        CommittedChangesCache.debug("Refreshing cache for " + cacheFile.getLocation());
        ArrayList<CommittedChangeList> newLists = new ArrayList<CommittedChangeList>();
        CachingCommittedChangesProvider provider = cacheFile.getProvider();
        RepositoryLocation location = cacheFile.getLocation();
        Pair<Long, List<CommittedChangeList>> externalLists = this.myExternallyLoadedChangeLists.get(location.getKey());
        long latestChangeList = this.getLatestListForFile(cacheFile);
        if (externalLists != null && latestChangeList == (Long)externalLists.first) {
            newLists.addAll(this.appendLoadedChanges(cacheFile, location, (List)externalLists.second));
            this.myExternallyLoadedChangeLists.clear();
        }
        ChangeBrowserSettings defaultSettings = provider.createDefaultSettings();
        int maxCount = 0;
        if (provider.refreshCacheByNumber()) {
            long number = cacheFile.getLastCachedChangelist();
            CommittedChangesCache.debug("Refreshing cache for " + location + " since #" + number);
            if (number >= 0L) {
                defaultSettings.CHANGE_AFTER = Long.toString(number);
                defaultSettings.USE_CHANGE_AFTER_FILTER = true;
            } else {
                maxCount = this.myState.getInitialCount();
            }
        } else {
            Date date = cacheFile.getLastCachedDate();
            CommittedChangesCache.debug("Refreshing cache for " + location + " since " + date);
            defaultSettings.setDateAfter(date);
            defaultSettings.USE_DATE_AFTER_FILTER = true;
        }
        defaultSettings.STRICTLY_AFTER = true;
        List newChanges = provider.getCommittedChanges(defaultSettings, location, maxCount);
        CommittedChangesCache.debug("Loaded " + newChanges.size() + " new changelists");
        newLists.addAll(this.appendLoadedChanges(cacheFile, location, newChanges));
        return newLists;
    }

    private static void debug(@NonNls String message2) {
        LOG.debug(message2);
    }

    private List<CommittedChangeList> appendLoadedChanges(ChangesCacheFile cacheFile, RepositoryLocation location, List<CommittedChangeList> newChanges) throws IOException {
        List<CommittedChangeList> savedChanges = CommittedChangesCache.writeChangesInReadAction(cacheFile, newChanges);
        if (savedChanges.size() > 0) {
            this.fireChangesLoaded(location, savedChanges);
        }
        return savedChanges;
    }

    private static List<CommittedChangeList> writeChangesInReadAction(ChangesCacheFile cacheFile, List<CommittedChangeList> newChanges) throws IOException {
        for (CommittedChangeList changeList : newChanges) {
            changeList.getChanges();
        }
        Ref ref = new Ref();
        List savedChanges = (List)ReadAction.compute(() -> {
            try {
                return cacheFile.writeChanges(newChanges);
            }
            catch (IOException e) {
                ref.set((Object)e);
                return null;
            }
        });
        if (!ref.isNull()) {
            throw (IOException)ref.get();
        }
        return savedChanges;
    }

    private static List<CommittedChangeList> trimToSize(List<CommittedChangeList> changes, int maxCount) {
        if (maxCount > 0) {
            while (changes.size() > maxCount) {
                changes.remove(0);
            }
        }
        return changes;
    }

    public List<CommittedChangeList> loadIncomingChanges(boolean inBackground) {
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        Collection<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
        CommittedChangesCache.debug(caches.size() + " caches found");
        MultiMap byVcs = new MultiMap();
        for (ChangesCacheFile cache : caches) {
            try {
                if (inBackground && !cache.getVcs().isVcsBackgroundOperationsAllowed(cache.getRootPath().getVirtualFile())) continue;
                if (!cache.isEmpty()) {
                    CommittedChangesCache.debug("Loading incoming changes for " + cache.getLocation());
                    List<CommittedChangeList> incomingChanges = cache.loadIncomingChanges();
                    byVcs.putValue((Object)cache.getVcs(), (Object)Pair.create((Object)cache.getLocation(), incomingChanges));
                    continue;
                }
                CommittedChangesCache.debug("Empty cache found for " + cache.getLocation());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        for (AbstractVcs vcs : byVcs.keySet()) {
            CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
            VcsCommittedListsZipper vcsZipper = committedChangesProvider.getZipper();
            if (vcsZipper != null) {
                IncomingListsZipper incomingZipper = new IncomingListsZipper(vcsZipper);
                CommittedListsSequencesZipper zipper = new CommittedListsSequencesZipper((VcsCommittedListsZipper)incomingZipper);
                for (Pair pair2 : byVcs.get((Object)vcs)) {
                    zipper.add((RepositoryLocation)pair2.getFirst(), (List)pair2.getSecond());
                }
                result2.addAll(zipper.execute());
                continue;
            }
            for (Pair pair3 : byVcs.get((Object)vcs)) {
                result2.addAll((Collection)pair3.getSecond());
            }
        }
        this.myCachedIncomingChangeLists = result2;
        CommittedChangesCache.debug("Incoming changes loaded");
        this.notifyIncomingChangesUpdated(result2);
        return result2;
    }

    public void commitMessageChanged(AbstractVcs vcs, RepositoryLocation location, long number, String newMessage) {
        this.myTaskQueue.run(() -> {
            ChangesCacheFile file2 = this.myCachesHolder.haveCache(location);
            if (file2 != null) {
                try {
                    if (file2.isEmpty()) {
                        return;
                    }
                    file2.editChangelist(number, newMessage);
                    this.loadIncomingChanges(true);
                    this.fireChangesLoaded(location, Collections.emptyList());
                }
                catch (IOException e) {
                    VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "Didn't update Repository changes with new message due to error: " + e.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
                }
            }
        });
    }

    public void loadIncomingChangesAsync(@Nullable Consumer<List<CommittedChangeList>> consumer, boolean inBackground) {
        CommittedChangesCache.debug("Loading incoming changes");
        Runnable task = () -> {
            List<CommittedChangeList> list2 = this.loadIncomingChanges(inBackground);
            if (consumer != null) {
                consumer.consume(new ArrayList<CommittedChangeList>(list2));
            }
        };
        this.myTaskQueue.run(task);
    }

    public void clearCaches(Runnable continuation) {
        this.myTaskQueue.run(() -> {
            this.myCachesHolder.clearAllCaches();
            this.myCachedIncomingChangeLists = null;
            continuation.run();
            MessageBusUtil.invokeLaterIfNeededOnSyncPublisher(this.myProject, COMMITTED_TOPIC, listener2 -> listener2.changesCleared());
        });
    }

    @Nullable
    public List<CommittedChangeList> getCachedIncomingChanges() {
        return this.myCachedIncomingChangeLists;
    }

    public void processUpdatedFiles(UpdatedFiles updatedFiles) {
        this.processUpdatedFiles(updatedFiles, null);
    }

    public void processUpdatedFiles(UpdatedFiles updatedFiles, @Nullable Consumer<List<CommittedChangeList>> incomingChangesConsumer) {
        Runnable task = () -> {
            CommittedChangesCache.debug("Processing updated files");
            Collection<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
            this.myPendingUpdateCount += caches.size();
            for (ChangesCacheFile cache : caches) {
                try {
                    if (cache.isEmpty()) {
                        this.pendingUpdateProcessed(incomingChangesConsumer);
                        continue;
                    }
                    CommittedChangesCache.debug("Processing updated files in " + cache.getLocation());
                    boolean needRefresh = cache.processUpdatedFiles(updatedFiles, this.myNewIncomingChanges);
                    if (needRefresh) {
                        CommittedChangesCache.debug("Found unaccounted files, requesting refresh");
                        this.processUpdatedFilesAfterRefresh(cache, updatedFiles, incomingChangesConsumer);
                        continue;
                    }
                    CommittedChangesCache.debug("Clearing cached incoming changelists");
                    this.myCachedIncomingChangeLists = null;
                    this.pendingUpdateProcessed(incomingChangesConsumer);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        this.myTaskQueue.run(task);
    }

    private void pendingUpdateProcessed(@Nullable Consumer<List<CommittedChangeList>> incomingChangesConsumer) {
        --this.myPendingUpdateCount;
        if (this.myPendingUpdateCount == 0) {
            this.notifyIncomingChangesUpdated(this.myNewIncomingChanges);
            if (incomingChangesConsumer != null) {
                incomingChangesConsumer.consume((Object)ContainerUtil.newArrayList(this.myNewIncomingChanges));
            }
            this.myNewIncomingChanges.clear();
        }
    }

    private void processUpdatedFilesAfterRefresh(final ChangesCacheFile cache, final UpdatedFiles updatedFiles, final @Nullable Consumer<List<CommittedChangeList>> incomingChangesConsumer) {
        this.refreshCacheAsync(cache, false, new RefreshResultConsumer(){

            @Override
            public void receivedChanges(List<CommittedChangeList> committedChangeLists) {
                try {
                    CommittedChangesCache.debug("Processing updated files after refresh in " + cache.getLocation());
                    boolean result2 = true;
                    if (committedChangeLists.size() > 0) {
                        result2 = cache.processUpdatedFiles(updatedFiles, CommittedChangesCache.this.myNewIncomingChanges);
                    }
                    CommittedChangesCache.debug(result2 ? "Still have unaccounted files" : "No more unaccounted files");
                    if (result2) {
                        cache.refreshIncomingChanges();
                        CommittedChangesCache.debug("Clearing cached incoming changelists");
                        CommittedChangesCache.this.myCachedIncomingChangeLists = null;
                    }
                    CommittedChangesCache.this.pendingUpdateProcessed((Consumer<List<CommittedChangeList>>)incomingChangesConsumer);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (VcsException e) {
                    CommittedChangesCache.this.notifyRefreshError(e);
                }
            }

            @Override
            public void receivedError(VcsException ex) {
                CommittedChangesCache.this.notifyRefreshError(ex);
            }
        });
    }

    private void fireIncomingChangesUpdated(List<CommittedChangeList> lists) {
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher(this.myProject, COMMITTED_TOPIC, listener2 -> listener2.incomingChangesUpdated(new ArrayList<CommittedChangeList>(lists)));
    }

    private void notifyIncomingChangesUpdated(@Nullable Collection<CommittedChangeList> receivedChanges) {
        Collection<CommittedChangeList> changes;
        Collection<CommittedChangeList> collection = changes = receivedChanges == null ? this.myCachedIncomingChangeLists : receivedChanges;
        if (changes == null) {
            Application application = ApplicationManager.getApplication();
            Runnable runnable2 = () -> {
                List<CommittedChangeList> lists = this.loadIncomingChanges(true);
                this.fireIncomingChangesUpdated(lists);
            };
            if (application.isDispatchThread()) {
                this.myTaskQueue.run(runnable2);
            } else {
                runnable2.run();
            }
            return;
        }
        ArrayList<CommittedChangeList> listCopy = new ArrayList<CommittedChangeList>(changes);
        this.fireIncomingChangesUpdated(listCopy);
    }

    private void notifyRefreshError(VcsException e) {
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher(this.myProject, COMMITTED_TOPIC, listener2 -> listener2.refreshErrorStatusChanged(e));
    }

    public boolean isRefreshingIncomingChanges() {
        return this.myRefreshingIncomingChanges;
    }

    public boolean refreshIncomingChanges() {
        boolean hasChanges = false;
        Collection<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
        for (ChangesCacheFile file2 : caches) {
            try {
                if (file2.isEmpty()) continue;
                CommittedChangesCache.debug("Refreshing incoming changes for " + file2.getLocation());
                boolean changesForCache = file2.refreshIncomingChanges();
                hasChanges |= changesForCache;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (VcsException e) {
                this.notifyRefreshError(e);
            }
        }
        return hasChanges;
    }

    public void refreshIncomingChangesAsync() {
        CommittedChangesCache.debug("Refreshing incoming changes in background");
        this.myRefreshingIncomingChanges = true;
        Runnable task = () -> {
            this.refreshIncomingChanges();
            this.refreshIncomingUi();
        };
        this.myTaskQueue.run(task);
    }

    private void refreshIncomingUi() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myRefreshingIncomingChanges = false;
            CommittedChangesCache.debug("Incoming changes refresh complete, clearing cached incoming changes");
            this.notifyReloadIncomingChanges();
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    public void refreshAllCachesAsync(boolean initIfEmpty, boolean inBackground) {
        Runnable task = () -> {
            final Collection<ChangesCacheFile> files = this.myCachesHolder.getAllCaches();
            RefreshResultConsumer notifyConsumer = new RefreshResultConsumer(){
                private VcsException myError = null;
                private int myCount = 0;
                private int totalChangesCount = 0;

                @Override
                public void receivedChanges(List<CommittedChangeList> changes) {
                    this.totalChangesCount += changes.size();
                    this.checkDone();
                }

                @Override
                public void receivedError(VcsException ex) {
                    this.myError = ex;
                    this.checkDone();
                }

                private void checkDone() {
                    ++this.myCount;
                    if (this.myCount == files.size()) {
                        CommittedChangesCache.this.myTaskQueue.run(() -> {
                            if (this.totalChangesCount > 0) {
                                CommittedChangesCache.this.notifyReloadIncomingChanges();
                            } else {
                                ((CommittedChangesTreeBrowser.CommittedChangesReloadListener)CommittedChangesCache.this.myProject.getMessageBus().syncPublisher(CommittedChangesTreeBrowser.ITEMS_RELOADED)).emptyRefresh();
                            }
                        });
                        CommittedChangesCache.this.notifyRefreshError(this.myError);
                    }
                }
            };
            for (ChangesCacheFile file2 : files) {
                if (inBackground && !file2.getVcs().isVcsBackgroundOperationsAllowed(file2.getRootPath().getVirtualFile())) continue;
                this.refreshCacheAsync(file2, initIfEmpty, notifyConsumer, false);
            }
        };
        this.myTaskQueue.run(task);
    }

    private void notifyReloadIncomingChanges() {
        this.myCachedIncomingChangeLists = null;
        this.notifyIncomingChangesUpdated(null);
    }

    private void refreshCacheAsync(ChangesCacheFile cache, boolean initIfEmpty, @Nullable RefreshResultConsumer consumer) {
        this.refreshCacheAsync(cache, initIfEmpty, consumer, true);
    }

    private void refreshCacheAsync(ChangesCacheFile cache, boolean initIfEmpty, @Nullable RefreshResultConsumer consumer, boolean asynch) {
        try {
            if (!initIfEmpty && cache.isEmpty()) {
                return;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        Runnable task = () -> {
            block5: {
                try {
                    List<CommittedChangeList> list2 = initIfEmpty && cache.isEmpty() ? this.initCache(cache) : this.refreshCache(cache);
                    if (consumer != null) {
                        consumer.receivedChanges(list2);
                    }
                }
                catch (ProcessCanceledException list2) {
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (VcsException e) {
                    if (consumer == null) break block5;
                    consumer.receivedError(e);
                }
            }
        };
        if (asynch) {
            this.myTaskQueue.run(task);
        } else {
            task.run();
        }
    }

    private void updateRefreshTimer() {
        this.cancelRefreshTimer();
        if (this.myState.isRefreshEnabled()) {
            this.myRefresnRunnable = new MyRefreshRunnable(this);
            this.myFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(this.myRefresnRunnable, this.myState.getRefreshInterval() * 60, this.myState.getRefreshInterval() * 60, TimeUnit.SECONDS);
        }
    }

    private void cancelRefreshTimer() {
        if (this.myRefresnRunnable != null) {
            this.myRefresnRunnable.cancel();
            this.myRefresnRunnable = null;
        }
        if (this.myFuture != null) {
            this.myFuture.cancel(false);
            this.myFuture = null;
        }
    }

    @Nullable
    public Pair<CommittedChangeList, Change> getIncomingChangeList(VirtualFile file2) {
        if (this.myCachedIncomingChangeLists != null) {
            File ioFile = new File(file2.getPath());
            for (CommittedChangeList changeList : this.myCachedIncomingChangeLists) {
                for (Change change : changeList.getChanges()) {
                    if (!change.affectsFile(ioFile)) continue;
                    return Pair.create((Object)changeList, (Object)change);
                }
            }
        }
        return null;
    }

    private long getLatestListForFile(ChangesCacheFile file2) {
        try {
            if (file2 == null || file2.isEmpty()) {
                return -1L;
            }
            return file2.getLastCachedChangelist();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public CachesHolder getCachesHolder() {
        return this.myCachesHolder;
    }

    public void submitExternallyLoaded(RepositoryLocation location, long myLastCl, List<CommittedChangeList> lists) {
        this.myExternallyLoadedChangeLists.put(location.getKey(), (Pair<Long, List<CommittedChangeList>>)new Pair((Object)myLastCl, lists));
    }

    public RepositoryLocationCache getLocationCache() {
        return this.myLocationCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/committed/CommittedChangesCache", "getChanges"));
    }

    private static class MyRefreshRunnable
    implements Runnable {
        private CommittedChangesCache myCache;

        private MyRefreshRunnable(CommittedChangesCache cache) {
            this.myCache = cache;
        }

        private void cancel() {
            this.myCache = null;
        }

        @Override
        public void run() {
            CommittedChangesCache cache = this.myCache;
            if (cache == null) {
                return;
            }
            cache.refreshAllCachesAsync(false, true);
            for (ChangesCacheFile file2 : cache.getCachesHolder().getAllCaches()) {
                if (!file2.getVcs().isVcsBackgroundOperationsAllowed(file2.getRootPath().getVirtualFile()) || !file2.getProvider().refreshIncomingWithCommitted()) continue;
                cache.refreshIncomingChangesAsync();
                break;
            }
        }
    }

    private static interface RefreshResultConsumer {
        public void receivedChanges(List<CommittedChangeList> var1);

        public void receivedError(VcsException var1);
    }

    private static class IncomingListsZipper
    extends VcsCommittedListsZipperAdapter {
        private final VcsCommittedListsZipper myVcsZipper;

        private IncomingListsZipper(VcsCommittedListsZipper vcsZipper) {
            super(null);
            this.myVcsZipper = vcsZipper;
        }

        public Pair<List<RepositoryLocationGroup>, List<RepositoryLocation>> groupLocations(List<RepositoryLocation> in) {
            return this.myVcsZipper.groupLocations(in);
        }

        public CommittedChangeList zip(RepositoryLocationGroup group, List<CommittedChangeList> lists) {
            if (lists.size() == 1) {
                return lists.get(0);
            }
            CommittedChangeList victim = ReceivedChangeList.unwrap(lists.get(0));
            ReceivedChangeList result2 = new ReceivedChangeList(victim);
            result2.setForcePartial(false);
            HashSet baseChanges = new HashSet();
            for (CommittedChangeList list2 : lists) {
                baseChanges.addAll(ReceivedChangeList.unwrap(list2).getChanges());
                Collection changes = list2.getChanges();
                for (Change change : changes) {
                    if (result2.getChanges().contains(change)) continue;
                    result2.addChange(change);
                }
            }
            result2.setForcePartial(baseChanges.size() != result2.getChanges().size());
            return result2;
        }

        public long getNumber(CommittedChangeList list2) {
            return this.myVcsZipper.getNumber(list2);
        }
    }

    private class MyProjectChangesLoader
    implements Runnable {
        private final ChangeBrowserSettings mySettings;
        private final int myMaxCount;
        private final boolean myCacheOnly;
        private final Consumer<List<CommittedChangeList>> myConsumer;
        private final Consumer<List<VcsException>> myErrorConsumer;
        private final LinkedHashSet<CommittedChangeList> myResult = new LinkedHashSet();
        private final List<VcsException> myExceptions = new ArrayList<VcsException>();
        private boolean myDisposed = false;

        private MyProjectChangesLoader(ChangeBrowserSettings settings, int maxCount, boolean cacheOnly, Consumer<List<CommittedChangeList>> consumer, Consumer<List<VcsException>> errorConsumer) {
            this.mySettings = settings;
            this.myMaxCount = maxCount;
            this.myCacheOnly = cacheOnly;
            this.myConsumer = consumer;
            this.myErrorConsumer = errorConsumer;
        }

        @Override
        public void run() {
            for (AbstractVcs vcs : CommittedChangesCache.this.myVcsManager.getAllActiveVcss()) {
                CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
                if (provider == null) continue;
                VcsCommittedListsZipper vcsZipper = provider.getZipper();
                CommittedListsSequencesZipper zipper = null;
                if (vcsZipper != null) {
                    zipper = new CommittedListsSequencesZipper(vcsZipper);
                }
                boolean zipSupported = zipper != null;
                Map<VirtualFile, RepositoryLocation> map = CommittedChangesCache.this.myCachesHolder.getAllRootsUnderVcs(vcs);
                for (VirtualFile root : map.keySet()) {
                    if (CommittedChangesCache.this.myProject.isDisposed()) {
                        return;
                    }
                    RepositoryLocation location = map.get(root);
                    try {
                        List<CommittedChangeList> lists = CommittedChangesCache.this.getChanges(this.mySettings, root, vcs, this.myMaxCount, this.myCacheOnly, provider, location);
                        if (lists == null) continue;
                        if (zipSupported) {
                            zipper.add(location, lists);
                            continue;
                        }
                        this.myResult.addAll(lists);
                    }
                    catch (VcsException e) {
                        this.myExceptions.add(e);
                    }
                    catch (ProcessCanceledException e) {
                        this.myDisposed = true;
                    }
                }
                if (!zipSupported) continue;
                this.myResult.addAll(zipper.execute());
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                LOG.info("FINISHED CommittedChangesCache.getProjectChangesAsync - execution in queue");
                if (CommittedChangesCache.this.myProject.isDisposed()) {
                    return;
                }
                if (this.myExceptions.size() > 0) {
                    this.myErrorConsumer.consume(this.myExceptions);
                } else if (!this.myDisposed) {
                    this.myConsumer.consume(new ArrayList<CommittedChangeList>(this.myResult));
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public static class State {
        private int myInitialCount = 500;
        private int myInitialDays = 90;
        private int myRefreshInterval = 30;
        private boolean myRefreshEnabled = false;

        public int getInitialCount() {
            return this.myInitialCount;
        }

        public void setInitialCount(int initialCount) {
            this.myInitialCount = initialCount;
        }

        public int getInitialDays() {
            return this.myInitialDays;
        }

        public void setInitialDays(int initialDays) {
            this.myInitialDays = initialDays;
        }

        public int getRefreshInterval() {
            return this.myRefreshInterval;
        }

        public void setRefreshInterval(int refreshInterval) {
            this.myRefreshInterval = refreshInterval;
        }

        public boolean isRefreshEnabled() {
            return this.myRefreshEnabled;
        }

        public void setRefreshEnabled(boolean refreshEnabled) {
            this.myRefreshEnabled = refreshEnabled;
        }
    }
}

