/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.pom.Navigatable;
import java.util.stream.Stream;
import javax.swing.Icon;

class EditSourceFromChangesBrowserAction
extends EditSourceAction {
    private final Icon myEditSourceIcon = AllIcons.Actions.EditSource;

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        event.getPresentation().setIcon(this.myEditSourceIcon);
        event.getPresentation().setText("Edit Source");
        if (!ModalityState.NON_MODAL.equals(ModalityState.current()) || CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(event.getDataContext()))) {
            event.getPresentation().setEnabled(false);
        }
    }

    @Override
    protected Navigatable[] getNavigatables(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Change[] changes = (Change[])VcsDataKeys.SELECTED_CHANGES.getData(dataContext);
        return changes != null && project2 != null ? ChangesUtil.getNavigatableArray((Project)project2, (Stream)ChangesUtil.getFiles(Stream.of(changes))) : null;
    }
}

