/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.UnshelvePatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelveWithDialogAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)ObjectUtils.assertNotNull((Object)UnshelveWithDialogAction.getEventProject((AnActionEvent)e));
        DataContext dataContext = e.getDataContext();
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dataContext);
        if (changeLists.isEmpty()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (changeLists.size() > 1) {
            UnshelveWithDialogAction.unshelveMultipleShelveChangeLists(project2, changeLists, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext), ShelvedChangesViewManager.getShelveChanges(dataContext));
        } else {
            ShelvedChangeList changeList = changeLists.get(0);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(changeList.PATH));
            if (virtualFile == null) {
                VcsBalloonProblemNotifier.showOverChangesView(project2, "Can not find path file", MessageType.ERROR, new NamedRunnable[0]);
                return;
            }
            List binaryShelvedPatches = ContainerUtil.map(changeList.getBinaryFiles(), ShelvedBinaryFilePatch::new);
            MyUnshelveDialog dialog2 = new MyUnshelveDialog(project2, virtualFile, changeList, binaryShelvedPatches, (Change[])e.getData(VcsDataKeys.CHANGES));
            dialog2.setHelpId("reference.dialogs.vcs.unshelve");
            dialog2.show();
        }
    }

    private static void unshelveMultipleShelveChangeLists(final @NotNull Project project2, @NotNull List<ShelvedChangeList> changeLists, @NotNull List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> changes) {
        if (project2 == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(0);
        }
        if (changeLists == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(1);
        }
        if (binaryFiles == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(3);
        }
        String suggestedName = changeLists.get((int)0).DESCRIPTION;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        ChangeListChooser chooser = new ChangeListChooser(project2, changeListManager.getChangeListsCopy(), (ChangeList)changeListManager.getDefaultChangeList(), VcsBundle.message((String)"unshelve.changelist.chooser.title", (Object[])new Object[0]), suggestedName){

            protected JComponent createDoNotAskCheckbox() {
                return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(project2);
            }
        };
        if (!chooser.showAndGet()) {
            return;
        }
        ShelveChangesManager.getInstance(project2).unshelveSilentlyAsynchronously(project2, changeLists, changes, binaryFiles, chooser.getSelectedList());
    }

    private static boolean hasNotAllSelectedChanges(@NotNull Project project2, @NotNull ShelvedChangeList list2, @Nullable Change[] changes) {
        if (project2 == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(4);
        }
        if (list2 == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(5);
        }
        return changes != null && list2.getChanges(project2).size() + list2.getBinaryFiles().size() != changes.length;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(UnshelveWithDialogAction.getEventProject((AnActionEvent)e) != null && !ShelvedChangesViewManager.getShelvedLists(e.getDataContext()).isEmpty());
    }

    @NotNull
    private static JCheckBox createRemoveFilesStrategyCheckbox(@NotNull Project project2) {
        if (project2 == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(6);
        }
        final JCheckBox removeOptionCheckBox = new JCheckBox("Remove successfully applied files from the shelf");
        removeOptionCheckBox.setMnemonic(82);
        final ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project2);
        removeOptionCheckBox.setSelected(shelveChangesManager.isRemoveFilesFromShelf());
        removeOptionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shelveChangesManager.setRemoveFilesFromShelf(removeOptionCheckBox.isSelected());
            }
        });
        JCheckBox jCheckBox = removeOptionCheckBox;
        if (jCheckBox == null) {
            UnshelveWithDialogAction.$$$reportNull$$$0(7);
        }
        return jCheckBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveFilesStrategyCheckbox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unshelveMultipleShelveChangeLists";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasNotAllSelectedChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveFilesStrategyCheckbox";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyUnshelveDialog
    extends ApplyPatchDifferentiatedDialog {
        public MyUnshelveDialog(@NotNull Project project2, @NotNull VirtualFile patchFile, @NotNull ShelvedChangeList changeList, @NotNull List<ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Change[] preselectedChanges) {
            if (project2 == null) {
                MyUnshelveDialog.$$$reportNull$$$0(0);
            }
            if (patchFile == null) {
                MyUnshelveDialog.$$$reportNull$$$0(1);
            }
            if (changeList == null) {
                MyUnshelveDialog.$$$reportNull$$$0(2);
            }
            if (binaryShelvedPatches == null) {
                MyUnshelveDialog.$$$reportNull$$$0(3);
            }
            super(project2, new UnshelvePatchDefaultExecutor(project2, changeList), Collections.emptyList(), ApplyPatchMode.UNSHELVE, patchFile, null, ChangeListUtil.getPredefinedChangeList(changeList, ChangeListManager.getInstance((Project)project2)), binaryShelvedPatches, UnshelveWithDialogAction.hasNotAllSelectedChanges(project2, changeList, preselectedChanges) ? ContainerUtil.newArrayList((Object[])preselectedChanges) : null, ChangeListUtil.getChangeListNameForUnshelve(changeList), true);
        }

        @Nullable
        protected JComponent createDoNotAskCheckbox() {
            return UnshelveWithDialogAction.createRemoveFilesStrategyCheckbox(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "patchFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "binaryShelvedPatches";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction$MyUnshelveDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

