/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserFileNode
extends ChangesBrowserNode<VirtualFile>
implements Comparable<ChangesBrowserFileNode> {
    private final Project myProject;
    private final String myName;

    public ChangesBrowserFileNode(Project project2, @NotNull VirtualFile userObject) {
        if (userObject == null) {
            ChangesBrowserFileNode.$$$reportNull$$$0(0);
        }
        super(userObject);
        this.myName = StringUtil.toLowerCase((String)userObject.getName());
        this.myProject = project2;
    }

    @Override
    protected boolean isFile() {
        return !((VirtualFile)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ((VirtualFile)this.getUserObject()).isDirectory() && (this.isLeaf() || FileStatusManager.getInstance((Project)this.myProject).getStatus((VirtualFile)this.getUserObject()) != FileStatus.NOT_CHANGED);
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        VirtualFile file2 = (VirtualFile)this.getUserObject();
        FileStatus fileStatus = ChangeListManager.getInstance((Project)this.myProject).getStatus(file2);
        renderer.appendFileName(file2, file2.getName(), fileStatus.getColor());
        if (renderer.isShowFlatten() && file2.isValid()) {
            this.appendParentPath(renderer, file2.getParent().getPresentableUrl());
        }
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        renderer.setIcon(file2.getFileType(), file2.isDirectory());
    }

    @Override
    public String getTextPresentation() {
        return ((VirtualFile)this.getUserObject()).getName();
    }

    @Override
    public String toString() {
        return ((VirtualFile)this.getUserObject()).getPresentableUrl();
    }

    @Override
    public int getSortWeight() {
        return 8;
    }

    @Override
    public int compareTo(ChangesBrowserFileNode o) {
        return this.myName.compareTo(o.myName);
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof VirtualFile) {
            return ((VirtualFile)this.getUserObject()).getName().compareToIgnoreCase(((VirtualFile)o2).getName());
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserFileNode", "<init>"));
    }
}

