/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CommitLegendPanel {
    @NotNull
    private final SimpleColoredComponent myRootPanel;
    @NotNull
    private final InfoCalculator myInfoCalculator;

    public CommitLegendPanel(@NotNull InfoCalculator infoCalculator) {
        if (infoCalculator == null) {
            CommitLegendPanel.$$$reportNull$$$0(0);
        }
        this.myInfoCalculator = infoCalculator;
        this.myRootPanel = new SimpleColoredComponent();
    }

    @NotNull
    public JComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.myRootPanel;
        if (simpleColoredComponent == null) {
            CommitLegendPanel.$$$reportNull$$$0(1);
        }
        return simpleColoredComponent;
    }

    public void update() {
        this.myRootPanel.clear();
        this.appendText(this.myInfoCalculator.getNew(), this.myInfoCalculator.getIncludedNew(), FileStatus.ADDED, VcsBundle.message((String)"commit.legend.new", (Object[])new Object[0]));
        this.appendText(this.myInfoCalculator.getModified(), this.myInfoCalculator.getIncludedModified(), FileStatus.MODIFIED, VcsBundle.message((String)"commit.legend.modified", (Object[])new Object[0]));
        this.appendText(this.myInfoCalculator.getDeleted(), this.myInfoCalculator.getIncludedDeleted(), FileStatus.DELETED, VcsBundle.message((String)"commit.legend.deleted", (Object[])new Object[0]));
        this.appendText(this.myInfoCalculator.getUnversioned(), this.myInfoCalculator.getIncludedUnversioned(), FileStatus.UNKNOWN, VcsBundle.message((String)"commit.legend.unversioned", (Object[])new Object[0]));
    }

    protected void appendText(int total, int included, @NotNull FileStatus fileStatus, @NotNull String labelName) {
        if (fileStatus == null) {
            CommitLegendPanel.$$$reportNull$$$0(2);
        }
        if (labelName == null) {
            CommitLegendPanel.$$$reportNull$$$0(3);
        }
        if (total > 0) {
            if (!this.isPanelEmpty()) {
                this.appendSpace();
            }
            String pattern = total == included ? "%s %d" : "%s %d of %d";
            String text2 = String.format(pattern, labelName, included, total);
            this.myRootPanel.append(text2, new SimpleTextAttributes(0, fileStatus.getColor()));
        }
    }

    private boolean isPanelEmpty() {
        return !this.myRootPanel.iterator().hasNext();
    }

    protected final void appendSpace() {
        this.myRootPanel.append("   ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoCalculator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitLegendPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitLegendPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface InfoCalculator {
        public int getNew();

        public int getModified();

        public int getDeleted();

        public int getUnversioned();

        public int getIncludedNew();

        public int getIncludedModified();

        public int getIncludedDeleted();

        public int getIncludedUnversioned();
    }
}

