/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DefaultCommitResultHandler
implements CommitResultHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<Change> myIncludedChanges;
    @NotNull
    private final String myCommitMessage;
    @NotNull
    private final CommitHelper.GeneralCommitProcessor myCommitProcessor;
    @NotNull
    private final Set<String> myFeedback;

    public DefaultCommitResultHandler(@NotNull Project project2, @NotNull Collection<Change> includedChanges, @NotNull String commitMessage, @NotNull CommitHelper.GeneralCommitProcessor commitProcessor, @NotNull Set<String> feedback) {
        if (project2 == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(0);
        }
        if (includedChanges == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(1);
        }
        if (commitMessage == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(2);
        }
        if (commitProcessor == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(3);
        }
        if (feedback == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(4);
        }
        this.myProject = project2;
        this.myIncludedChanges = includedChanges;
        this.myCommitMessage = commitMessage;
        this.myCommitProcessor = commitProcessor;
        this.myFeedback = feedback;
    }

    public void onSuccess(@NotNull String commitMessage) {
        if (commitMessage == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(5);
        }
        this.reportResult();
    }

    public void onFailure() {
        this.reportResult();
    }

    private void reportResult() {
        List<VcsException> errors = CommitHelper.collectErrors(this.myCommitProcessor.getVcsExceptions());
        int errorsSize = errors.size();
        int warningsSize = this.myCommitProcessor.getVcsExceptions().size() - errorsSize;
        VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
        String message2 = this.getCommitSummary();
        if (errorsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])new Object[0]), (int)errorsSize);
            notifier.notifyError(title, message2);
        } else if (warningsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])new Object[0]), (int)warningsSize);
            notifier.notifyImportantWarning(title, message2);
        } else {
            notifier.notifySuccess(message2);
        }
    }

    @NotNull
    private String getCommitSummary() {
        List<VcsException> exceptions;
        StringBuilder content = new StringBuilder(this.getFileSummaryReport(this.myCommitProcessor.getChangesFailedToCommit()));
        if (!StringUtil.isEmpty((String)this.myCommitMessage)) {
            content.append(": ").append(DefaultCommitResultHandler.escape(this.myCommitMessage));
        }
        if (!this.myFeedback.isEmpty()) {
            content.append("<br/>");
            content.append(StringUtil.join(this.myFeedback, (String)"<br/>"));
        }
        if (!CommitHelper.hasOnlyWarnings(exceptions = this.myCommitProcessor.getVcsExceptions())) {
            content.append("<br/>");
            content.append(StringUtil.join(exceptions, Throwable::getMessage, (String)"<br/>"));
        }
        String string = content.toString();
        if (string == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private String getFileSummaryReport(@NotNull List<Change> changesFailedToCommit) {
        if (changesFailedToCommit == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(7);
        }
        int failed = changesFailedToCommit.size();
        int committed = this.myIncludedChanges.size() - failed;
        String fileSummary = committed + " " + StringUtil.pluralize((String)"file", (int)committed) + " committed";
        if (failed > 0) {
            fileSummary = fileSummary + ", " + failed + " " + StringUtil.pluralize((String)"file", (int)failed) + " failed to commit";
        }
        String string = fileSummary;
        if (string == null) {
            DefaultCommitResultHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static String escape(String s) {
        String[] FROM = new String[]{"<", ">"};
        String[] TO = new String[]{"&lt;", "&gt;"};
        return StringUtil.replace((String)s, (String[])FROM, (String[])TO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedChanges";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feedback";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesFailedToCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitSummary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSummaryReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileSummaryReport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

