/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    @NotNull
    private final ToggleChangeDiffAction myToggleChangeDiffAction;
    @Nullable
    private Set<String> myChangeListNames;

    public LocalChangesBrowser(@NotNull Project project2) {
        if (project2 == null) {
            LocalChangesBrowser.$$$reportNull$$$0(0);
        }
        super(project2, true, true);
        this.myToggleChangeDiffAction = new ToggleChangeDiffAction();
        this.installChangeListListener();
        this.init();
        this.myViewer.rebuildTree();
    }

    public void dispose() {
    }

    private void installChangeListListener() {
        MyChangeListListener changeListListener = new MyChangeListListener();
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)changeListListener);
        Disposer.register((Disposable)this, () -> ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)changeListListener));
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        List list2 = ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{this.myToggleChangeDiffAction});
        if (list2 == null) {
            LocalChangesBrowser.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel(boolean showFlatten) {
        List lists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        if (this.myChangeListNames != null) {
            lists = ContainerUtil.filter((Collection)lists, list2 -> this.myChangeListNames.contains(list2.getName()));
        }
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChangeLists(this.myProject, showFlatten, lists);
        if (defaultTreeModel == null) {
            LocalChangesBrowser.$$$reportNull$$$0(2);
        }
        return defaultTreeModel;
    }

    public void setIncludedChanges(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            LocalChangesBrowser.$$$reportNull$$$0(3);
        }
        this.myViewer.setIncludedChanges(changes);
    }

    public List<Change> getAllChanges() {
        return VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getIncludedChanges() {
        return VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
    }

    public void setToggleActionTitle(@Nullable String title) {
        this.myToggleChangeDiffAction.getTemplatePresentation().setText(title);
    }

    public void setChangeLists(@Nullable List<LocalChangeList> changeLists) {
        this.myChangeListNames = changeLists != null ? ContainerUtil.map2Set(changeLists, LocalChangeList::getName) : null;
        this.myViewer.rebuildTree();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LocalChangesBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        @NotNull
        private final MergingUpdateQueue myUpdateQueue;

        private MyChangeListListener() {
            this.myUpdateQueue = new MergingUpdateQueue("LocalChangesViewer", 300, true, (JComponent)LocalChangesBrowser.this, (Disposable)LocalChangesBrowser.this);
        }

        private void doUpdate() {
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    LocalChangesBrowser.this.myViewer.rebuildTree();
                }
            });
        }

        public void changeListAdded(ChangeList list2) {
            this.doUpdate();
        }

        public void changeListRemoved(ChangeList list2) {
            this.doUpdate();
        }

        public void changeListRenamed(ChangeList list2, String oldName) {
            this.doUpdate();
        }

        public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
            this.doUpdate();
        }

        public void changesAdded(Collection<Change> changes, ChangeList toList) {
            this.doUpdate();
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            this.doUpdate();
        }
    }

    private class ToggleChangeDiffAction
    extends CheckboxAction
    implements DumbAware {
        public ToggleChangeDiffAction() {
            super("&Include");
        }

        public boolean isSelected(AnActionEvent e) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return false;
            }
            return LocalChangesBrowser.this.myViewer.isIncluded(change);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return;
            }
            if (state) {
                LocalChangesBrowser.this.myViewer.includeChange(change);
            } else {
                LocalChangesBrowser.this.myViewer.excludeChange(change);
            }
        }
    }
}

