/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerPopup {
    @NotNull
    public final LineStatusTrackerBase myTracker;
    @NotNull
    public final Editor myEditor;
    @NotNull
    public final Range myRange;

    public LineStatusMarkerPopup(@NotNull LineStatusTrackerBase tracker, @NotNull Editor editor, @NotNull Range range) {
        if (tracker == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(1);
        }
        if (range == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(2);
        }
        this.myTracker = tracker;
        this.myEditor = editor;
        this.myRange = range;
    }

    @NotNull
    protected abstract List<AnAction> createToolbarActions(@Nullable Point var1);

    @NotNull
    protected FileType getFileType() {
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(3);
        }
        return plainTextFileType;
    }

    protected boolean isShowInnerDifferences() {
        return VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
    }

    public void scrollAndShow() {
        if (!this.myTracker.isValid()) {
            return;
        }
        Document document = this.myTracker.getDocument();
        int line = Math.min(this.myRange.getType() == 3 ? this.myRange.getLine2() : this.myRange.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
        int lastOffset = document.getLineStartOffset(line);
        this.myEditor.getCaretModel().moveToOffset(lastOffset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.showAfterScroll();
    }

    public void showAfterScroll() {
        this.myEditor.getScrollingModel().runActionOnScrollingFinished(() -> this.showHintAt(null));
    }

    public void showHint(@NotNull MouseEvent e) {
        if (e == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(4);
        }
        JComponent comp = (JComponent)e.getComponent();
        JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
        Point point = SwingUtilities.convertPoint(comp, ((EditorEx)this.myEditor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
        this.showHintAt(point);
        e.consume();
    }

    public void showHintAt(@Nullable Point mousePosition) {
        if (!this.myTracker.isValid()) {
            return;
        }
        final Disposable disposable = Disposer.newDisposable();
        FileType fileType = this.getFileType();
        List<DiffFragment> wordDiff = this.computeWordDiff();
        this.installMasterEditorHighlighters(wordDiff, disposable);
        JComponent editorComponent = this.createEditorComponent(fileType, wordDiff);
        ActionToolbar toolbar = this.buildToolbar(mousePosition, disposable);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        PopupPanel popupPanel = new PopupPanel(this.myEditor, toolbar, editorComponent);
        LightweightHint hint = new LightweightHint(popupPanel);
        HintListener closeListener = new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                Disposer.dispose((Disposable)disposable);
            }
        };
        hint.addHintListener(closeListener);
        int line = this.myEditor.getCaretModel().getLogicalPosition().line;
        Point point = HintManagerImpl.getHintPosition(hint, this.myEditor, new LogicalPosition(line, 0), (short)2);
        if (mousePosition != null) {
            int lineHeight = this.myEditor.getLineHeight();
            int delta = (point.y - mousePosition.y) % lineHeight;
            if (delta < 0) {
                delta += lineHeight;
            }
            point.y = mousePosition.y + delta;
        }
        point.x -= popupPanel.getEditorTextOffset();
        int flags = 1064;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, this.myEditor, point, flags, -1, false, new HintHint(this.myEditor, point));
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(EditorHintListener.TOPIC, (project2, newHint, newHintFlags) -> {
            PopupPanel newPopupPanel;
            if (newHint.getComponent() instanceof PopupPanel && (newPopupPanel = (PopupPanel)newHint.getComponent()).getEditor().equals(this.myEditor)) {
                hint.hide();
            }
        });
        if (!hint.isVisible()) {
            closeListener.hintHidden(null);
        }
    }

    @Nullable
    private List<DiffFragment> computeWordDiff() {
        if (!this.isShowInnerDifferences()) {
            return null;
        }
        if (this.myRange.getType() != 1) {
            return null;
        }
        CharSequence vcsContent = this.myTracker.getVcsContent(this.myRange);
        CharSequence currentContent = this.myTracker.getCurrentContent(this.myRange);
        return (List)BackgroundTaskUtil.tryComputeFast(indicator -> ByWord.compare(vcsContent, currentContent, ComparisonPolicy.DEFAULT, indicator), 200L);
    }

    private void installMasterEditorHighlighters(@Nullable List<DiffFragment> wordDiff, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(5);
        }
        if (wordDiff == null) {
            return;
        }
        final ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        int currentStartShift = this.myTracker.getCurrentTextRange(this.myRange).getStartOffset();
        for (DiffFragment fragment : wordDiff) {
            int currentStart = currentStartShift + fragment.getStartOffset2();
            int currentEnd = currentStartShift + fragment.getEndOffset2();
            TextDiffType type2 = DiffUtil.getDiffType(fragment);
            highlighters.addAll(DiffDrawUtil.createInlineHighlighter(this.myEditor, currentStart, currentEnd, type2));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                for (RangeHighlighter highlighter : highlighters) {
                    highlighter.dispose();
                }
            }
        });
    }

    @Nullable
    private JComponent createEditorComponent(@Nullable FileType fileType, @Nullable List<DiffFragment> wordDiff) {
        if (this.myRange.getType() == 2) {
            return null;
        }
        Document vcsDocument = this.myTracker.getVcsDocument();
        TextRange vcsTextRange = this.myTracker.getVcsTextRange(this.myRange);
        String content = vcsTextRange.subSequence(vcsDocument.getImmutableCharSequence()).toString();
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        EditorHighlighter highlighter = highlighterFactory.createEditorHighlighter(this.myTracker.getProject(), LineStatusMarkerPopup.getFileName(this.myTracker.getDocument()));
        highlighter.setText(this.myTracker.getVcsDocument().getImmutableCharSequence());
        FragmentedEditorHighlighter fragmentedHighlighter = new FragmentedEditorHighlighter(highlighter, vcsTextRange);
        Color backgroundColor = EditorFragmentComponent.getBackgroundColor(this.myEditor, true);
        EditorTextField field = new EditorTextField(content);
        field.setBorder(null);
        field.setOneLineMode(false);
        field.ensureWillComputePreferredSize();
        field.addSettingsProvider(uEditor -> {
            uEditor.setRendererMode(true);
            uEditor.setBorder(null);
            uEditor.setColorsScheme(this.myEditor.getColorsScheme());
            uEditor.setBackgroundColor(backgroundColor);
            DiffUtil.setEditorCodeStyle(this.myTracker.getProject(), uEditor, fileType);
            uEditor.setHighlighter((EditorHighlighter)fragmentedHighlighter);
            if (wordDiff != null) {
                for (DiffFragment fragment : wordDiff) {
                    int vcsStart = fragment.getStartOffset1();
                    int vcsEnd = fragment.getEndOffset1();
                    TextDiffType type2 = DiffUtil.getDiffType(fragment);
                    DiffDrawUtil.createInlineHighlighter(uEditor, vcsStart, vcsEnd, type2);
                }
            }
        });
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)((Object)field));
        panel2.setBorder(EditorFragmentComponent.createEditorFragmentBorder(this.myEditor));
        panel2.setBackground(backgroundColor);
        DataManager.registerDataProvider((JComponent)panel2, data -> {
            if (CommonDataKeys.HOST_EDITOR.is(data)) {
                return field.getEditor();
            }
            return null;
        });
        return panel2;
    }

    private static String getFileName(@NotNull Document document) {
        VirtualFile file2;
        if (document == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(6);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            return "";
        }
        return file2.getName();
    }

    @NotNull
    private ActionToolbar buildToolbar(@Nullable Point mousePosition, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(7);
        }
        final List<AnAction> actions = this.createToolbarActions(mousePosition);
        final JComponent editorComponent = this.myEditor.getComponent();
        for (AnAction action : actions) {
            DiffUtil.registerAction(action, editorComponent);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ActionUtil.getActions((JComponent)editorComponent).removeAll(actions);
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        if (actionToolbar == null) {
            LineStatusMarkerPopup.$$$reportNull$$$0(8);
        }
        return actionToolbar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installMasterEditorHighlighters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ToggleByWordDiffActionBase
    extends ToggleAction
    implements DumbAware {
        public ToggleByWordDiffActionBase() {
            super("Show Detailed Differences", null, AllIcons.Actions.PreviewDetails);
        }

        public boolean isSelected(AnActionEvent e) {
            return VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES = state;
            this.reshowPopup();
        }

        protected abstract void reshowPopup();
    }

    private static class PopupPanel
    extends JPanel {
        @Nullable
        private final JComponent myEditorComponent;
        @NotNull
        private final Editor myEditor;

        public PopupPanel(final @NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent) {
            if (editor == null) {
                PopupPanel.$$$reportNull$$$0(0);
            }
            if (toolbar == null) {
                PopupPanel.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.setOpaque(false);
            this.myEditor = editor;
            this.myEditorComponent = editorComponent;
            boolean isEditorVisible = this.myEditorComponent != null;
            Color background = ((EditorEx)editor).getBackgroundColor();
            Color borderColor = editor.getColorsScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBackground(background);
            toolbarComponent.setBorder(null);
            BorderLayoutPanel toolbarPanel = JBUI.Panels.simplePanel((Component)toolbarComponent);
            toolbarPanel.setBackground(background);
            Border outsideToolbarBorder = JBUI.Borders.customLine((Color)borderColor, (int)1, (int)1, (int)(isEditorVisible ? 0 : 1), (int)1);
            JBEmptyBorder insideToolbarBorder = JBUI.Borders.empty((int)1, (int)5, (int)1, (int)5);
            toolbarPanel.setBorder(BorderFactory.createCompoundBorder(outsideToolbarBorder, (Border)insideToolbarBorder));
            if (this.myEditorComponent != null) {
                Border outsideEditorBorder = JBUI.Borders.customLine((Color)borderColor, (int)1);
                Border insideEditorBorder = JBUI.Borders.empty((int)2);
                this.myEditorComponent.setBorder(BorderFactory.createCompoundBorder(outsideEditorBorder, insideEditorBorder));
            }
            JPanel emptyPanel = new JPanel();
            emptyPanel.setOpaque(false);
            emptyPanel.setPreferredSize(new Dimension());
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.setOpaque(false);
            topPanel.add((Component)toolbarPanel, "West");
            topPanel.add((Component)emptyPanel, "Center");
            this.add((Component)topPanel, "North");
            if (this.myEditorComponent != null) {
                this.add((Component)this.myEditorComponent, "Center");
            }
            MouseAdapter listener2 = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }
            };
            emptyPanel.addMouseListener(listener2);
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                PopupPanel.$$$reportNull$$$0(2);
            }
            return editor;
        }

        private static void transferEvent(MouseEvent e, Editor editor) {
            editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
        }

        public int getEditorTextOffset() {
            return EditorFragmentComponent.createEditorFragmentBorder((Editor)this.myEditor).getBorderInsets((Component)this.myEditorComponent).left;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolbar";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopup$PopupPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopup$PopupPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

