/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLineStatusRangeDiffAction
extends DumbAwareAction {
    private final LineStatusTrackerBase myLineStatusTracker;
    private final Range myRange;

    public ShowLineStatusRangeDiffAction(@NotNull LineStatusTrackerBase lineStatusTracker, @NotNull Range range, @Nullable Editor editor) {
        if (lineStatusTracker == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(0);
        }
        if (range == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(1);
        }
        this.myLineStatusTracker = lineStatusTracker;
        this.myRange = range;
        ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowDiff");
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.myLineStatusTracker.isValid());
    }

    public void actionPerformed(AnActionEvent e) {
        DiffManager.getInstance().showDiff(e.getProject(), this.createDiffData());
    }

    @NotNull
    private DiffRequest createDiffData() {
        Range range = ShowLineStatusRangeDiffAction.expand(this.myRange, this.myLineStatusTracker.getDocument(), this.myLineStatusTracker.getVcsDocument());
        DiffContent vcsContent = this.createDiffContent(this.myLineStatusTracker.getVcsDocument(), this.myLineStatusTracker.getVirtualFile(), this.myLineStatusTracker.getVcsTextRange(range));
        DiffContent currentContent = this.createDiffContent(this.myLineStatusTracker.getDocument(), this.myLineStatusTracker.getVirtualFile(), this.myLineStatusTracker.getCurrentTextRange(range));
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(VcsBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, currentContent, VcsBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), VcsBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0]));
        if (simpleDiffRequest == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(2);
        }
        return simpleDiffRequest;
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull Document document, @Nullable VirtualFile highlightFile, @NotNull TextRange textRange) {
        if (document == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(3);
        }
        if (textRange == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(4);
        }
        Project project2 = this.myLineStatusTracker.getProject();
        DocumentContent content = DiffContentFactory.getInstance().create(project2, document, highlightFile);
        DocumentContent documentContent = DiffContentFactory.getInstance().createFragment(project2, content, textRange);
        if (documentContent == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    @NotNull
    private static Range expand(@NotNull Range range, @NotNull Document document, @NotNull Document uDocument) {
        if (range == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(6);
        }
        if (document == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(7);
        }
        if (uDocument == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(8);
        }
        boolean canExpandBefore = range.getLine1() != 0 && range.getVcsLine1() != 0;
        boolean canExpandAfter = range.getLine2() < DiffUtil.getLineCount(document) && range.getVcsLine2() < DiffUtil.getLineCount(uDocument);
        int offset1 = range.getLine1() - (canExpandBefore ? 1 : 0);
        int uOffset1 = range.getVcsLine1() - (canExpandBefore ? 1 : 0);
        int offset2 = range.getLine2() + (canExpandAfter ? 1 : 0);
        int uOffset2 = range.getVcsLine2() + (canExpandAfter ? 1 : 0);
        Range range2 = new Range(offset1, offset2, uOffset1, uOffset2);
        if (range2 == null) {
            ShowLineStatusRangeDiffAction.$$$reportNull$$$0(9);
        }
        return range2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStatusTracker";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

