/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.TreeNodeOnVcsRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends HtmlPanel
implements DataProvider,
CopyProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StatusText myStatusText;
    @NotNull
    private String myText;

    public DetailsPanel(@NotNull Project project2) {
        if (project2 == null) {
            DetailsPanel.$$$reportNull$$$0(0);
        }
        this.myText = "";
        this.myProject = project2;
        this.myStatusText = new StatusText(){

            protected boolean isStatusVisible() {
                return StringUtil.isEmpty((String)DetailsPanel.this.myText);
            }
        };
        this.myStatusText.setText("Commit message");
        this.myStatusText.attachTo((Component)this);
        this.setPreferredSize((Dimension)new JBDimension(150, 100));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myStatusText.paint((Component)this, g);
    }

    public void update(@NotNull List<TreeNodeOnVcsRevision> selection) {
        if (selection == null) {
            DetailsPanel.$$$reportNull$$$0(1);
        }
        if (selection.isEmpty()) {
            this.setText("");
            return;
        }
        boolean addRevisionInfo = selection.size() > 1;
        StringBuilder html = new StringBuilder();
        for (TreeNodeOnVcsRevision revision : selection) {
            String message2 = revision.getRevision().getCommitMessage();
            if (StringUtil.isEmpty((String)message2)) continue;
            if (html.length() > 0) {
                html.append("<br/><br/>");
            }
            if (addRevisionInfo) {
                String revisionInfo = FileHistoryPanelImpl.getPresentableText(revision.getRevision(), false);
                html.append("<font color=\"#").append(Integer.toHexString(JBColor.gray.getRGB()).substring(2)).append("\">").append(FontUtil.getHtmlWithFonts(revisionInfo)).append("</font><br/>");
            }
            html.append(FontUtil.getHtmlWithFonts(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, message2)));
        }
        this.myText = html.toString();
        if (this.myText.isEmpty()) {
            this.setText("");
        } else {
            this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + this.myText + "</body></html>");
            this.setCaretPosition(0);
        }
    }

    @Override
    public Color getBackground() {
        return UIUtil.getEditorPaneBackground();
    }

    public void performCopy(@NotNull DataContext dataContext) {
        String selectedText;
        if (dataContext == null) {
            DetailsPanel.$$$reportNull$$$0(2);
        }
        if ((selectedText = this.getSelectedText()) == null || selectedText.isEmpty()) {
            selectedText = StringUtil.removeHtmlTags((String)this.getText());
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(selectedText));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DetailsPanel.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DetailsPanel.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/history/DetailsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

