/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetVersionAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(GetVersionAction.class);

    public GetVersionAction() {
        super(VcsBundle.message((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.message((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), AllIcons.Actions.Get);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GetVersionAction.$$$reportNull$$$0(0);
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (e.getProject() == null || filePath == null || revision == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(this.isContentAvailable(filePath, revision, e));
        }
    }

    protected boolean isContentAvailable(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull AnActionEvent e) {
        VcsHistorySession historySession;
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(1);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            GetVersionAction.$$$reportNull$$$0(3);
        }
        if ((historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION)) == null) {
            return false;
        }
        return historySession.isContentAvailable(revision) && !filePath.isDirectory();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            GetVersionAction.$$$reportNull$$$0(4);
        }
        if (ChangeListManager.getInstance((Project)(project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT))).isFreezedWithNotification(null)) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getRequiredData(VcsDataKeys.VCS_FILE_REVISION);
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        GetVersionAction.doGet(project2, revision, filePath);
    }

    public static void doGet(@NotNull Project project2, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) {
        VirtualFile virtualFile;
        if (project2 == null) {
            GetVersionAction.$$$reportNull$$$0(5);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(6);
        }
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(7);
        }
        if ((virtualFile = filePath.getVirtualFile()) != null) {
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(project2, VcsBundle.message((String)"acton.name.get.revision", (Object[])new Object[0]));
            if (!confirmationDialog.confirmFor(new VirtualFile[]{virtualFile})) {
                return;
            }
        }
        new MyWriteVersionTask(project2, filePath, revision).queue();
        GetVersionAction.refreshFile(filePath, revision, project2);
    }

    private static void refreshFile(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull Project project2) {
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(8);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            GetVersionAction.$$$reportNull$$$0(10);
        }
        Runnable refresh = null;
        VirtualFile vf = filePath.getVirtualFile();
        if (vf == null) {
            LocalHistoryAction action = GetVersionAction.startLocalHistoryAction(filePath, revision);
            VirtualFile vp = filePath.getVirtualFileParent();
            if (vp != null) {
                refresh = () -> vp.refresh(false, true, () -> ((LocalHistoryAction)action).finish());
            }
        } else {
            refresh = () -> vf.refresh(false, false);
        }
        if (refresh != null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(refresh, "Refreshing Files...", false, project2);
        }
    }

    private static LocalHistoryAction startLocalHistoryAction(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(11);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(12);
        }
        return LocalHistory.getInstance().startAction(GetVersionAction.createGetActionTitle(filePath, revision));
    }

    @NotNull
    private static String createGetActionTitle(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(13);
        }
        if (revision == null) {
            GetVersionAction.$$$reportNull$$$0(14);
        }
        String string = VcsBundle.message((String)"action.name.for.file.get.version", (Object[])new Object[]{filePath.getPath(), revision.getRevisionNumber()});
        if (string == null) {
            GetVersionAction.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void write(@NotNull FilePath filePath, byte[] revision, @NotNull Project project2) throws IOException {
        VirtualFile virtualFile;
        if (filePath == null) {
            GetVersionAction.$$$reportNull$$$0(16);
        }
        if (project2 == null) {
            GetVersionAction.$$$reportNull$$$0(17);
        }
        if ((virtualFile = filePath.getVirtualFile()) == null) {
            FileUtil.writeToFile((File)filePath.getIOFile(), (byte[])revision);
        } else {
            Document document = !virtualFile.getFileType().isBinary() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
            if (document == null) {
                virtualFile.setBinaryContent(revision);
            } else {
                String content = StringUtil.convertLineSeparators((String)new String(revision, filePath.getCharset().name()));
                CommandProcessor.getInstance().executeCommand(project2, () -> document.replaceString(0, document.getTextLength(), (CharSequence)content), VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]), null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 5: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/actions/GetVersionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isContentAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGet";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startLocalHistoryAction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createGetActionTitle";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyWriteVersionTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final VcsFileRevision myRevision;
        @Nullable
        private final VirtualFile myFile;

        public MyWriteVersionTask(@NotNull Project project2, @NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
            if (project2 == null) {
                MyWriteVersionTask.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                MyWriteVersionTask.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                MyWriteVersionTask.$$$reportNull$$$0(2);
            }
            super(project2, VcsBundle.message((String)"show.diff.progress.title", (Object[])new Object[0]));
            this.myProject = project2;
            this.myFilePath = filePath;
            this.myRevision = revision;
            this.myFile = filePath.getVirtualFile();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            byte[] revisionContent;
            if (indicator == null) {
                MyWriteVersionTask.$$$reportNull$$$0(3);
            }
            LocalHistoryAction action = this.myFile != null ? GetVersionAction.startLocalHistoryAction(this.myFilePath, this.myRevision) : LocalHistoryAction.NULL;
            try {
                revisionContent = VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (VcsException | IOException e) {
                LOG.info(e);
                ApplicationManager.getApplication().invokeLater(() -> MyWriteVersionTask.lambda$run$0((Exception)e));
                return;
            }
            catch (ProcessCanceledException ex) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    if (this.myFile != null && !this.myFile.isWritable() && ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(new VirtualFile[]{this.myFile}).hasReadonlyFiles()) {
                        return;
                    }
                    new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

                        protected void run() {
                            try {
                                GetVersionAction.write(myFilePath, revisionContent, myProject);
                            }
                            catch (IOException e) {
                                Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.save.content", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                            }
                        }
                    }.execute();
                    if (this.myFile != null) {
                        VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(this.myFile);
                    }
                }
                finally {
                    action.finish();
                }
            });
        }

        private static /* synthetic */ void lambda$run$0(Exception e) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/history/actions/GetVersionAction$MyWriteVersionTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

