/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsRootChecker[] myCheckers;

    public VcsRootDetectorImpl(@NotNull Project project2, @NotNull ProjectRootManager projectRootManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (project2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(1);
        }
        if (projectLevelVcsManager == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myProjectManager = projectRootManager;
        this.myVcsManager = projectLevelVcsManager;
        this.myCheckers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME);
    }

    @NotNull
    public Collection<VcsRoot> detect() {
        Collection<VcsRoot> collection = this.detect(this.myProject.getBaseDir());
        if (collection == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        if (startDir == null || this.myCheckers.length == 0) {
            List<VcsRoot> list2 = Collections.emptyList();
            if (list2 == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(4);
            }
            return list2;
        }
        Set<VcsRoot> roots = this.scanForRootsInsideDir(startDir);
        roots.addAll(this.scanForRootsInContentRoots());
        for (VcsRoot root : roots) {
            if (!startDir.equals(root.getPath())) continue;
            Set<VcsRoot> set2 = roots;
            if (set2 == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(5);
            }
            return set2;
        }
        List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(startDir);
        roots.addAll(rootsAbove);
        Set<VcsRoot> set3 = roots;
        if (set3 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(6);
        }
        return set3;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInContentRoots() {
        VirtualFile[] roots;
        HashSet<VcsRoot> vcsRoots = new HashSet<VcsRoot>();
        if (this.myProject.isDisposed()) {
            HashSet<VcsRoot> hashSet = vcsRoots;
            if (hashSet == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(7);
            }
            return hashSet;
        }
        for (VirtualFile contentRoot : roots = this.myProjectManager.getContentRoots()) {
            Set<VcsRoot> rootsInsideRoot = this.scanForRootsInsideDir(contentRoot);
            boolean shouldScanAbove = true;
            for (VcsRoot root : rootsInsideRoot) {
                if (!contentRoot.equals(root.getPath())) continue;
                shouldScanAbove = false;
            }
            if (shouldScanAbove) {
                List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(contentRoot);
                rootsInsideRoot.addAll(rootsAbove);
            }
            vcsRoots.addAll(rootsInsideRoot);
        }
        HashSet<VcsRoot> hashSet = vcsRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir, int depth) {
        if (dir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(9);
        }
        LOG.debug("Scanning inside [" + dir + "], depth = " + depth);
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        if (VcsRootDetectorImpl.depthLimitExceeded(depth)) {
            HashSet<VcsRoot> hashSet = roots;
            if (hashSet == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(10);
            }
            return hashSet;
        }
        if (((Boolean)ReadAction.compute(() -> {
            if (dir == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(21);
            }
            return this.myProject.isDisposed() || !dir.isDirectory() || this.myProjectManager.getFileIndex().isExcluded(dir);
        })).booleanValue()) {
            HashSet<VcsRoot> hashSet = roots;
            if (hashSet == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        List<AbstractVcs> vcsList = this.getVcsListFor(dir);
        LOG.debug("Found following VCSs: " + vcsList);
        for (AbstractVcs vcs : vcsList) {
            roots.add(new VcsRoot(vcs, dir));
        }
        for (VirtualFile child : dir.getChildren()) {
            roots.addAll(this.scanForRootsInsideDir(child, depth + 1));
        }
        HashSet<VcsRoot> hashSet = roots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    private static boolean depthLimitExceeded(int depth) {
        int maxDepth = Registry.intValue((String)"vcs.root.detector.folder.depth");
        return maxDepth >= 0 && maxDepth < depth;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(13);
        }
        Set<VcsRoot> set2 = this.scanForRootsInsideDir(dir, 0);
        if (set2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(14);
        }
        return set2;
    }

    @NotNull
    private List<VcsRoot> scanForSingleRootAboveDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(15);
        }
        ArrayList<VcsRoot> roots = new ArrayList<VcsRoot>();
        if (this.myProject.isDisposed()) {
            ArrayList<VcsRoot> arrayList = roots;
            if (arrayList == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        for (VirtualFile par = dir.getParent(); par != null; par = par.getParent()) {
            List<AbstractVcs> vcsList = this.getVcsListFor(par);
            for (AbstractVcs vcs : vcsList) {
                roots.add(new VcsRoot(vcs, par));
            }
            if (roots.isEmpty()) continue;
            ArrayList<VcsRoot> arrayList = roots;
            if (arrayList == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        ArrayList<VcsRoot> arrayList = roots;
        if (arrayList == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private List<AbstractVcs> getVcsListFor(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(19);
        }
        ArrayList<AbstractVcs> vcsList = new ArrayList<AbstractVcs>();
        for (VcsRootChecker checker : this.myCheckers) {
            if (!checker.isRoot(dir.getPath())) continue;
            vcsList.add(this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName()));
        }
        ArrayList<AbstractVcs> arrayList = vcsList;
        if (arrayList == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevelVcsManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsInContentRoots";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsInsideDir";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForSingleRootAboveDir";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsListFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsInsideDir";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scanForSingleRootAboveDir";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getVcsListFor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scanForRootsInsideDir$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

