/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootProblemNotifier {
    private static final Logger LOG = Logger.getInstance(VcsRootProblemNotifier.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration mySettings;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    @NotNull
    private final Set<String> myReportedUnregisteredRoots;
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Object NOTIFICATION_LOCK;
    @NotNull
    private static final Function<VcsRootError, String> ROOT_TO_PRESENTABLE = rootError -> {
        if (rootError.getMapping().equals("<Project>")) {
            return StringUtil.escapeXml((String)rootError.getMapping());
        }
        return FileUtil.toSystemDependentName((String)rootError.getMapping());
    };

    public static VcsRootProblemNotifier getInstance(@NotNull Project project2) {
        if (project2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(0);
        }
        return new VcsRootProblemNotifier(project2);
    }

    private VcsRootProblemNotifier(@NotNull Project project2) {
        if (project2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(1);
        }
        this.NOTIFICATION_LOCK = new Object();
        this.myProject = project2;
        this.mySettings = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)project2);
        this.myProjectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        this.myReportedUnregisteredRoots = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAndNotifyIfNeeded() {
        Collection<VcsRootError> errors = this.scan();
        if (errors.isEmpty()) {
            Object object = this.NOTIFICATION_LOCK;
            synchronized (object) {
                this.expireNotification();
            }
            return;
        }
        LOG.debug("Following errors detected: " + errors);
        List<VcsRootError> importantUnregisteredRoots = this.getImportantUnregisteredMappings(errors);
        Collection<VcsRootError> invalidRoots = VcsRootProblemNotifier.getInvalidRoots(errors);
        if (importantUnregisteredRoots.size() == 1) {
            VcsRootError singleUnregRoot = (VcsRootError)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(importantUnregisteredRoots));
            String mappingPath = singleUnregRoot.getMapping();
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)this.myProject);
            List allUnregisteredRoots = ContainerUtil.filter(errors, it -> it.getType() == VcsRootError.Type.UNREGISTERED_ROOT);
            if (!this.myVcsManager.hasAnyMappings() && allUnregisteredRoots.size() == 1 && !this.myReportedUnregisteredRoots.contains(mappingPath) && FileUtil.isAncestor((String)projectDir.getPath(), (String)mappingPath, (boolean)false) && Registry.is((String)"vcs.auto.add.single.root")) {
                VcsDirectoryMapping mapping = new VcsDirectoryMapping(mappingPath, singleUnregRoot.getVcsKey().getName());
                this.myVcsManager.setDirectoryMappings(Collections.singletonList(mapping));
                LOG.info("Added " + mapping.getVcs() + " root " + mapping + " as the only auto-detected root.");
                return;
            }
        }
        List unregRootPaths = ContainerUtil.map(importantUnregisteredRoots, VcsRootError::getMapping);
        if (invalidRoots.isEmpty() && (importantUnregisteredRoots.isEmpty() || this.myReportedUnregisteredRoots.containsAll(unregRootPaths))) {
            return;
        }
        this.myReportedUnregisteredRoots.addAll(unregRootPaths);
        String title = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots);
        String description = VcsRootProblemNotifier.makeDescription(importantUnregisteredRoots, invalidRoots);
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            this.expireNotification();
            MyNotificationListener listener2 = new MyNotificationListener(this.myProject, this.mySettings, this.myVcsManager, importantUnregisteredRoots);
            VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
            this.myNotification = invalidRoots.isEmpty() ? notifier.notifyMinorInfo(title, description, (NotificationListener)listener2) : notifier.notifyError(title, description, (NotificationListener)listener2);
        }
    }

    private boolean isUnderOrAboveProjectDir(@NotNull String mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(2);
        }
        String projectDir = (String)ObjectUtils.assertNotNull((Object)this.myProject.getBasePath());
        return mapping.equals("<Project>") || FileUtil.isAncestor((String)projectDir, (String)mapping, (boolean)false) || FileUtil.isAncestor((String)mapping, (String)projectDir, (boolean)false);
    }

    private boolean isIgnoredOrExcludedPath(@NotNull String mapping) {
        VirtualFile file2;
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(3);
        }
        return (file2 = LocalFileSystem.getInstance().findFileByPath(mapping)) != null && (this.myChangeListManager.isIgnoredFile(file2) || this.myProjectFileIndex.isExcluded(file2));
    }

    private void expireNotification() {
        if (this.myNotification != null) {
            Notification notification = this.myNotification;
            ApplicationManager.getApplication().invokeLater(() -> ((Notification)notification).expire());
            this.myNotification = null;
        }
    }

    @NotNull
    private Collection<VcsRootError> scan() {
        Collection<VcsRootError> collection = new VcsRootErrorsFinder(this.myProject).find();
        if (collection == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private static String makeDescription(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(5);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(6);
        }
        StringBuilder description = new StringBuilder();
        if (!invalidRoots.isEmpty()) {
            if (invalidRoots.size() == 1) {
                VcsRootError rootError = invalidRoots.iterator().next();
                String vcsName = rootError.getVcsKey().getName();
                description.append(String.format("The directory %s is registered as a %s root, but no %s repositories were found there.", ROOT_TO_PRESENTABLE.fun((Object)rootError), vcsName, vcsName));
            } else {
                description.append("The following directories are registered as VCS roots, but they are not: <br/>" + VcsRootProblemNotifier.joinRootsForPresentation(invalidRoots));
            }
            description.append("<br/>");
        }
        if (!unregisteredRoots.isEmpty()) {
            if (unregisteredRoots.size() == 1) {
                VcsRootError unregisteredRoot = unregisteredRoots.iterator().next();
                description.append(String.format("The directory %s is under %s, but is not registered in the Settings.", ROOT_TO_PRESENTABLE.fun((Object)unregisteredRoot), unregisteredRoot.getVcsKey().getName()));
            } else {
                description.append("The following directories are roots of VCS repositories, but they are not registered in the Settings: <br/>" + VcsRootProblemNotifier.joinRootsForPresentation(unregisteredRoots));
            }
            description.append("<br/>");
        }
        String add = invalidRoots.isEmpty() ? "<a href='add'>Add " + StringUtil.pluralize((String)"root", (int)unregisteredRoots.size()) + "</a>&nbsp;&nbsp;" : "";
        String configure = "<a href='configure'>Configure</a>";
        String ignore = invalidRoots.isEmpty() ? "&nbsp;&nbsp;<a href='ignore'>Ignore</a>" : "";
        description.append(add + configure + ignore);
        String string = description.toString();
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String joinRootsForPresentation(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(8);
        }
        String string = StringUtil.join((Collection)ContainerUtil.sorted(errors, (root1, root2) -> {
            if (root1.getMapping().equals("<Project>")) {
                return -1;
            }
            if (root2.getMapping().equals("<Project>")) {
                return 1;
            }
            return root1.getMapping().compareTo(root2.getMapping());
        }), ROOT_TO_PRESENTABLE, (String)"<br/>");
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String makeTitle(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(10);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(11);
        }
        String title = unregisteredRoots.isEmpty() ? "Invalid VCS root " + StringUtil.pluralize((String)"mapping", (int)invalidRoots.size()) : (invalidRoots.isEmpty() ? "Unregistered VCS " + StringUtil.pluralize((String)"root", (int)unregisteredRoots.size()) + " detected" : "VCS root configuration problems");
        String string = title;
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private List<VcsRootError> getImportantUnregisteredMappings(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(13);
        }
        List list2 = ContainerUtil.filter(errors, error -> {
            String mapping = error.getMapping();
            return error.getType() == VcsRootError.Type.UNREGISTERED_ROOT && this.isUnderOrAboveProjectDir(mapping) && !this.isIgnoredOrExcludedPath(mapping) && !this.mySettings.isIgnoredUnregisteredRoot(mapping);
        });
        if (list2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    private static Collection<VcsRootError> getInvalidRoots(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(15);
        }
        List list2 = ContainerUtil.filter(errors, error -> error.getType() == VcsRootError.Type.EXTRA_MAPPING);
        if (list2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(16);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unregisteredRoots";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidRoots";
                break;
            }
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "scan";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "joinRootsForPresentation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportantUnregisteredMappings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderOrAboveProjectDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOrExcludedPath";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "makeDescription";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "joinRootsForPresentation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeTitle";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getImportantUnregisteredMappings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsConfiguration mySettings;
        @NotNull
        private final ProjectLevelVcsManager myVcsManager;
        @NotNull
        private final Collection<VcsRootError> myImportantUnregisteredRoots;

        private MyNotificationListener(@NotNull Project project2, @NotNull VcsConfiguration settings, @NotNull ProjectLevelVcsManager vcsManager, @NotNull Collection<VcsRootError> importantUnregisteredRoots) {
            if (project2 == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                MyNotificationListener.$$$reportNull$$$0(1);
            }
            if (vcsManager == null) {
                MyNotificationListener.$$$reportNull$$$0(2);
            }
            if (importantUnregisteredRoots == null) {
                MyNotificationListener.$$$reportNull$$$0(3);
            }
            this.myProject = project2;
            this.mySettings = settings;
            this.myVcsManager = vcsManager;
            this.myImportantUnregisteredRoots = importantUnregisteredRoots;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(4);
            }
            if (event == null) {
                MyNotificationListener.$$$reportNull$$$0(5);
            }
            if (event.getDescription().equals("configure") && !this.myProject.isDisposed()) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, ActionsBundle.message((String)"group.VcsGroup.text", (Object[])new Object[0]));
                Collection errorsAfterPossibleFix = VcsRootProblemNotifier.getInstance(this.myProject).scan();
                if (errorsAfterPossibleFix.isEmpty() && !notification.isExpired()) {
                    notification.expire();
                }
            } else if (event.getDescription().equals("ignore")) {
                this.mySettings.addIgnoredUnregisteredRoots((Collection)ContainerUtil.map(this.myImportantUnregisteredRoots, VcsRootError::getMapping));
                notification.expire();
            } else if (event.getDescription().equals("add")) {
                List mappings = this.myVcsManager.getDirectoryMappings();
                for (VcsRootError root : this.myImportantUnregisteredRoots) {
                    mappings = VcsUtil.addMapping((List)mappings, (String)root.getMapping(), (String)root.getVcsKey().getName());
                }
                this.myVcsManager.setDirectoryMappings(mappings);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importantUnregisteredRoots";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

