/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class VirtualFileDirectoryImpl
extends VirtualFileImpl {
    private final ArrayList<VirtualFileImpl> myChildren = new ArrayList();

    public VirtualFileDirectoryImpl(DummyFileSystem fileSystem, VirtualFileDirectoryImpl parent, String name2) {
        super(fileSystem, parent, name2);
    }

    public boolean isDirectory() {
        return true;
    }

    public long getLength() {
        return 0L;
    }

    public VirtualFile[] getChildren() {
        return this.myChildren.size() == 0 ? EMPTY_ARRAY : this.myChildren.toArray(new VirtualFile[this.myChildren.size()]);
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException(VfsBundle.message((String)"file.read.error", (Object[])new Object[]{this.getUrl()}));
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException(VfsBundle.message((String)"file.write.error", (Object[])new Object[]{this.getUrl()}));
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException(VfsBundle.message((String)"file.read.error", (Object[])new Object[]{this.getUrl()}));
    }

    public long getModificationStamp() {
        return -1L;
    }

    void addChild(VirtualFileImpl child) {
        this.myChildren.add(child);
    }

    void removeChild(VirtualFileImpl child) {
        this.myChildren.remove((Object)child);
        child.myIsValid = false;
    }
}

