/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePointerTracker {
    private static final Set<VirtualFilePointerImpl> storedPointers = ContainerUtil.newIdentityTroveSet();
    private static Throwable trace;
    private static boolean isTracking;

    public VirtualFilePointerTracker() {
        this.storePointers();
    }

    private synchronized void storePointers() {
        if (isTracking) {
            throw new IllegalStateException("Previous test did not call assertPointersAreDisposed() - see 'Caused by:' for its stacktrace", trace);
        }
        trace = new Throwable();
        storedPointers.clear();
        VirtualFilePointerTracker.addAllPointersTo(storedPointers);
        isTracking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertPointersAreDisposed() {
        if (!isTracking) {
            throw new IllegalStateException("Double call of assertPointersAreDisposed() - see 'Caused by:' for the previous call", trace);
        }
        ArrayList<VirtualFilePointerImpl> pointers = new ArrayList<VirtualFilePointerImpl>();
        VirtualFilePointerTracker.addAllPointersTo(pointers);
        for (int i = pointers.size() - 1; i >= 0; --i) {
            VirtualFilePointerImpl pointer = (VirtualFilePointerImpl)((Object)pointers.get(i));
            if (!storedPointers.remove((Object)pointer)) continue;
            pointers.remove(i);
        }
        try {
            THashSet leaked = ContainerUtil.newTroveSet((TObjectHashingStrategy)new TObjectHashingStrategy<VirtualFilePointerImpl>(){

                public int computeHashCode(VirtualFilePointerImpl pointer) {
                    return FileUtil.PATH_HASHING_STRATEGY.computeHashCode((Object)pointer.getUrl());
                }

                public boolean equals(VirtualFilePointerImpl o1, VirtualFilePointerImpl o2) {
                    return FileUtil.PATH_HASHING_STRATEGY.equals((Object)o1.getUrl(), (Object)o2.getUrl());
                }
            }, pointers);
            leaked.removeAll(storedPointers);
            for (VirtualFilePointerImpl pointer : leaked) {
                pointer.throwDisposalError("Virtual pointer '" + (Object)((Object)pointer) + "' hasn't been disposed: " + pointer.getStackTrace());
            }
        }
        finally {
            storedPointers.clear();
            trace = new Throwable();
            isTracking = false;
        }
    }

    private static void addAllPointersTo(@NotNull Collection<VirtualFilePointerImpl> pointers) {
        if (pointers == null) {
            VirtualFilePointerTracker.$$$reportNull$$$0(0);
        }
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).addAllPointersTo(pointers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vfs/impl/VirtualFilePointerTracker", "addAllPointersTo"));
    }
}

