/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindowWatcher
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.WindowWatcher");
    private final Object myLock = new Object();
    private final Map<Window, WindowInfo> myWindow2Info = ContainerUtil.createWeakMap();
    private Window myFocusedWindow;
    private final HashSet myFocusedWindows = new HashSet();
    @NonNls
    protected static final String FOCUSED_WINDOW_PROPERTY = "focusedWindow";

    WindowWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void propertyChange(PropertyChangeEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: propertyChange(" + e + ")");
        }
        if (!FOCUSED_WINDOW_PROPERTY.equals(e.getPropertyName())) {
            throw new IllegalArgumentException("unknown property name: " + e.getPropertyName());
        }
        Object object = this.myLock;
        synchronized (object) {
            Window window = (Window)e.getNewValue();
            if (window == null || ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            if (!this.myWindow2Info.containsKey(window)) {
                this.myWindow2Info.put(window, new WindowInfo(window, true));
            }
            this.myFocusedWindow = window;
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myFocusedWindow));
            Iterator i = this.myFocusedWindows.iterator();
            while (i.hasNext()) {
                Window w = (Window)i.next();
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)w);
                if (project2 != CommonDataKeys.PROJECT.getData(dataContext)) continue;
                i.remove();
            }
            this.myFocusedWindows.add(this.myFocusedWindow);
            IdeFrameImpl frame = window instanceof IdeFrameImpl ? (IdeFrameImpl)window : (IdeFrameImpl)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window);
            if (frame != null) {
                JOptionPane.setRootFrame(frame);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("exit: propertyChange()");
        }
    }

    final void dispatchComponentEvent(ComponentEvent e) {
        int id = e.getID();
        if (202 == id || 103 == id && e.getSource() instanceof Window) {
            this.dispatchHiddenOrClosed((Window)e.getSource());
        }
        if (202 == id) {
            Window window = (Window)e.getSource();
            if (JOptionPane.getRootFrame() == window) {
                JOptionPane.setRootFrame(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchHiddenOrClosed(Window window) {
        WindowInfo info;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: dispatchClosed(" + window + ")");
        }
        Object object = this.myLock;
        synchronized (object) {
            info = this.myWindow2Info.get(window);
            if (info != null) {
                FocusWatcher focusWatcher = (FocusWatcher)info.myFocusWatcherRef.get();
                if (focusWatcher != null) {
                    focusWatcher.deinstall((Component)window);
                }
                this.myWindow2Info.remove(window);
            }
        }
        if (this.myFocusedWindow == window) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("currently active window should be closed");
            }
            this.myFocusedWindow = this.myFocusedWindow.getOwner();
            if (LOG.isDebugEnabled()) {
                LOG.debug("new active window is " + this.myFocusedWindow);
            }
        }
        Iterator<Object> i = this.myFocusedWindows.iterator();
        while (i.hasNext()) {
            Window activeWindow = (Window)i.next();
            if (activeWindow != window) continue;
            Window newActiveWindow = activeWindow.getOwner();
            i.remove();
            if (newActiveWindow == null) break;
            this.myFocusedWindows.add(newActiveWindow);
            break;
        }
        i = this.myWindow2Info.values().iterator();
        while (i.hasNext()) {
            info = (WindowInfo)i.next();
            if (info.myFocusWatcherRef.get() != null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("remove collected info");
            }
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Window getFocusedWindow() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFocusedWindow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Component getFocusedComponent(@Nullable Project project2) {
        Object object = this.myLock;
        synchronized (object) {
            Window window = this.getFocusedWindowForProject(project2);
            if (window == null) {
                return null;
            }
            return this.getFocusedComponent(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            WindowWatcher.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info = this.myWindow2Info.get(window);
            if (info == null) {
                return window.getMostRecentFocusOwner();
            }
            FocusWatcher focusWatcher = (FocusWatcher)info.myFocusWatcherRef.get();
            if (focusWatcher != null) {
                Component focusedComponent = focusWatcher.getFocusedComponent();
                if (focusedComponent != null && focusedComponent.isShowing()) {
                    return focusedComponent;
                }
                return null;
            }
            this.myWindow2Info.remove(window);
            return null;
        }
    }

    @Nullable
    public FocusWatcher getFocusWatcherFor(Component c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        WindowInfo info = this.myWindow2Info.get(window);
        return info == null ? null : (FocusWatcher)info.myFocusWatcherRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Window suggestParentWindow(@Nullable Project project2) {
        Object object = this.myLock;
        synchronized (object) {
            Window window = this.getFocusedWindowForProject(project2);
            if (window == null) {
                if (project2 != null) {
                    return (Window)WindowManagerEx.getInstanceEx().findFrameFor(project2);
                }
                return null;
            }
            LOG.assertTrue(window.isDisplayable());
            LOG.assertTrue(window.isShowing());
            while (window != null) {
                if (!(window instanceof Dialog) && !(window instanceof Frame)) {
                    window = window.getOwner();
                    continue;
                }
                if (!window.isDisplayable() || !window.isShowing()) {
                    window = window.getOwner();
                    continue;
                }
                WindowInfo info = this.myWindow2Info.get(window);
                if (info == null) {
                    window = window.getOwner();
                    continue;
                }
                if (info.mySuggestAsParent) {
                    return window;
                }
                window = window.getOwner();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doNotSuggestAsParent(Window window) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: doNotSuggestAsParent(" + window + ")");
        }
        Object object = this.myLock;
        synchronized (object) {
            WindowInfo info = this.myWindow2Info.get(window);
            if (info == null) {
                this.myWindow2Info.put(window, new WindowInfo(window, false));
            } else {
                info.mySuggestAsParent = false;
            }
        }
    }

    @Nullable
    private Window getFocusedWindowForProject(@Nullable Project project2) {
        block0: for (Window window : this.myFocusedWindows) {
            while (!window.isDisplayable() || !window.isShowing()) {
                if ((window = window.getOwner()) != null) continue;
                continue block0;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)window);
            if (project2 != CommonDataKeys.PROJECT.getData(dataContext)) continue;
            return window;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/wm/impl/WindowWatcher", "getFocusedComponent"));
    }

    private static final class WindowInfo {
        public final WeakReference<FocusWatcher> myFocusWatcherRef;
        public boolean mySuggestAsParent;

        public WindowInfo(Window window, boolean suggestAsParent) {
            FocusWatcher focusWatcher = new FocusWatcher();
            focusWatcher.install((Component)window);
            this.myFocusWatcherRef = new WeakReference<FocusWatcher>(focusWatcher);
            this.mySuggestAsParent = suggestAsParent;
        }
    }
}

