/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;

public class RefactoringScopeElementListenerProvider
implements RefactoringElementListenerProvider {
    private static final Logger LOG = Logger.getInstance(RefactoringScopeElementListenerProvider.class);

    public RefactoringElementListener getListener(PsiElement element) {
        if (!(element instanceof PsiQualifiedNamedElement) && !(element instanceof PsiDirectory)) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        RefactoringElementListenerComposite composite = null;
        String oldName = RefactoringScopeElementListenerProvider.getQualifiedName(element, false);
        if (oldName != null) {
            composite = RefactoringScopeElementListenerProvider.getComposite(element, containingFile, null, oldName);
        }
        if (element instanceof PsiQualifiedNamedElement && (oldName = RefactoringScopeElementListenerProvider.getQualifiedName(element, true)) != null) {
            composite = RefactoringScopeElementListenerProvider.getComposite(element, containingFile, composite, oldName);
        }
        return composite;
    }

    private static RefactoringElementListenerComposite getComposite(PsiElement element, PsiFile containingFile, RefactoringElementListenerComposite composite, String oldName) {
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)element.getProject())) {
            NamedScope[] scopes = holder.getEditableScopes();
            for (int i = 0; i < scopes.length; ++i) {
                NamedScope scope = scopes[i];
                PackageSet packageSet = scope.getValue();
                if (packageSet == null || containingFile != null && !packageSet.contains(containingFile, holder)) continue;
                composite = RefactoringScopeElementListenerProvider.traverse(new OldScopeDescriptor(oldName, scope, i, holder), composite, packageSet);
            }
        }
        return composite;
    }

    private static String getQualifiedName(PsiElement element, boolean acceptQNames) {
        if (element instanceof PsiQualifiedNamedElement && acceptQNames) {
            return ((PsiQualifiedNamedElement)element).getQualifiedName();
        }
        Project project2 = element.getProject();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        return FilePatternPackageSet.getRelativePath((VirtualFile)virtualFile, (ProjectFileIndex)ProjectRootManager.getInstance((Project)project2).getFileIndex(), (boolean)true, (VirtualFile)project2.getBaseDir());
    }

    private static RefactoringElementListenerComposite traverse(OldScopeDescriptor scopeDescriptor, RefactoringElementListenerComposite composite, PackageSet packageSet) {
        if (packageSet instanceof PatternBasedPackageSet) {
            PackageSet value2 = scopeDescriptor.getScope().getValue();
            if (value2 != null) {
                composite = RefactoringScopeElementListenerProvider.checkPatternPackageSet(scopeDescriptor, composite, (PatternBasedPackageSet)packageSet, value2.getText());
            }
        } else if (packageSet instanceof ComplementPackageSet) {
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((ComplementPackageSet)packageSet).getComplementarySet());
        } else if (packageSet instanceof UnionPackageSet) {
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((UnionPackageSet)packageSet).getFirstSet());
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((UnionPackageSet)packageSet).getSecondSet());
        } else if (packageSet instanceof IntersectionPackageSet) {
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((IntersectionPackageSet)packageSet).getFirstSet());
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((IntersectionPackageSet)packageSet).getSecondSet());
        }
        return composite;
    }

    private static RefactoringElementListenerComposite checkPatternPackageSet(final OldScopeDescriptor descriptor2, RefactoringElementListenerComposite composite, PatternBasedPackageSet pattern, final String text2) {
        if (pattern.isOn(descriptor2.getOldQName())) {
            if (composite == null) {
                composite = new RefactoringElementListenerComposite();
            }
            composite.addListener((RefactoringElementListener)new RefactoringElementAdapter(){

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement || newElement instanceof PsiDirectory);
                    try {
                        NamedScope[] currentScopes = descriptor2.getHolder().getEditableScopes();
                        PackageSet currentPackageSet = currentScopes[descriptor2.getIdx()].getValue();
                        String qualifiedName = RefactoringScopeElementListenerProvider.getQualifiedName(newElement, !(currentPackageSet instanceof FilePatternPackageSet));
                        if (qualifiedName != null) {
                            NamedScope newScope;
                            String newPattern = text2.replace(descriptor2.getOldQName(), qualifiedName);
                            PackageSet newSet = PackageSetFactory.getInstance().compile(newPattern);
                            currentScopes[descriptor2.getIdx()] = newScope = new NamedScope(descriptor2.getScope().getName(), newSet);
                            descriptor2.getHolder().setScopes(currentScopes);
                        }
                    }
                    catch (ParsingException parsingException) {
                        // empty catch block
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement || newElement instanceof PsiDirectory);
                    try {
                        NamedScope newScope;
                        NamedScope[] currentScopes = descriptor2.getHolder().getEditableScopes();
                        PatternBasedPackageSet packageSet = (PatternBasedPackageSet)currentScopes[descriptor2.getIdx()].getValue();
                        if (packageSet == null) {
                            return;
                        }
                        currentScopes[descriptor2.getIdx()] = newScope = new NamedScope(descriptor2.getScope().getName(), PackageSetFactory.getInstance().compile(text2));
                        descriptor2.getHolder().setScopes(currentScopes);
                    }
                    catch (ParsingException parsingException) {
                        // empty catch block
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/packageDependencies/ui/RefactoringScopeElementListenerProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return composite;
    }

    private static class OldScopeDescriptor {
        private final String myOldQName;
        private final NamedScopesHolder myHolder;
        private final int myIdx;
        private final NamedScope myScope;

        private OldScopeDescriptor(String oldQName, NamedScope scope, int idx, NamedScopesHolder holder) {
            this.myOldQName = oldQName;
            this.myHolder = holder;
            this.myIdx = idx;
            this.myScope = scope;
        }

        public String getOldQName() {
            return this.myOldQName;
        }

        public NamedScopesHolder getHolder() {
            return this.myHolder;
        }

        public int getIdx() {
            return this.myIdx;
        }

        public NamedScope getScope() {
            return this.myScope;
        }
    }
}

