/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.compiler.ant.taskdefs.Unzip;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ExtractedDirectoryPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractedDirectoryPackagingElement
extends FileOrDirectoryCopyPackagingElement<ExtractedDirectoryPackagingElement> {
    private String myPathInJar;

    public ExtractedDirectoryPackagingElement() {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE);
    }

    public ExtractedDirectoryPackagingElement(String jarPath, String pathInJar) {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, jarPath);
        this.myPathInJar = pathInJar;
        if (!StringUtil.startsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = "/" + this.myPathInJar;
        }
        if (!StringUtil.endsWithChar((CharSequence)this.myPathInJar, (char)'/')) {
            this.myPathInJar = this.myPathInJar + "/";
        }
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(0);
        }
        return new ExtractedDirectoryPresentation(this);
    }

    public String toString() {
        return "extracted:" + this.myFilePath + "!" + this.myPathInJar;
    }

    @Override
    public VirtualFile findFile() {
        VirtualFile jarFile = super.findFile();
        if (jarFile == null) {
            return null;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
        if ("/".equals(this.myPathInJar)) {
            return jarRoot;
        }
        return jarRoot != null ? jarRoot.findFileByRelativePath(this.myPathInJar) : null;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(1);
        }
        if (creator == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(2);
        }
        if (generationContext == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(3);
        }
        if (artifactType == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(4);
        }
        String jarPath = generationContext.getSubstitutedPath(this.myFilePath);
        String pathInJar = StringUtil.trimStart((String)this.myPathInJar, (String)"/");
        if (pathInJar.length() == 0) {
            return Collections.singletonList(creator.createExtractedDirectoryInstruction(jarPath));
        }
        String archiveName = PathUtil.getFileName((String)this.myFilePath);
        String tempDirProperty = generationContext.createNewTempFileProperty("temp.unpacked.path." + archiveName, archiveName);
        String tempDirPath = BuildProperties.propertyRef((String)tempDirProperty);
        generationContext.runBeforeCurrentArtifact((Generator)new Mkdir(tempDirPath));
        Unzip unzip = new Unzip(jarPath, tempDirPath);
        PatternSet patterns = new PatternSet(null);
        patterns.add((Generator)new Include(pathInJar + "**"));
        unzip.add((Generator)patterns);
        generationContext.runBeforeCurrentArtifact((Generator)unzip);
        return Collections.singletonList(creator.createDirectoryContentCopyInstruction(tempDirPath + "/" + pathInJar));
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ExtractedDirectoryPackagingElement.$$$reportNull$$$0(5);
        }
        return element instanceof ExtractedDirectoryPackagingElement && super.isEqualTo(element) && Comparing.equal((String)this.myPathInJar, (String)((ExtractedDirectoryPackagingElement)element).getPathInJar());
    }

    public ExtractedDirectoryPackagingElement getState() {
        return this;
    }

    public void loadState(ExtractedDirectoryPackagingElement state) {
        this.myFilePath = state.getFilePath();
        this.myPathInJar = state.getPathInJar();
    }

    @Attribute(value="path-in-jar")
    public String getPathInJar() {
        return this.myPathInJar;
    }

    public void setPathInJar(String pathInJar) {
        this.myPathInJar = pathInJar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/ExtractedDirectoryPackagingElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAntInstructions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

