/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import org.jetbrains.annotations.NotNull;

public class LineIndentInfo {
    public static final LineIndentInfo EMPTY_LINE = new LineIndentInfo(LineType.EMPTY_LINE, -1);
    public static final LineIndentInfo LINE_WITH_COMMENT = new LineIndentInfo(LineType.LINE_WITH_COMMENT, -1);
    public static final LineIndentInfo LINE_WITH_TABS = new LineIndentInfo(LineType.LINE_WITH_TABS, -1);
    public static final LineIndentInfo LINE_WITH_CONTINUATION_INDENT = new LineIndentInfo(LineType.LINE_WITH_CONTINUATION_INDENT, -1);
    public static final LineIndentInfo LINE_WITH_NOT_COUNTABLE_INDENT = new LineIndentInfo(LineType.LINE_WITH_NOT_COUNTABLE_INDENT, -1);
    private final int myIndentSize;
    private final LineType myType;

    private LineIndentInfo(@NotNull LineType type2, int indentSize) {
        if (type2 == null) {
            LineIndentInfo.$$$reportNull$$$0(0);
        }
        this.myType = type2;
        this.myIndentSize = indentSize;
    }

    @NotNull
    public static LineIndentInfo newNormalIndent(int indentSize) {
        LineIndentInfo lineIndentInfo = new LineIndentInfo(LineType.LINE_WITH_NORMAL_WHITESPACE_INDENT, indentSize);
        if (lineIndentInfo == null) {
            LineIndentInfo.$$$reportNull$$$0(1);
        }
        return lineIndentInfo;
    }

    public int getIndentSize() {
        return this.myIndentSize;
    }

    public boolean isLineWithNormalIndent() {
        return this.myType == LineType.LINE_WITH_NORMAL_WHITESPACE_INDENT;
    }

    public boolean isLineWithTabs() {
        return this.myType == LineType.LINE_WITH_TABS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/autodetect/LineIndentInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/autodetect/LineIndentInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newNormalIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum LineType {
        EMPTY_LINE,
        LINE_WITH_COMMENT,
        LINE_WITH_TABS,
        LINE_WITH_NORMAL_WHITESPACE_INDENT,
        LINE_WITH_CONTINUATION_INDENT,
        LINE_WITH_NOT_COUNTABLE_INDENT;

    }
}

