/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSuperElementsHelper {
    @NotNull
    public static PsiElement[] findSuperElements(@NotNull PsiElement element) {
        if (element == null) {
            FindSuperElementsHelper.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator = allSupers.iterator();
            while (iterator.hasNext()) {
                PsiClass superClass = (PsiClass)iterator.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator.remove();
            }
            PsiElement[] psiElementArray = (PsiElement[])allSupers.toArray(new PsiClass[allSupers.size()]);
            if (psiElementArray == null) {
                FindSuperElementsHelper.$$$reportNull$$$0(1);
            }
            return psiElementArray;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                PsiMethod constructorInSuper = PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)method);
                if (constructorInSuper != null) {
                    PsiMethod[] psiMethodArray = new PsiMethod[]{constructorInSuper};
                    if (psiMethodArray == null) {
                        FindSuperElementsHelper.$$$reportNull$$$0(2);
                    }
                    return psiMethodArray;
                }
            } else {
                PsiMethod superMethod;
                PsiMethod[] superMethods = method.findSuperMethods(false);
                if (superMethods.length == 0 && (superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) != null) {
                    superMethods = new PsiMethod[]{superMethod};
                }
                if (superMethods == null) {
                    FindSuperElementsHelper.$$$reportNull$$$0(3);
                }
                return superMethods;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            FindSuperElementsHelper.$$$reportNull$$$0(4);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiMethod getSiblingInheritedViaSubClass(@NotNull PsiMethod method) {
        SiblingInfo info;
        if (method == null) {
            FindSuperElementsHelper.$$$reportNull$$$0(5);
        }
        return (info = FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method)) == null ? null : info.superMethod;
    }

    @Nullable
    public static SiblingInfo getSiblingInfoInheritedViaSubClass(@NotNull PsiMethod method) {
        if (method == null) {
            FindSuperElementsHelper.$$$reportNull$$$0(6);
        }
        return FindSuperElementsHelper.getSiblingInheritanceInfos(Collections.singletonList(method)).get(method);
    }

    @NotNull
    public static Map<PsiMethod, SiblingInfo> getSiblingInheritanceInfos(@NotNull Collection<PsiMethod> methods) {
        if (methods == null) {
            FindSuperElementsHelper.$$$reportNull$$$0(7);
        }
        MultiMap byClass = MultiMap.create();
        for (PsiMethod method : methods) {
            PsiClass containingClass;
            if (!FindSuperElementsHelper.canHaveSiblingSuper(method, containingClass = method.getContainingClass())) continue;
            byClass.putValue((Object)containingClass, (Object)method);
        }
        HashMap result2 = new HashMap();
        for (PsiClass psiClass : byClass.keySet()) {
            SiblingInheritorSearcher searcher = new SiblingInheritorSearcher(byClass.get((Object)psiClass), psiClass);
            ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)psiClass.getUseScope(), (boolean)true, (boolean)true, (boolean)false).forEach((Processor)searcher);
            result2.putAll(searcher.getResult());
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            FindSuperElementsHelper.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private static boolean canHaveSiblingSuper(PsiMethod method, PsiClass containingClass) {
        return containingClass != null && PsiUtil.canBeOverridden((PsiMethod)method) && !method.hasModifierProperty("abstract") && !method.hasModifierProperty("native") && method.hasModifierProperty("public") && !containingClass.isInterface() && !"java.lang.Object".equals(containingClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/FindSuperElementsHelper";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/FindSuperElementsHelper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingInheritanceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSuperElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingInheritedViaSubClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingInfoInheritedViaSubClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingInheritanceInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SiblingInheritorSearcher
    implements Processor<PsiClass> {
        private final PsiClass myContainingClass;
        private final Set<PsiMethod> myRemainingMethods;
        private final Map<PsiMethod, SiblingInfo> myResult = new HashMap();
        private final Collection<PsiAnchor> myCheckedInterfaces = new THashSet();

        SiblingInheritorSearcher(Collection<PsiMethod> methods, PsiClass containingClass) {
            this.myContainingClass = containingClass;
            this.myRemainingMethods = new HashSet<PsiMethod>(methods);
            this.myCheckedInterfaces.add(PsiAnchor.create((PsiElement)containingClass));
        }

        public boolean process(PsiClass inheritor) {
            ProgressManager.checkCanceled();
            for (PsiClassType interfaceType : inheritor.getImplementsListTypes()) {
                ProgressManager.checkCanceled();
                PsiClass anInterface = interfaceType.resolveGenerics().getElement();
                if (anInterface == null || !this.myCheckedInterfaces.add(PsiAnchor.create((PsiElement)anInterface))) continue;
                this.processInterface(inheritor, anInterface);
            }
            return !this.myRemainingMethods.isEmpty();
        }

        private void processInterface(PsiClass inheritor, PsiClass anInterface) {
            Iterator<PsiMethod> methodIterator = this.myRemainingMethods.iterator();
            while (methodIterator.hasNext()) {
                PsiMethod method = methodIterator.next();
                SiblingInfo info = this.findSibling(inheritor, anInterface, method);
                if (info == null) continue;
                this.myResult.put(method, info);
                methodIterator.remove();
            }
        }

        @Nullable
        private SiblingInfo findSibling(PsiClass inheritor, PsiClass anInterface, PsiMethod method) {
            for (PsiMethod superMethod : anInterface.findMethodsByName(method.getName(), true)) {
                PsiElement navigationElement = superMethod.getNavigationElement();
                if (!(navigationElement instanceof PsiMethod)) continue;
                superMethod = (PsiMethod)navigationElement;
                ProgressManager.checkCanceled();
                PsiClass superInterface = superMethod.getContainingClass();
                if (superInterface == null || this.myContainingClass.isInheritor(superInterface, true) || !this.isOverridden(inheritor, method, superMethod, superInterface)) continue;
                return new SiblingInfo(superMethod, inheritor);
            }
            return null;
        }

        private boolean isOverridden(PsiClass inheritor, PsiMethod method, PsiMethod superMethod, PsiClass superInterface) {
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myContainingClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiSubstitutor superInterfaceSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superInterface, (PsiClass)inheritor, (PsiSubstitutor)substitutor);
            return MethodSignatureUtil.isSubsignature((MethodSignature)superMethod.getSignature(superInterfaceSubstitutor), (MethodSignature)method.getSignature(substitutor));
        }

        Map<PsiMethod, SiblingInfo> getResult() {
            return this.myResult;
        }
    }

    public static class SiblingInfo {
        @NotNull
        public final PsiMethod superMethod;
        @NotNull
        public final PsiClass subClass;

        private SiblingInfo(@NotNull PsiMethod superMethod, @NotNull PsiClass subClass) {
            if (superMethod == null) {
                SiblingInfo.$$$reportNull$$$0(0);
            }
            if (subClass == null) {
                SiblingInfo.$$$reportNull$$$0(1);
            }
            this.superMethod = superMethod;
            this.subClass = subClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "superMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "subClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/FindSuperElementsHelper$SiblingInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

