/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final Key<FileViewProvider> myPsiHardRefKey = Key.create((String)"HARD_REFERENCE_TO_PSI");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final ConcurrentMap<VirtualFile, PsiDirectory> myVFileToPsiDirMap = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = ContainerUtil.createConcurrentWeakValueMap();
    private boolean myInitialized;
    private boolean myDisposed;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        Disposer.register((Disposable)manager.getProject(), (Disposable)this);
        LowMemoryWatcher.register(() -> this.processQueue(), (Disposable)this);
    }

    public void processQueue() {
        this.myVFileToViewProviderMap.remove(NULL);
    }

    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap<VirtualFile, FileViewProvider> concurrentMap = this.myVFileToViewProviderMap;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(0);
        }
        return concurrentMap;
    }

    public static void clearPsiCaches(@NotNull FileViewProvider provider) {
        if (provider == null) {
            FileManagerImpl.$$$reportNull$$$0(1);
        }
        ((AbstractFileViewProvider)provider).getCachedPsiFiles().forEach(PsiFile::clearCaches);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(2);
        }
        LanguageSubstitutors.cancelReparsing((VirtualFile)vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            FileManagerImpl.setUpPropertyChangedForUnloadedPsi(event, vFile);
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent((PsiElement)parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    void firePropertyChangedForUnloadedPsi(@NotNull PsiTreeChangeEventImpl event, @NotNull VirtualFile vFile) {
        if (event == null) {
            FileManagerImpl.$$$reportNull$$$0(3);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(4);
        }
        FileManagerImpl.setUpPropertyChangedForUnloadedPsi(event, vFile);
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    private static void setUpPropertyChangedForUnloadedPsi(@NotNull PsiTreeChangeEventImpl event, @NotNull VirtualFile vFile) {
        if (event == null) {
            FileManagerImpl.$$$reportNull$$$0(5);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(6);
        }
        event.setPropertyName("propUnloadedPsi");
        event.setOldValue(vFile);
        event.setNewValue(vFile);
    }

    public void dispose() {
        if (this.myInitialized) {
            this.myConnection.disconnect();
        }
        this.clearViewProviders();
        this.myDisposed = true;
    }

    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.startPsiModification("clearViewProviders");
        try {
            for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
                this.markInvalidated(provider);
            }
            this.myVFileToViewProviderMap.clear();
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    @Override
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(() -> this.clearViewProviders());
        this.myVFileToPsiDirMap.clear();
        ((PsiModificationTrackerImpl)this.myManager.getModificationTracker()).incCounter();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(7);
        }
        assert (!file2.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file2);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(8);
            }
            return fileViewProvider;
        }
        viewProvider = this.createFileViewProvider(file2, true);
        if (file2 instanceof LightVirtualFile) {
            FileViewProvider fileViewProvider = (FileViewProvider)file2.putUserDataIfAbsent(this.myPsiHardRefKey, (Object)viewProvider);
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(9);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = (FileViewProvider)ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, (Object)file2, (Object)viewProvider);
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(10);
        }
        return fileViewProvider;
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        FileViewProvider viewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(11);
        }
        if ((viewProvider = this.getFromInjected(file2)) == null) {
            viewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file2);
        }
        if (viewProvider == null) {
            viewProvider = (FileViewProvider)file2.getUserData(this.myPsiHardRefKey);
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getFromInjected(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(12);
        }
        if (file2 instanceof VirtualFileWindow) {
            DocumentWindow document = ((VirtualFileWindow)file2).getDocumentWindow();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myManager.getProject()).getCachedPsiFile((Document)document);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getViewProvider();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, @Nullable FileViewProvider fileViewProvider) {
        FileViewProvider prev;
        if (virtualFile == null) {
            FileManagerImpl.$$$reportNull$$$0(13);
        }
        if ((prev = this.findCachedViewProvider(virtualFile)) == fileViewProvider) {
            return;
        }
        if (prev != null) {
            DebugUtil.startPsiModification(null);
            try {
                this.markInvalidated(prev);
                DebugUtil.onInvalidated(prev);
            }
            finally {
                DebugUtil.finishPsiModification();
            }
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (fileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
            } else if (virtualFile instanceof LightVirtualFile) {
                virtualFile.putUserData(this.myPsiHardRefKey, (Object)fileViewProvider);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile, fileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(14);
        }
        FileType fileType = file2.getFileType();
        Language language = LanguageUtil.getLanguageForPsi((Project)this.myManager.getProject(), (VirtualFile)file2);
        FileViewProviderFactory factory = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory == null ? null : factory.createFileViewProvider(file2, language, (PsiManager)this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, file2, eventSystemEnabled, fileType) : viewProvider;
        if (singleRootFileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(15);
        }
        return singleRootFileViewProvider;
    }

    public void markInitialized() {
        LOG.assertTrue(!this.myInitialized);
        this.myDisposed = false;
        this.myInitialized = true;
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }
        });
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    void processFileTypesChanged() {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        DebugUtil.startPsiModification("file type change");
        try {
            ApplicationManager.getApplication().runWriteAction(() -> {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                event.setPropertyName("propFileTypes");
                this.myManager.beforePropertyChange(event);
                this.invalidateAllPsi();
                this.myManager.propertyChanged(event);
            });
        }
        finally {
            DebugUtil.finishPsiModification();
            this.myProcessingFileTypesChange = false;
        }
    }

    void invalidateAllPsi() {
        this.myVFileToPsiDirMap.clear();
        for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
            this.markInvalidated(provider);
        }
        this.myVFileToViewProviderMap.clear();
    }

    void dispatchPendingEvents() {
        if (!this.myInitialized) {
            LOG.error("Project is not yet initialized: " + this.myManager.getProject());
        }
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        for (VirtualFile vFile : fileToViewProvider.keySet()) {
            FileViewProvider fileViewProvider = (FileViewProvider)fileToViewProvider.get(vFile);
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        this.myVFileToPsiDirMap.clear();
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent = vFile.getParent();
            if (parent == null) continue;
            LOG.assertTrue(this.myVFileToPsiDirMap.containsKey(parent));
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(16);
        }
        if (vFile.isDirectory()) {
            return null;
        }
        Project project2 = this.myManager.getProject();
        if (project2.isDefault()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid(), (Object)"Invalid file");
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        if (!this.myInitialized) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(18);
        }
        LOG.assertTrue(this.myInitialized, (Object)"Access to psi files should be performed only after startup activity");
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile) {
        PsiDirectory psiDir;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(19);
        }
        if ((psiDir = (PsiDirectory)this.myVFileToPsiDirMap.get(vFile)) != null) {
            return psiDir;
        }
        if (Registry.is((String)"ide.hide.excluded.files") ? this.myFileIndex.isExcludedFile(vFile) : this.myFileIndex.isUnderIgnored(vFile)) {
            return null;
        }
        VirtualFile parent = vFile.getParent();
        if (parent != null) {
            this.findDirectoryImpl(parent);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return (PsiDirectory)ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, (Object)vFile, (Object)psiDir);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(20);
        }
        return (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
    }

    void removeFilesAndDirsRecursively(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(21);
        }
        DebugUtil.startPsiModification("removeFilesAndDirsRecursively");
        try {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file2.isDirectory()) {
                        FileManagerImpl.this.myVFileToPsiDirMap.remove(file2);
                    } else {
                        FileViewProvider viewProvider = (FileViewProvider)FileManagerImpl.this.myVFileToViewProviderMap.remove(file2);
                        if (viewProvider != null) {
                            FileManagerImpl.this.markInvalidated(viewProvider);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl$2", "visitFile"));
                }
            });
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(22);
        }
        ((AbstractFileViewProvider)viewProvider).markInvalidated();
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document != null) {
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myManager.getProject())).associatePsi(document, null);
        }
        virtualFile.putUserData(this.myPsiHardRefKey, null);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file2) {
        FileViewProvider fileViewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(23);
        }
        if ((fileViewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file2)) == null) {
            fileViewProvider = (FileViewProvider)file2.getUserData(this.myPsiHardRefKey);
        }
        return fileViewProvider != null ? ((AbstractFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
            ContainerUtil.addIfNotNull(files, (Object)((AbstractFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        ArrayList<PsiFile> arrayList = files;
        if (arrayList == null) {
            FileManagerImpl.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private void removeInvalidDirs(boolean useFind) {
        THashMap fileToPsiDirMap = new THashMap(this.myVFileToPsiDirMap);
        if (useFind) {
            this.myVFileToPsiDirMap.clear();
        }
        Iterator iterator = fileToPsiDirMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (!vFile.isValid()) {
                iterator.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator.remove();
        }
        this.myVFileToPsiDirMap.clear();
        this.myVFileToPsiDirMap.putAll((Map<VirtualFile, PsiDirectory>)fileToPsiDirMap);
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        this.removeInvalidDirs(useFind);
        THashMap fileToPsiFileMap = new THashMap(this.myVFileToViewProviderMap);
        THashMap originalFileToPsiFileMap = new THashMap(this.myVFileToViewProviderMap);
        if (useFind) {
            this.myVFileToViewProviderMap.clear();
        }
        Iterator iterator = fileToPsiFileMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (!vFile.isValid()) {
                iterator.remove();
                continue;
            }
            if (!useFind) continue;
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (view == null) {
                iterator.remove();
                continue;
            }
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null) {
                iterator.remove();
                continue;
            }
            if (!FileManagerImpl.areViewProvidersEquivalent(view, psiFile1.getViewProvider())) {
                iterator.remove();
                continue;
            }
            FileManagerImpl.clearPsiCaches(view);
        }
        this.myVFileToViewProviderMap.clear();
        this.myVFileToViewProviderMap.putAll((Map<VirtualFile, FileViewProvider>)fileToPsiFileMap);
        this.markInvalidations((Map<VirtualFile, FileViewProvider>)originalFileToPsiFileMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            FileManagerImpl.$$$reportNull$$$0(25);
        }
        if (view2 == null) {
            FileManagerImpl.$$$reportNull$$$0(26);
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null) {
            return psi2 == null;
        }
        return psi1.getClass() == psi2.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markInvalidations(@NotNull Map<VirtualFile, FileViewProvider> originalFileToPsiFileMap) {
        if (originalFileToPsiFileMap == null) {
            FileManagerImpl.$$$reportNull$$$0(27);
        }
        DebugUtil.startPsiModification(null);
        try {
            for (Map.Entry<VirtualFile, FileViewProvider> entry : originalFileToPsiFileMap.entrySet()) {
                FileViewProvider viewProvider = entry.getValue();
                if (this.myVFileToViewProviderMap.get(entry.getKey()) == viewProvider) continue;
                this.markInvalidated(viewProvider);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file2.getVirtualFile();
        assert (vFile != null);
        if (file2 instanceof PsiBinaryFile) {
            return;
        }
        FileDocumentManager fileDocumentManager = this.myFileDocumentManager;
        Document document = fileDocumentManager.getCachedDocument(vFile);
        if (document != null) {
            fileDocumentManager.reloadFromDisk(document);
        } else {
            this.reloadPsiAfterTextChange(file2, vFile);
        }
    }

    void reloadPsiAfterTextChange(@NotNull PsiFile file2, @NotNull VirtualFile vFile) {
        FileViewProvider latestProvider;
        PsiFile psi;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(29);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(30);
        }
        if ((psi = (latestProvider = this.createFileViewProvider(vFile, false)).getPsi(latestProvider.getBaseLanguage())) instanceof PsiLargeFile || psi instanceof PsiBinaryFile) {
            this.forceReload(vFile);
            return;
        }
        ((AbstractFileViewProvider)file2.getViewProvider()).onContentReload();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 23: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view1";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view2";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileToPsiFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToViewProviderMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewProvider";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCachedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearPsiCaches";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forceReload";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "firePropertyChangedForUnloadedPsi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUpPropertyChangedForUnloadedPsi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFromInjected";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setViewProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryImpl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDirectory";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesAndDirsRecursively";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidated";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFileInner";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "areViewProvidersEquivalent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "reloadPsiAfterTextChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

