/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileReferenceCompletionImpl
extends FileReferenceCompletion {
    private static final TObjectHashingStrategy<PsiElement> VARIANTS_HASHING_STRATEGY = new TObjectHashingStrategy<PsiElement>(){

        public int computeHashCode(PsiElement object) {
            String name2;
            if (object instanceof PsiNamedElement && (name2 = ((PsiNamedElement)object).getName()) != null) {
                return name2.hashCode();
            }
            return object.hashCode();
        }

        public boolean equals(PsiElement o1, PsiElement o2) {
            if (o1 instanceof PsiNamedElement && o2 instanceof PsiNamedElement) {
                return Comparing.equal((String)((PsiNamedElement)o1).getName(), (String)((PsiNamedElement)o2).getName());
            }
            return o1.equals(o2);
        }
    };

    @Override
    @NotNull
    public Object[] getFileReferenceCompletionVariants(final FileReference reference) {
        int i;
        String s = reference.getText();
        if (s != null && s.equals("/")) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        final CommonProcessors.CollectUniquesProcessor collector = new CommonProcessors.CollectUniquesProcessor();
        PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

            public boolean execute(@NotNull PsiFileSystemItem fileSystemItem) {
                if (fileSystemItem == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new FilteringProcessor(reference.getFileReferenceSet().getReferenceCompletionFilter(), (Processor)collector).process((Object)FileReference.getOriginalFile(fileSystemItem));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystemItem", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl$2", "execute"));
            }
        };
        ArrayList additionalItems = ContainerUtil.newArrayList();
        for (PsiFileSystemItem context : reference.getContexts()) {
            for (PsiElement child : context.getChildren()) {
                if (!(child instanceof PsiFileSystemItem)) continue;
                processor2.execute((PsiElement)((PsiFileSystemItem)child));
            }
            if (!(context instanceof FileReferenceResolver)) continue;
            additionalItems.addAll(((FileReferenceResolver)context).getVariants(reference));
        }
        Object[] types = reference.getFileReferenceSet().getSuitableFileTypes();
        THashSet set2 = new THashSet(collector.getResults(), VARIANTS_HASHING_STRATEGY);
        PsiElement[] candidates = PsiUtilCore.toPsiElementArray((Collection)set2);
        Object[] variants = new Object[candidates.length + additionalItems.size()];
        for (i = 0; i < candidates.length; ++i) {
            PsiElement candidate = candidates[i];
            Object item = reference.createLookupItem(candidate);
            if (item == null) {
                item = FileInfoManager.getFileLookupItem(candidate);
            }
            if (candidate instanceof PsiFile && item instanceof LookupElement && types.length > 0 && ArrayUtil.contains((Object)((PsiFile)candidate).getFileType(), (Object[])types)) {
                item = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)item), (double)Double.MAX_VALUE);
            }
            variants[i] = item;
        }
        for (i = 0; i < additionalItems.size(); ++i) {
            variants[i + candidates.length] = additionalItems.get(i);
        }
        if (!reference.getFileReferenceSet().isUrlEncoded()) {
            if (variants == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(1);
            }
            return variants;
        }
        ArrayList<Object> encodedVariants = new ArrayList<Object>(variants.length + additionalItems.size());
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            PsiNamedElement psiElement;
            String name2;
            String encoded;
            PsiElement element = candidates[i2];
            if (!(element instanceof PsiNamedElement) || (encoded = reference.encode(name2 = (psiElement = (PsiNamedElement)element).getName(), (PsiElement)psiElement)) == null) continue;
            if (!encoded.equals(name2)) {
                Icon icon = psiElement.getIcon(3);
                LookupElementBuilder item = FileInfoManager.getFileLookupItem(candidates[i2], encoded, icon);
                encodedVariants.add(item.withTailText(" (" + name2 + ")"));
                continue;
            }
            encodedVariants.add(variants[i2]);
        }
        encodedVariants.addAll(additionalItems);
        Object[] objectArray = ArrayUtil.toObjectArray(encodedVariants);
        if (objectArray == null) {
            FileReferenceCompletionImpl.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl", "getFileReferenceCompletionVariants"));
    }
}

