/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceSet {
    public static final char DOT = '.';
    public static final char DOLLAR = '$';
    public static final char LT = '<';
    public static final char GT = '>';
    public static final char COMMA = ',';
    public static final char QUESTION = '?';
    public static final String EXTENDS = "extends";
    public static final String SUPER = "super";
    private JavaClassReference[] myReferences;
    private List<JavaClassReferenceSet> myNestedGenericParameterReferences;
    private JavaClassReferenceSet myContext;
    private PsiElement myElement;
    private final int myStartInElement;
    private final JavaClassReferenceProvider myProvider;

    public JavaClassReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, boolean isStatic, @NotNull JavaClassReferenceProvider provider) {
        if (str == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(2);
        }
        this(str, element, startInElement, isStatic, provider, null);
    }

    private JavaClassReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, boolean isStatic, @NotNull JavaClassReferenceProvider provider, JavaClassReferenceSet context) {
        if (str == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(5);
        }
        this.myStartInElement = startInElement;
        this.myProvider = provider;
        this.reparse(str, element, isStatic, context);
    }

    @NotNull
    public JavaClassReferenceProvider getProvider() {
        JavaClassReferenceProvider javaClassReferenceProvider = this.myProvider;
        if (javaClassReferenceProvider == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(6);
        }
        return javaClassReferenceProvider;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiReference[] references = this.getReferences();
        TextRange textRange = new TextRange(references[0].getRangeInElement().getStartOffset(), references[references.length - 1].getRangeInElement().getEndOffset());
        if (textRange == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private void reparse(@NotNull String str, @NotNull PsiElement element, boolean isStaticImport, JavaClassReferenceSet context) {
        if (str == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(8);
        }
        if (element == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(9);
        }
        this.myElement = element;
        this.myContext = context;
        ArrayList<JavaClassReference> referencesList = new ArrayList<JavaClassReference>();
        int currentDot = -1;
        int referenceIndex = 0;
        boolean allowDollarInNames = this.isAllowDollarInNames();
        boolean allowSpaces = this.isAllowSpaces();
        boolean allowGenerics = false;
        boolean allowWildCards = JavaClassReferenceProvider.ALLOW_WILDCARDS.getBooleanValue(this.getOptions());
        boolean allowGenericsCalculated = false;
        boolean parsingClassNames = true;
        while (parsingClassNames) {
            char ch;
            int nextDotOrDollar = -1;
            for (int curIndex = currentDot + 1; curIndex < str.length(); ++curIndex) {
                ch = str.charAt(curIndex);
                if (ch == '.' || ch == '$' && allowDollarInNames) {
                    nextDotOrDollar = curIndex;
                    break;
                }
                if (ch != '<' && ch != ',') continue;
                if (!allowGenericsCalculated) {
                    allowGenerics = !isStaticImport && PsiUtil.isLanguageLevel5OrHigher((PsiElement)element);
                    allowGenericsCalculated = true;
                }
                if (!allowGenerics) continue;
                nextDotOrDollar = curIndex;
                break;
            }
            if (nextDotOrDollar == -1) {
                for (int i = nextDotOrDollar = currentDot + 1; i < str.length() && Character.isJavaIdentifierPart(str.charAt(i)); ++i) {
                    ++nextDotOrDollar;
                }
                parsingClassNames = false;
                int j = JavaClassReferenceSet.skipSpaces(nextDotOrDollar, str.length(), str, allowSpaces);
                if (j < str.length()) {
                    ch = str.charAt(j);
                    boolean recognized = false;
                    if (ch == '[' && (j = JavaClassReferenceSet.skipSpaces(j + 1, str.length(), str, allowSpaces)) < str.length() && str.charAt(j) == ']') {
                        recognized = (j = JavaClassReferenceSet.skipSpaces(j + 1, str.length(), str, allowSpaces)) == str.length();
                    }
                    Boolean aBoolean = JavaClassReferenceProvider.JVM_FORMAT.getValue(this.getOptions());
                    if (!(recognized || aBoolean != null && aBoolean.booleanValue())) {
                        nextDotOrDollar = -1;
                    }
                }
            }
            if (nextDotOrDollar != -1 && nextDotOrDollar < str.length()) {
                char c = str.charAt(nextDotOrDollar);
                if (c == '<') {
                    boolean recognized = false;
                    int start = JavaClassReferenceSet.skipSpaces(nextDotOrDollar + 1, str.length(), str, allowSpaces);
                    int j = str.lastIndexOf(62);
                    int end = JavaClassReferenceSet.skipSpacesBackward(j, 0, str, allowSpaces);
                    if (end != -1 && end > start) {
                        if (this.myNestedGenericParameterReferences == null) {
                            this.myNestedGenericParameterReferences = new ArrayList<JavaClassReferenceSet>(1);
                        }
                        this.myNestedGenericParameterReferences.add(new JavaClassReferenceSet(str.substring(start, end), this.myElement, this.myStartInElement + start, isStaticImport, this.myProvider, this));
                        parsingClassNames = false;
                        j = JavaClassReferenceSet.skipSpaces(j + 1, str.length(), str, allowSpaces);
                        boolean bl = recognized = j == str.length();
                    }
                    if (!recognized) {
                        nextDotOrDollar = -1;
                    }
                } else if (c == ',' && this.myContext != null) {
                    if (this.myContext.myNestedGenericParameterReferences == null) {
                        this.myContext.myNestedGenericParameterReferences = new ArrayList<JavaClassReferenceSet>(1);
                    }
                    int start = JavaClassReferenceSet.skipSpaces(nextDotOrDollar + 1, str.length(), str, allowSpaces);
                    this.myContext.myNestedGenericParameterReferences.add(new JavaClassReferenceSet(str.substring(start), this.myElement, this.myStartInElement + start, isStaticImport, this.myProvider, this));
                    parsingClassNames = false;
                }
            }
            int maxIndex = nextDotOrDollar > 0 ? nextDotOrDollar : str.length();
            int beginIndex = JavaClassReferenceSet.skipSpaces(currentDot + 1, maxIndex, str, allowSpaces);
            int endIndex = JavaClassReferenceSet.skipSpacesBackward(maxIndex, beginIndex, str, allowSpaces);
            boolean skipReference = false;
            if (allowWildCards && str.charAt(beginIndex) == '?') {
                int next = JavaClassReferenceSet.skipSpaces(beginIndex + 1, endIndex, str, allowSpaces);
                if (next != beginIndex + 1) {
                    String keyword;
                    String string = str.startsWith(EXTENDS, next) ? EXTENDS : (keyword = str.startsWith(SUPER, next) ? SUPER : null);
                    if (keyword != null) {
                        beginIndex = next = JavaClassReferenceSet.skipSpaces(next + keyword.length(), endIndex, str, allowSpaces);
                    }
                } else if (endIndex == beginIndex + 1) {
                    skipReference = true;
                }
            }
            if (!skipReference) {
                TextRange textRange = TextRange.create((int)(this.myStartInElement + beginIndex), (int)(this.myStartInElement + endIndex));
                JavaClassReference currentContextRef = this.createReference(referenceIndex, str.substring(beginIndex, endIndex), textRange, isStaticImport);
                ++referenceIndex;
                referencesList.add(currentContextRef);
            }
            if ((currentDot = nextDotOrDollar) >= 0) continue;
            break;
        }
        this.myReferences = referencesList.toArray(new JavaClassReference[referencesList.size()]);
    }

    private static int skipSpaces(int pos, int max, @NotNull String str, boolean allowSpaces) {
        if (str == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(10);
        }
        while (allowSpaces && pos < max && Character.isWhitespace(str.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static int skipSpacesBackward(int pos, int min, @NotNull String str, boolean allowSpaces) {
        if (str == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(11);
        }
        while (allowSpaces && pos > min && Character.isWhitespace(str.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    @NotNull
    protected JavaClassReference createReference(int referenceIndex, @NotNull String referenceText, @NotNull TextRange textRange, boolean staticImport) {
        if (referenceText == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(12);
        }
        if (textRange == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(13);
        }
        JavaClassReference javaClassReference = new JavaClassReference(this, textRange, referenceIndex, referenceText, staticImport);
        if (javaClassReference == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(14);
        }
        return javaClassReference;
    }

    public boolean isAllowDollarInNames() {
        Boolean aBoolean = this.myProvider.getOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES);
        return !Boolean.FALSE.equals(aBoolean) && this.myElement.getLanguage() instanceof XMLLanguage;
    }

    public boolean isAllowSpaces() {
        return true;
    }

    protected boolean isStaticSeparator(char c, boolean strict) {
        return this.isAllowDollarInNames() ? c == '$' : c == '.';
    }

    public void reparse(@NotNull PsiElement element, @NotNull TextRange range) {
        if (element == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(15);
        }
        if (range == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(16);
        }
        String text2 = range.substring(element.getText());
        this.reparse(text2, element, false, this.myContext);
    }

    public JavaClassReference getReference(int index) {
        return this.myReferences[index];
    }

    @NotNull
    public JavaClassReference[] getAllReferences() {
        Object[] result2 = this.myReferences;
        if (this.myNestedGenericParameterReferences != null) {
            for (JavaClassReferenceSet set2 : this.myNestedGenericParameterReferences) {
                result2 = (JavaClassReference[])ArrayUtil.mergeArrays((Object[])result2, (Object[])set2.getAllReferences());
            }
        }
        if (result2 == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(17);
        }
        return result2;
    }

    public boolean canReferencePackage(int index) {
        if (index == this.myReferences.length - 1) {
            return false;
        }
        String text2 = this.getElement().getText();
        return text2.charAt(this.myReferences[index].getRangeInElement().getEndOffset()) != '$';
    }

    public boolean isSoft() {
        return this.myProvider.isSoft();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.myReferences == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(19);
        }
        return this.myReferences;
    }

    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myProvider.getOptions();
    }

    @NotNull
    public String getUnresolvedMessagePattern(int index) {
        if (this.canReferencePackage(index)) {
            String string = JavaErrorMessages.message("error.cannot.resolve.class.or.package", new Object[0]);
            if (string == null) {
                JavaClassReferenceSet.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = JavaErrorMessages.message("error.cannot.resolve.class", new Object[0]);
        if (string == null) {
            JavaClassReferenceSet.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceSet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "skipSpaces";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "skipSpacesBackward";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

