/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodPropertyReference
extends BasicAttributeValueReference {
    private final boolean myReadable;

    public MethodPropertyReference(PsiElement element, boolean readable) {
        super(element);
        this.myReadable = readable;
    }

    protected PsiClass resolveClass() {
        PsiReference[] references;
        PsiElement classReferencesElement = this.getClassReferencesElement();
        if (classReferencesElement != null && (references = classReferencesElement.getReferences()).length > 0) {
            PsiElement psiElement = references[references.length - 1].resolve();
            if (psiElement instanceof XmlAttributeValue) {
                PsiElement classElement;
                PsiReference[] classReferences;
                XmlTag beanTag = (XmlTag)psiElement.getParent().getParent();
                XmlAttribute attribute = beanTag.getAttribute("class", null);
                if (attribute == null) {
                    attribute = beanTag.getAttribute("type", null);
                }
                if (attribute != null && (classReferences = attribute.getValueElement().getReferences()).length > 0 && (classElement = classReferences[classReferences.length - 1].resolve()) instanceof PsiClass) {
                    return (PsiClass)classElement;
                }
            } else {
                PsiType type2;
                if (psiElement instanceof PsiClass) {
                    return (PsiClass)psiElement;
                }
                if (psiElement instanceof PsiVariable && (type2 = ((PsiVariable)psiElement).getType()) instanceof PsiClassType) {
                    return ((PsiClassType)type2).resolve();
                }
            }
        }
        return null;
    }

    protected PsiElement getClassReferencesElement() {
        XmlTag tag = (XmlTag)this.myElement.getParent().getParent();
        XmlAttribute name2 = tag.getAttribute("name", null);
        if (name2 != null) {
            return name2.getValueElement();
        }
        return null;
    }

    @Nullable
    public PsiElement resolve() {
        return JspSpiUtil.resolveMethodPropertyReference(this, this.resolveClass(), this.myReadable);
    }

    @Override
    public PsiElement handleElementRename(String _newElementName) throws IncorrectOperationException {
        String newElementName = PropertyUtilBase.getPropertyName((String)_newElementName);
        if (newElementName == null) {
            newElementName = _newElementName;
        }
        return super.handleElementRename(newElementName);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = JspSpiUtil.getMethodPropertyReferenceVariants(this, this.resolveClass(), this.myReadable);
        if (objectArray == null) {
            MethodPropertyReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/MethodPropertyReference", "getVariants"));
    }
}

