/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PathListReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            PathListReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PathListReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            PathListReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    protected boolean disableNonSlashedPaths() {
        return true;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        Object[] refs;
        if (element == null) {
            PathListReferenceProvider.$$$reportNull$$$0(3);
        }
        Object[] result2 = PsiReference.EMPTY_ARRAY;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(element);
        String s = range.substring(element.getText());
        int offset = range.getStartOffset();
        if (this.disableNonSlashedPaths() && !s.trim().startsWith("/")) {
            if (result2 == null) {
                PathListReferenceProvider.$$$reportNull$$$0(4);
            }
            return result2;
        }
        int pos = -1;
        char separator = this.getSeparator();
        while (true) {
            int nextPos;
            if ((nextPos = s.indexOf(separator, pos + 1)) == -1) break;
            refs = this.createReferences(element, s.substring(pos + 1, nextPos), pos + offset + 1, false);
            result2 = (PsiReference[])ArrayUtil.mergeArrays((Object[])result2, (Object[])refs);
            pos = nextPos;
        }
        refs = this.createReferences(element, s.substring(pos + 1), pos + offset + 1, false);
        result2 = (PsiReference[])ArrayUtil.mergeArrays((Object[])result2, (Object[])refs);
        if (result2 == null) {
            PathListReferenceProvider.$$$reportNull$$$0(5);
        }
        return result2;
    }

    protected char getSeparator() {
        return ',';
    }

    @NotNull
    protected PsiReference[] createReferences(@NotNull PsiElement element, String s, int offset, final boolean soft) {
        int contentOffset;
        if (element == null) {
            PathListReferenceProvider.$$$reportNull$$$0(6);
        }
        if ((contentOffset = StringUtil.findFirst((CharSequence)s, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER)) >= 0) {
            offset += contentOffset;
        }
        PsiReference[] psiReferenceArray = new FileReferenceSet(s.trim(), element, offset, this, true){

            @Override
            protected boolean isSoft() {
                return soft;
            }
        }.getAllReferences();
        if (psiReferenceArray == null) {
            PathListReferenceProvider.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

