/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTree;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AstPath
extends SubstrateRef {
    private static final CompositeElement[] REMOVED_PATH_CHILDREN = new CompositeElement[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.AstPath");
    private static final Key<CompositeElement[]> PATH_CHILDREN = Key.create((String)"PATH_CHILDREN");
    private static final Key<AstPath> NODE_PATH = Key.create((String)"NODE_PATH");

    @Override
    @NotNull
    public abstract PsiFileImpl getContainingFile();

    @Override
    @NotNull
    public abstract CompositeElement getNode();

    @Override
    public boolean isValid() {
        return this.getContainingFile().isValid();
    }

    protected abstract int getDepth();

    @Override
    @Nullable
    public Stub getStub(int stubIndex) {
        if (stubIndex < 0) {
            return null;
        }
        StubTree stubTree = this.getFileStubTree();
        return stubTree == null ? null : (Stub)stubTree.getPlainList().get(stubIndex);
    }

    @Nullable
    protected abstract StubTree getFileStubTree();

    @Override
    @Nullable
    public Stub getGreenStub(int stubIndex) {
        if (stubIndex < 0) {
            return null;
        }
        StubTree stubTree = this.getContainingFile().getGreenStubTree();
        return stubTree == null ? null : (Stub)stubTree.getPlainList().get(stubIndex);
    }

    @Nullable
    public static AstPath getNodePath(@NotNull CompositeElement node) {
        if (node == null) {
            AstPath.$$$reportNull$$$0(0);
        }
        if (node instanceof FileElement) {
            PsiElement psi = node.getCachedPsi();
            if (!(psi instanceof PsiFileImpl)) {
                return null;
            }
            PsiFileImpl file2 = (PsiFileImpl)psi;
            if (!(file2.getVirtualFile() instanceof VirtualFileWithId) || file2.getElementTypeForStubBuilder() == null) {
                return null;
            }
            return new RootPath(file2);
        }
        return (AstPath)node.getUserData(NODE_PATH);
    }

    static void cacheNodePaths(final @NotNull LazyParseableElement parent) {
        AstPath parentPath;
        if (parent == null) {
            AstPath.$$$reportNull$$$0(1);
        }
        if ((parentPath = AstPath.getNodePath(parent)) == null) {
            return;
        }
        final int depth = parentPath.getDepth() + 1;
        final ArrayList children2 = ContainerUtil.newArrayList();
        parent.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite != parent && (composite instanceof LazyParseableElement || composite.getElementType() instanceof IStubElementType)) {
                    int index = children2.size();
                    composite.putUserData(NODE_PATH, depth % 4 == 0 ? new MilestoneChildPath(parentPath, index, depth) : new ChildPath(parentPath, index));
                    children2.add(composite);
                }
                super.visitComposite(composite);
            }
        });
        parent.putUserData(PATH_CHILDREN, children2.isEmpty() ? CompositeElement.EMPTY_ARRAY : children2.toArray(CompositeElement.EMPTY_ARRAY));
    }

    public static void invalidatePaths(@NotNull LazyParseableElement scope) {
        CompositeElement[] children2;
        if (scope == null) {
            AstPath.$$$reportNull$$$0(2);
        }
        if ((children2 = (CompositeElement[])scope.getUserData(PATH_CHILDREN)) == null) {
            return;
        }
        scope.putUserData(PATH_CHILDREN, REMOVED_PATH_CHILDREN);
        for (CompositeElement child : children2) {
            child.putUserData(NODE_PATH, null);
            AstPath.assertConsistency(child.getCachedPsi());
            if (!(child instanceof LazyParseableElement)) continue;
            AstPath.invalidatePaths((LazyParseableElement)child);
        }
    }

    private static void assertConsistency(PsiElement cachedPsi) {
        if (cachedPsi instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)cachedPsi).getSubstrateRef() instanceof AstPath) {
            LOG.error("Expected strong reference at " + cachedPsi + " of " + cachedPsi.getClass() + " and " + ((StubBasedPsiElementBase)cachedPsi).getElementType());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/AstPath";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheNodePaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidatePaths";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RootPath
    extends AstPath {
        private final PsiFileImpl myFile;

        RootPath(@NotNull PsiFileImpl file2) {
            if (file2 == null) {
                RootPath.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof RootPath && this.myFile.equals(((RootPath)o).myFile);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        @Override
        @NotNull
        public PsiFileImpl getContainingFile() {
            PsiFileImpl psiFileImpl = this.myFile;
            if (psiFileImpl == null) {
                RootPath.$$$reportNull$$$0(1);
            }
            return psiFileImpl;
        }

        @Override
        @NotNull
        public CompositeElement getNode() {
            FileElement fileElement = this.myFile.calcTreeElement();
            if (fileElement == null) {
                RootPath.$$$reportNull$$$0(2);
            }
            return fileElement;
        }

        @Override
        protected int getDepth() {
            return 0;
        }

        @Override
        protected StubTree getFileStubTree() {
            return this.myFile.getStubTree();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/AstPath$RootPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/AstPath$RootPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MilestoneChildPath
    extends ChildPath {
        private final int myDepth;
        private final PsiFileImpl myFile;
        private volatile WeakReference<CompositeElement> myNode;

        MilestoneChildPath(@NotNull AstPath parent, int index, int depth) {
            if (parent == null) {
                MilestoneChildPath.$$$reportNull$$$0(0);
            }
            super(parent, index);
            this.myDepth = depth;
            this.myFile = parent.getContainingFile();
        }

        @Override
        @NotNull
        public CompositeElement getNode() {
            CompositeElement node = (CompositeElement)SoftReference.dereference(this.myNode);
            if (node == null) {
                node = super.getNode();
                if (this.myFile.mayCacheAst()) {
                    this.myNode = new WeakReference<CompositeElement>(node);
                }
            }
            CompositeElement compositeElement = node;
            if (compositeElement == null) {
                MilestoneChildPath.$$$reportNull$$$0(1);
            }
            return compositeElement;
        }

        @Override
        protected StubTree getFileStubTree() {
            return SoftReference.dereference(this.myNode) == null ? this.myFile.getStubTree() : null;
        }

        @Override
        @NotNull
        public PsiFileImpl getContainingFile() {
            PsiFileImpl psiFileImpl = this.myFile;
            if (psiFileImpl == null) {
                MilestoneChildPath.$$$reportNull$$$0(2);
            }
            return psiFileImpl;
        }

        @Override
        protected int getDepth() {
            return this.myDepth;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/AstPath$MilestoneChildPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/AstPath$MilestoneChildPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChildPath
    extends AstPath {
        private final AstPath myParent;
        private final int myIndex;

        ChildPath(@NotNull AstPath parent, int index) {
            if (parent == null) {
                ChildPath.$$$reportNull$$$0(0);
            }
            this.myParent = parent;
            this.myIndex = index;
        }

        @Override
        @NotNull
        public PsiFileImpl getContainingFile() {
            PsiFileImpl psiFileImpl = this.myParent.getContainingFile();
            if (psiFileImpl == null) {
                ChildPath.$$$reportNull$$$0(1);
            }
            return psiFileImpl;
        }

        @Override
        @NotNull
        public CompositeElement getNode() {
            boolean removed;
            CompositeElement parentNode = this.myParent.getNode();
            parentNode.getFirstChildNode();
            CompositeElement[] children2 = (CompositeElement[])parentNode.getUserData(PATH_CHILDREN);
            boolean bl = removed = children2 == REMOVED_PATH_CHILDREN;
            if (children2 == null || removed) {
                throw this.reportMissingChildren(parentNode, removed);
            }
            if (this.myIndex >= children2.length) {
                throw new AssertionError((Object)(this.myIndex + " >= " + children2.length + "; " + parentNode + " of " + parentNode.getClass()));
            }
            CompositeElement compositeElement = children2[this.myIndex];
            if (compositeElement == null) {
                ChildPath.$$$reportNull$$$0(2);
            }
            return compositeElement;
        }

        private AssertionError reportMissingChildren(CompositeElement parentNode, boolean removed) {
            String message2 = "No path children in " + parentNode + " of " + parentNode.getClass() + "; removed=" + removed;
            PsiFileImpl file2 = this.getContainingFile();
            message2 = message2 + "\n  file: " + file2 + " of " + file2.getClass() + "; physical=" + file2.isPhysical() + "; useStrongRefs=" + file2.useStrongRefs();
            FileElement fileElement = file2.getTreeElement();
            message2 = message2 + "\n  ast=" + fileElement;
            if (fileElement != null) {
                CompositeElement[] rootChildren = (CompositeElement[])fileElement.getUserData(PATH_CHILDREN);
                message2 = message2 + "; root.children=" + (rootChildren == REMOVED_PATH_CHILDREN ? "removed" : (rootChildren == null ? "null" : "nonNull"));
            }
            return new AssertionError((Object)message2);
        }

        @Override
        protected int getDepth() {
            return 1 + this.myParent.getDepth();
        }

        @Override
        protected StubTree getFileStubTree() {
            return this.myParent.getFileStubTree();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ChildPath)) {
                return false;
            }
            ChildPath path = (ChildPath)o;
            return this.myIndex == path.myIndex && this.myParent.equals(path.myParent);
        }

        public int hashCode() {
            return 31 * this.myParent.hashCode() + this.myIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/AstPath$ChildPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/AstPath$ChildPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

