/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.injected.editor.VirtualFileWindowImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiHostRegistrarImpl
implements MultiHostRegistrar,
ModificationTracker {
    private List<Pair<Place, PsiFile>> result;
    private Language myLanguage;
    private List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers;
    private List<PsiLanguageInjectionHost.Shred> shreds;
    private StringBuilder outChars;
    private boolean isOneLineEditor;
    private boolean cleared;
    private String fileExtension;
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentEx myHostDocument;
    private final VirtualFile myHostVirtualFile;
    private final PsiElement myContextElement;
    private final PsiFile myHostPsiFile;
    private ReferenceInjector myReferenceInjector;
    private static final Key<ASTNode> TREE_HARD_REF = Key.create((String)"TREE_HARD_REF");

    public MultiHostRegistrarImpl(@NotNull Project project2, @NotNull PsiFile hostPsiFile, @NotNull PsiElement contextElement) {
        if (project2 == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(0);
        }
        if (hostPsiFile == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(1);
        }
        if (contextElement == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myContextElement = contextElement;
        this.myHostPsiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)hostPsiFile);
        this.myPsiManager = this.myHostPsiFile.getManager();
        this.cleared = true;
        FileViewProvider viewProvider = this.myHostPsiFile.getViewProvider();
        this.myHostVirtualFile = viewProvider.getVirtualFile();
        this.myHostDocument = (DocumentEx)viewProvider.getDocument();
    }

    public List<Pair<Place, PsiFile>> getResult() {
        return this.result;
    }

    @NotNull
    public PsiElement getContextElement() {
        PsiElement psiElement = this.myContextElement;
        if (psiElement == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language) {
        if (language == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(4);
        }
        this.escapers = new SmartList();
        this.shreds = new SmartList();
        this.outChars = new StringBuilder();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
            if (injector == null) {
                throw new UnsupportedOperationException("Cannot inject language '" + language + "' since its getParserDefinition() returns null");
            }
            this.myLanguage = null;
            this.myReferenceInjector = injector;
        }
        this.myLanguage = language;
        MultiHostRegistrarImpl multiHostRegistrarImpl = this;
        if (multiHostRegistrarImpl == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(5);
        }
        return multiHostRegistrarImpl;
    }

    private void clear() {
        this.escapers.clear();
        this.shreds.clear();
        this.outChars.setLength(0);
        this.isOneLineEditor = false;
        this.fileExtension = null;
        this.myLanguage = null;
        this.cleared = true;
    }

    public void setFileExtension(@Nullable String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @NotNull
    public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (host == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (rangeInsideHost == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(7);
        }
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)host);
        assert (containingFile == this.myHostPsiFile) : this.exceptionContext("Trying to inject into foreign file: " + containingFile);
        TextRange hostTextRange = host.getTextRange();
        if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
            this.clear();
            throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
        }
        if (this.myLanguage == null && this.myReferenceInjector == null) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called startInjecting()");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        this.cleared = false;
        int startOffset = this.outChars.length();
        this.outChars.append(prefix);
        LiteralTextEscaper textEscaper = host.createLiteralTextEscaper();
        this.escapers.add((LiteralTextEscaper<? extends PsiLanguageInjectionHost>)textEscaper);
        this.isOneLineEditor |= textEscaper.isOneLine();
        TextRange relevantRange = textEscaper.getRelevantTextRange().intersection(rangeInsideHost);
        if (relevantRange == null) {
            relevantRange = TextRange.from((int)textEscaper.getRelevantTextRange().getStartOffset(), (int)0);
        } else {
            int before = this.outChars.length();
            boolean result2 = textEscaper.decode(relevantRange, this.outChars);
            int after2 = this.outChars.length();
            assert (after2 >= before) : "Escaper " + textEscaper + "(" + textEscaper.getClass() + ") must not mangle char buffer";
            if (!result2) {
                int offsetInHost = textEscaper.getOffsetInHost(this.outChars.length() - before, rangeInsideHost);
                relevantRange = relevantRange.intersection((TextRange)new ProperTextRange(0, offsetInHost));
            }
        }
        this.outChars.append(suffix);
        int endOffset = this.outChars.length();
        TextRange relevantRangeInHost = relevantRange.shiftRight(hostTextRange.getStartOffset());
        SmartPointerManagerImpl manager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject);
        this.shreds.add(new ShredImpl(manager.createSmartPsiFileRangePointer(this.myHostPsiFile, relevantRangeInHost, true), manager.createSmartPsiElementPointer(host, this.myHostPsiFile, true), prefix, suffix, (TextRange)new ProperTextRange(startOffset, endOffset), false));
        MultiHostRegistrarImpl multiHostRegistrarImpl = this;
        if (multiHostRegistrarImpl == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(8);
        }
        return multiHostRegistrarImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneInjecting() {
        try {
            if (this.shreds.isEmpty()) {
                throw new IllegalStateException("Seems you haven't called addPlace()");
            }
            if (this.myReferenceInjector != null) {
                this.addToResults(new Place(this.shreds), null);
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
            Place place = new Place(this.shreds);
            DocumentWindowImpl documentWindow = new DocumentWindowImpl(this.myHostDocument, this.isOneLineEditor, place);
            String fileName = PathUtil.makeFileName((String)this.myHostVirtualFile.getName(), (String)this.fileExtension);
            VirtualFileWindowImpl virtualFile = new VirtualFileWindowImpl(fileName, this.myHostVirtualFile, documentWindow, this.myLanguage, this.outChars);
            Language forcedLanguage = (Language)this.myContextElement.getUserData(InjectedFileViewProvider.LANGUAGE_FOR_INJECTED_COPY_KEY);
            this.myLanguage = forcedLanguage == null ? LanguageSubstitutors.INSTANCE.substituteLanguage(this.myLanguage, (VirtualFile)virtualFile, this.myProject) : forcedLanguage;
            MultiHostRegistrarImpl.createDocument(virtualFile);
            InjectedFileViewProvider viewProvider = new InjectedFileViewProvider(this.myPsiManager, virtualFile, documentWindow, this.myLanguage);
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
            assert (parserDefinition != null) : "Parser definition for language " + this.myLanguage + " is null";
            PsiFile psiFile = parserDefinition.createFile((FileViewProvider)viewProvider);
            SmartPsiElementPointer<PsiLanguageInjectionHost> pointer = ((ShredImpl)this.shreds.get(0)).getSmartPointer();
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                boolean mergeHappened;
                ASTNode parsedNode = MultiHostRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
                assert (parsedNode instanceof FileElement) : "Parsed to " + parsedNode + " instead of FileElement";
                String documentText = documentManager.getLastCommittedDocument(documentWindow).getText();
                assert (((FileElement)parsedNode).textMatches(this.outChars)) : this.exceptionContext("Before patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + this.outChars + "'");
                viewProvider.setPatchingLeaves(true);
                try {
                    MultiHostRegistrarImpl.patchLeaves(parsedNode, this.escapers, place);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(this.exceptionContext("Patch error"), e);
                }
                finally {
                    viewProvider.setPatchingLeaves(false);
                }
                if (!((FileElement)parsedNode).textMatches(documentText)) {
                    throw new AssertionError((Object)this.exceptionContext("After patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + this.outChars + "'"));
                }
                virtualFile.setContent(null, documentWindow.getText(), false);
                virtualFile.setWritable(virtualFile.getDelegate().isWritable());
                MultiHostRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile, pointer);
                PsiFile cachedPsiFile = documentManager.getCachedPsiFile(documentWindow);
                assert (cachedPsiFile == psiFile) : "Cached psi :" + cachedPsiFile + " instead of " + psiFile;
                assert (place.isValid());
                assert (viewProvider.isValid());
                PsiFile newFile = MultiHostRegistrarImpl.registerDocument(documentWindow, psiFile, place, this.myHostPsiFile, documentManager);
                boolean bl = mergeHappened = newFile != psiFile;
                if (mergeHappened) {
                    InjectedLanguageUtil.clearCaches(psiFile, documentWindow);
                    psiFile = newFile;
                    viewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
                    documentWindow = (DocumentWindowImpl)viewProvider.getDocument();
                    virtualFile = (VirtualFileWindowImpl)viewProvider.getVirtualFile();
                    boolean shredsRewritten = MultiHostRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile, pointer);
                    if (!shredsRewritten) {
                        place.dispose();
                        place = documentWindow.getShreds();
                    }
                }
                assert (psiFile.isValid());
                assert (place.isValid());
                assert (viewProvider.isValid());
                try {
                    List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> tokens = MultiHostRegistrarImpl.obtainHighlightTokensFromLexer(this.myLanguage, this.outChars, this.escapers, place, virtualFile, this.myProject);
                    psiFile.putUserData(InjectedLanguageUtil.HIGHLIGHT_TOKENS, tokens);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(this.exceptionContext("Obtaining tokens error"), e);
                }
                this.addToResults(place, psiFile);
                this.assertEverythingIsAllright(documentManager, documentWindow, psiFile);
            }
        }
        finally {
            this.clear();
        }
    }

    @NotNull
    private static DocumentEx createDocument(@NotNull LightVirtualFile virtualFile) {
        CharSequence content;
        if (virtualFile == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(9);
        }
        DocumentImpl document = new DocumentImpl(content, StringUtil.indexOf((CharSequence)(content = virtualFile.getContent()), (char)'\r') >= 0, false);
        FileDocumentManagerImpl.registerDocument(document, (VirtualFile)virtualFile);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(10);
        }
        return documentImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheEverything(@NotNull Place place, @NotNull DocumentWindowImpl documentWindow, @NotNull InjectedFileViewProvider viewProvider, @NotNull PsiFile psiFile, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> pointer) {
        if (place == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(11);
        }
        if (documentWindow == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(12);
        }
        if (viewProvider == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(14);
        }
        if (pointer == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(15);
        }
        FileDocumentManagerImpl.registerDocument(documentWindow, viewProvider.getVirtualFile());
        DebugUtil.startPsiModification("MultiHostRegistrar cacheEverything");
        try {
            viewProvider.forceCachedPsi(psiFile);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        psiFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, pointer);
        ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)psiFile.getProject())).associatePsi(documentWindow, psiFile);
        MultiHostRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
        return viewProvider.setShreds(place, psiFile.getProject());
    }

    @NonNls
    private String exceptionContext(@NonNls String msg) {
        return msg + ".\n" + this.myLanguage + ";\n Host file: " + this.myHostPsiFile + " in '" + this.myHostVirtualFile.getPresentableUrl() + "'" + (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited((Document)this.myHostDocument) ? " (uncommitted)" : "") + "\nContext element " + this.myContextElement.getTextRange() + ": '" + this.myContextElement + "'; Ranges: " + this.shreds;
    }

    private static ASTNode keepTreeFromChameleoningBack(PsiFile psiFile) {
        FileASTNode node = psiFile.getNode();
        ASTNode child = node.getFirstChildNode();
        assert (!TreeUtil.isCollapsedChameleon((ASTNode)node)) : "Chameleon " + node + " is collapsed; file: " + psiFile + "; language: " + psiFile.getLanguage();
        psiFile.putUserData(TREE_HARD_REF, (Object)node);
        if (child == null) assert (node != null);
        return node;
    }

    private void assertEverythingIsAllright(PsiDocumentManagerBase documentManager, DocumentWindowImpl documentWindow, PsiFile psiFile) {
        boolean isAncestor = false;
        for (PsiLanguageInjectionHost.Shred shred : this.shreds) {
            PsiLanguageInjectionHost host = shred.getHost();
            isAncestor |= PsiTreeUtil.isAncestor((PsiElement)this.myContextElement, (PsiElement)host, (boolean)false);
        }
        assert (isAncestor) : this.exceptionContext(this.myContextElement + " must be the parent of at least one of injection hosts");
        InjectedFileViewProvider injectedFileViewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
        assert (injectedFileViewProvider.isValid()) : "Invalid view provider: " + injectedFileViewProvider;
        DocumentEx frozenWindow = documentManager.getLastCommittedDocument(documentWindow);
        assert (psiFile.textMatches((CharSequence)frozenWindow.getText())) : "Document window text mismatch";
        assert (injectedFileViewProvider.getDocument() == documentWindow) : "Provider document mismatch";
        assert (documentManager.getCachedDocument(psiFile) == documentWindow) : "Cached document mismatch";
        assert (Comparing.equal((Object)psiFile.getVirtualFile(), (Object)injectedFileViewProvider.getVirtualFile())) : "Virtual file mismatch: " + psiFile.getVirtualFile() + "; " + injectedFileViewProvider.getVirtualFile();
        PsiDocumentManagerBase.checkConsistency(psiFile, frozenWindow);
    }

    public void addToResults(Place place, PsiFile psiFile, @NotNull MultiHostRegistrarImpl from) {
        if (from == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(16);
        }
        this.addToResults(place, psiFile);
        this.myReferenceInjector = from.myReferenceInjector;
    }

    private void addToResults(Place place, PsiFile psiFile) {
        if (this.result == null) {
            this.result = new SmartList();
        }
        this.result.add((Pair<Place, PsiFile>)Pair.create((Object)((Object)place), (Object)psiFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchLeaves(@NotNull ASTNode parsedNode, @NotNull List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers, @NotNull Place shreds) {
        if (parsedNode == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(17);
        }
        if (escapers == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(18);
        }
        if (shreds == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(19);
        }
        LeafPatcher patcher = new LeafPatcher(shreds, escapers);
        ((TreeElement)parsedNode).acceptTree(patcher);
        assert (((TreeElement)parsedNode).textMatches(patcher.catLeafs)) : "Malformed PSI structure: leaf texts do not add up to the whole file text.\nFile text (from tree)  :'" + parsedNode.getText() + "'\nFile text (from PSI)   :'" + parsedNode.getPsi().getText() + "'\nLeaf texts concatenated:'" + patcher.catLeafs + "';\nFile root: " + parsedNode + "\nLanguage: " + parsedNode.getPsi().getLanguage() + "\nHost file: " + shreds.getHostPointer().getVirtualFile();
        DebugUtil.startPsiModification("injection leaf patching");
        try {
            for (Map.Entry<LeafElement, String> entry : patcher.newTexts.entrySet()) {
                LeafElement leaf = entry.getKey();
                String newText = entry.getValue();
                leaf.rawReplaceWithText(newText);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        TreeUtil.clearCaches((TreeElement)parsedNode);
    }

    private static PsiFile registerDocument(DocumentWindowImpl documentWindow, PsiFile injectedPsi, Place shreds, PsiFile hostPsiFile, PsiDocumentManager documentManager) {
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        for (int i = injected.size() - 1; i >= 0; --i) {
            FileViewProvider viewProvider;
            DocumentWindowImpl oldDocument = (DocumentWindowImpl)injected.get(i);
            PsiFileImpl oldFile = (PsiFileImpl)documentManager.getCachedPsiFile((Document)oldDocument);
            if (oldFile == null || !oldFile.isValid() || !((viewProvider = oldFile.getViewProvider()) instanceof InjectedFileViewProvider) || ((InjectedFileViewProvider)viewProvider).isDisposed()) {
                injected.remove(i);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            InjectedFileViewProvider oldViewProvider = (InjectedFileViewProvider)viewProvider;
            FileASTNode injectedNode = injectedPsi.getNode();
            FileASTNode oldFileNode = oldFile.getNode();
            assert (injectedNode != null) : "New node is null";
            if (!oldDocument.areRangesEqual(documentWindow)) continue;
            if (oldFile.getFileType() != injectedPsi.getFileType() || oldFile.getLanguage() != injectedPsi.getLanguage()) {
                injected.remove(i);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            oldFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, injectedPsi.getUserData(FileContextUtil.INJECTED_IN_ELEMENT));
            assert (shreds.isValid());
            if (!oldFile.textMatches((PsiElement)injectedPsi)) {
                oldViewProvider.performNonPhysically(() -> MultiHostRegistrarImpl.lambda$registerDocument$0(oldFile, (ASTNode)oldFileNode, (ASTNode)injectedNode));
            }
            assert (shreds.isValid());
            return oldFile;
        }
        injected.add(documentWindow);
        return injectedPsi;
    }

    private static List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> obtainHighlightTokensFromLexer(Language language, StringBuilder outChars, List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers, Place shreds, VirtualFileWindow virtualFile, Project project2) {
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)((VirtualFile)virtualFile));
        Lexer lexer = syntaxHighlighter.getHighlightingLexer();
        lexer.start((CharSequence)outChars);
        int hostNum = -1;
        int prevHostEndOffset = 0;
        SmartPsiElementPointer<PsiLanguageInjectionHost> host = null;
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper = null;
        int prefixLength = 0;
        int suffixLength = 0;
        TextRange rangeInsideHost = null;
        int shredEndOffset = -1;
        ArrayList<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> tokens = new ArrayList<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>>(10);
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            ProperTextRange range = new ProperTextRange(lexer.getTokenStart(), lexer.getTokenEnd());
            while (range != null && !range.isEmpty()) {
                if (range.getStartOffset() >= shredEndOffset) {
                    PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(++hostNum);
                    shredEndOffset = shred.getRange().getEndOffset();
                    prevHostEndOffset = range.getStartOffset();
                    host = ((ShredImpl)shred).getSmartPointer();
                    escaper = escapers.get(hostNum);
                    rangeInsideHost = shred.getRangeInsideHost();
                    prefixLength = shred.getPrefix().length();
                    suffixLength = shred.getSuffix().length();
                }
                if (range.getStartOffset() < prevHostEndOffset + prefixLength) {
                    range = new UnfairTextRange(prevHostEndOffset + prefixLength, range.getEndOffset());
                }
                UnfairTextRange spilled = null;
                if (range.getEndOffset() > shredEndOffset - suffixLength) {
                    spilled = new UnfairTextRange(shredEndOffset, range.getEndOffset());
                    range = new UnfairTextRange(range.getStartOffset(), shredEndOffset - suffixLength);
                }
                if (!range.isEmpty()) {
                    int end;
                    int start = escaper.getOffsetInHost(range.getStartOffset() - prevHostEndOffset - prefixLength, rangeInsideHost);
                    if (start == -1) {
                        start = rangeInsideHost.getStartOffset();
                    }
                    if ((end = escaper.getOffsetInHost(range.getEndOffset() - prevHostEndOffset - prefixLength, rangeInsideHost)) == -1) {
                        end = rangeInsideHost.getEndOffset();
                        prevHostEndOffset = shredEndOffset;
                    }
                    ProperTextRange rangeInHost = new ProperTextRange(start, end);
                    tokens.add((Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>)Trinity.create((Object)tokenType, host, (Object)rangeInHost));
                }
                range = spilled;
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return tokens;
    }

    public long getModificationCount() {
        DocumentEx hostDocument;
        List<PsiLanguageInjectionHost.Shred> shredList = this.shreds;
        if (shredList != null) {
            for (PsiLanguageInjectionHost.Shred shred : shredList) {
                if (shred.isValid()) continue;
                return -1L;
            }
        }
        return (hostDocument = this.myHostDocument) == null ? -1L : hostDocument.getModificationStamp();
    }

    public String toString() {
        return String.valueOf(this.result);
    }

    @NotNull
    PsiFile getHostPsiFile() {
        PsiFile psiFile = this.myHostPsiFile;
        if (psiFile == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(20);
        }
        return psiFile;
    }

    ReferenceInjector getReferenceInjector() {
        return this.myReferenceInjector;
    }

    @NotNull
    public static DocumentWindow freezeWindow(@NotNull DocumentWindowImpl window) {
        if (window == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(21);
        }
        Place shreds = window.getShreds();
        Project project2 = shreds.getHostPointer().getProject();
        DocumentEx delegate = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2)).getLastCommittedDocument(window.getDelegate());
        Place place = new Place(ContainerUtil.map((Collection)((Object)shreds), shred -> ((ShredImpl)shred).withPsiRange()));
        DocumentWindowImpl documentWindowImpl = new DocumentWindowImpl(delegate, window.isOneLine(), place);
        if (documentWindowImpl == null) {
            MultiHostRegistrarImpl.$$$reportNull$$$0(22);
        }
        return documentWindowImpl;
    }

    boolean isValid() {
        List<Pair<Place, PsiFile>> result2 = this.getResult();
        if (result2 == null) {
            return false;
        }
        for (Pair<Place, PsiFile> pair2 : result2) {
            if (((Place)((Object)pair2.getFirst())).isValid()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$registerDocument$0(PsiFileImpl oldFile, ASTNode oldFileNode, ASTNode injectedNode) {
        DebugUtil.startPsiModification("injected tree diff");
        try {
            DiffLog diffLog = BlockSupportImpl.mergeTrees(oldFile, oldFileNode, injectedNode, new DaemonProgressIndicator(), oldFileNode.getText());
            DocumentCommitThread.doActualPsiChange(oldFile, diffLog);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapers";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shreds";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/MultiHostRegistrarImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startInjecting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addPlace";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostPsiFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 20: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startInjecting";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPlace";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cacheEverything";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addToResults";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "patchLeaves";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

