/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.PossiblyIncorrectUsage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureProcessorBase
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase");
    protected static final String REFACTORING_ID = "refactoring.changeSignature";
    protected final ChangeInfo myChangeInfo;
    protected final PsiManager myManager;

    protected ChangeSignatureProcessorBase(Project project2, ChangeInfo changeInfo) {
        super(project2);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project2);
    }

    protected ChangeSignatureProcessorBase(Project project2, @Nullable Runnable prepareSuccessfulCallback, ChangeInfo changeInfo) {
        super(project2, prepareSuccessfulCallback);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project2);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = ChangeSignatureProcessorBase.findUsages(this.myChangeInfo);
        if (usageInfoArray == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(0);
        }
        return usageInfoArray;
    }

    public static void collectConflictsFromExtensions(@NotNull Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> conflictDescriptions, ChangeInfo changeInfo) {
        if (refUsages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(1);
        }
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts = usageProcessor.findConflicts(changeInfo, refUsages);
            for (PsiElement key2 : conflicts.keySet()) {
                Collection collection = conflictDescriptions.get((Object)key2);
                if (collection.isEmpty()) {
                    collection = new HashSet();
                }
                collection.addAll(conflicts.get((Object)key2));
                conflictDescriptions.put((Object)key2, collection);
            }
        }
    }

    @NotNull
    public static UsageInfo[] findUsages(ChangeInfo changeInfo) {
        ChangeSignatureUsageProcessor[] processors;
        List<UsageInfo> infos = new ArrayList<UsageInfo>();
        for (ChangeSignatureUsageProcessor processor2 : processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            for (UsageInfo info : processor2.findUsages(changeInfo)) {
                LOG.assertTrue(info != null, (Object)processor2);
                infos.add(info);
            }
        }
        infos = ChangeSignatureProcessorBase.filterUsages(infos);
        UsageInfo[] usageInfoArray = infos.toArray(new UsageInfo[infos.size()]);
        if (usageInfoArray == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    protected static List<UsageInfo> filterUsages(List<UsageInfo> infos) {
        HashMap moveRenameInfos = new HashMap();
        com.intellij.util.containers.hash.HashSet usedElements = new com.intellij.util.containers.hash.HashSet();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(infos.size() / 2);
        for (UsageInfo info : infos) {
            LOG.assertTrue(info != null);
            PsiElement element = info.getElement();
            if (info instanceof MoveRenameUsageInfo) {
                if (usedElements.contains(element)) continue;
                moveRenameInfos.put(element, (MoveRenameUsageInfo)info);
                continue;
            }
            moveRenameInfos.remove(element);
            usedElements.add(element);
            if (info instanceof PossiblyIncorrectUsage && !((PossiblyIncorrectUsage)info).isCorrect()) continue;
            result2.add(info);
        }
        result2.addAll(moveRenameInfos.values());
        return result2;
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(3);
        }
        for (ChangeSignatureUsageProcessor processor2 : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (!processor2.shouldPreviewUsages(this.myChangeInfo, usages)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return REFACTORING_ID;
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.getChangeInfo().getMethod());
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(4);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.getChangeInfo().getMethod());
        return data;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(5);
        }
        RefactoringTransaction transaction = this.getTransaction();
        final ChangeInfo changeInfo = this.myChangeInfo;
        final RefactoringElementListener elementListener = transaction == null ? null : transaction.getElementListener(changeInfo.getMethod());
        final String fqn = CopyReferenceAction.elementToFqn(changeInfo.getMethod());
        if (fqn != null) {
            BasicUndoableAction action = new BasicUndoableAction(){

                public void undo() {
                    if (elementListener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)elementListener).undoElementMovedOrRenamed(changeInfo.getMethod(), fqn);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action);
        }
        try {
            ChangeSignatureProcessorBase.doChangeSignature(changeInfo, usages);
            PsiElement method = changeInfo.getMethod();
            LOG.assertTrue(method.isValid());
            if (elementListener != null && changeInfo.isNameChanged()) {
                elementListener.elementRenamed(method);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void doChangeSignature(ChangeInfo changeInfo, @NotNull UsageInfo[] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(6);
        }
        ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
        ResolveSnapshotProvider resolveSnapshotProvider = changeInfo.isParameterNamesChanged() ? (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(changeInfo.getMethod().getLanguage()) : null;
        ArrayList snapshots = new ArrayList();
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (resolveSnapshotProvider == null) continue;
            changeSignatureUsageProcessor.registerConflictResolvers(snapshots, resolveSnapshotProvider, usages, changeInfo);
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor3 : processors) {
                if (processor3.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, true, usages)) break;
            }
        }
        LOG.assertTrue(changeInfo.getMethod().isValid());
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (changeSignatureUsageProcessor.processPrimaryMethod(changeInfo)) break;
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor2 : processors) {
                if (processor2.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, false, usages)) break;
            }
        }
        if (!snapshots.isEmpty()) {
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : changeInfo.getNewParameters()) {
                for (ResolveSnapshotProvider.ResolveSnapshot snapshot : snapshots) {
                    snapshot.apply(changeSignatureUsageProcessor.getName());
                }
            }
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myChangeInfo.getMethod())});
    }

    public ChangeInfo getChangeInfo() {
        return this.myChangeInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectConflictsFromExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doChangeSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

