/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaMethodDescriptor
implements MethodDescriptor<ParameterInfoImpl, String> {
    private final PsiMethod myMethod;

    public JavaMethodDescriptor(PsiMethod method) {
        this.myMethod = method;
    }

    @Override
    public String getName() {
        return this.myMethod.getName();
    }

    @Override
    public List<ParameterInfoImpl> getParameters() {
        ArrayList<ParameterInfoImpl> result2 = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = this.myMethod.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            ParameterInfoImpl info = new ParameterInfoImpl(i, parameter2.getName(), parameter2.getType());
            info.defaultValue = "";
            result2.add(info);
        }
        return result2;
    }

    @Override
    public String getVisibility() {
        return VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList());
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Override
    public int getParametersCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @Nullable
    public String getReturnTypeText() {
        PsiTypeElement typeElement = this.myMethod.getReturnTypeElement();
        return typeElement != null ? typeElement.getText() : null;
    }

    @Override
    public boolean canChangeVisibility() {
        PsiClass containingClass = this.myMethod.getContainingClass();
        return containingClass != null && !containingClass.isInterface();
    }

    @Override
    public boolean canChangeParameters() {
        return true;
    }

    @Override
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        return this.myMethod.isConstructor() ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    @Override
    public boolean canChangeName() {
        return !this.myMethod.isConstructor();
    }
}

