/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.PsiExpressionCodeFragmentImpl;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class JavaParameterTableModel
extends ParameterTableModelBase<ParameterInfoImpl, ParameterTableModelItemBase<ParameterInfoImpl>> {
    private final Project myProject;

    public JavaParameterTableModel(final PsiElement typeContext, PsiElement defaultValueContext, final RefactoringDialog dialog2) {
        this(typeContext, defaultValueContext, new JavaTypeColumn(typeContext.getProject()), new JavaNameColumn(typeContext.getProject()), new ParameterTableModelBase.DefaultValueColumn<ParameterInfoImpl, ParameterTableModelItemBase<ParameterInfoImpl>>(typeContext.getProject(), (FileType)StdFileTypes.JAVA){

            @Override
            public TableCellEditor doCreateEditor(ParameterTableModelItemBase<ParameterInfoImpl> item) {
                return new EditorWithExpectedType(typeContext);
            }
        }, new ParameterTableModelBase.AnyVarColumn<ParameterInfoImpl, ParameterTableModelItemBase<ParameterInfoImpl>>(){

            @Override
            public boolean isCellEditable(ParameterTableModelItemBase<ParameterInfoImpl> item) {
                boolean isGenerateDelegate = ((ChangeSignatureDialogBase)dialog2).isGenerateDelegate();
                return !isGenerateDelegate && super.isCellEditable(item);
            }
        });
    }

    protected JavaParameterTableModel(PsiElement typeContext, PsiElement defaultValueContext, ColumnInfo ... columns) {
        super(typeContext, defaultValueContext, columns);
        this.myProject = typeContext.getProject();
    }

    @Override
    protected ParameterTableModelItemBase<ParameterInfoImpl> createRowItem(@Nullable ParameterInfoImpl parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new ParameterInfoImpl(-1);
        }
        JavaCodeFragmentFactory f = JavaCodeFragmentFactory.getInstance((Project)this.myProject);
        final PsiTypeCodeFragment paramTypeCodeFragment = f.createTypeCodeFragment(parameterInfo.getTypeText(), this.myTypeContext, true, 2);
        CanonicalTypes.Type paramType = parameterInfo.getTypeWrapper();
        if (paramType != null) {
            paramType.addImportsTo((JavaCodeFragment)paramTypeCodeFragment);
        }
        String value2 = parameterInfo.getDefaultValue();
        PsiExpressionCodeFragment defaultValueCodeFragment = f.createExpressionCodeFragment((String)ObjectUtils.notNull((Object)value2, (Object)""), this.myDefaultValueContext, null, true);
        defaultValueCodeFragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return new ParameterTableModelItemBase<ParameterInfoImpl>(parameterInfo, (PsiCodeFragment)paramTypeCodeFragment, (PsiCodeFragment)defaultValueCodeFragment){

            @Override
            public boolean isEllipsisType() {
                try {
                    return paramTypeCodeFragment.getType() instanceof PsiEllipsisType;
                }
                catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
                    return false;
                }
            }
        };
    }

    @Override
    public void setValueAtWithoutUpdate(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAtWithoutUpdate(aValue, rowIndex, columnIndex);
        PsiType type2 = null;
        if (columnIndex == 0 && aValue instanceof String) {
            try {
                type2 = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeFromText((String)aValue, this.myTypeContext);
            }
            catch (IncorrectOperationException e) {
                type2 = null;
            }
        }
        if (type2 != null) {
            ParameterTableModelItemBase item = (ParameterTableModelItemBase)this.getItem(rowIndex);
            ((PsiExpressionCodeFragmentImpl)item.defaultValueCodeFragment).setExpectedType(type2);
        }
    }

    @Nullable
    private static PsiType getRowType(JTable table, int row) {
        try {
            return ((PsiTypeCodeFragment)((ParameterTableModelItemBase)((JavaParameterTableModel)((Object)table.getModel())).getItems().get((int)row)).typeCodeFragment).getType();
        }
        catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
            return null;
        }
    }

    public static class JavaNameColumn
    extends ParameterTableModelBase.NameColumn<ParameterInfoImpl, ParameterTableModelItemBase<ParameterInfoImpl>> {
        private final Project myProject;

        public JavaNameColumn(Project project2) {
            super(project2);
            this.myProject = project2;
        }

        @Override
        public TableCellEditor doCreateEditor(ParameterTableModelItemBase<ParameterInfoImpl> o) {
            return new VariableCompletionTableCellEditor(this.myProject);
        }

        @Override
        public TableCellRenderer doCreateRenderer(ParameterTableModelItemBase<ParameterInfoImpl> item) {
            return new ColoredTableCellRenderer(){

                public void customizeCellRenderer(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value2 == null) {
                        return;
                    }
                    if (isSelected || hasFocus) {
                        this.acquireState(table, true, false, row, column);
                        this.getCellState().updateRenderer((JComponent)((Object)this));
                        this.setPaintFocusBorder(false);
                    }
                    this.append((String)value2, new SimpleTextAttributes(0, null));
                }
            };
        }
    }

    public static class JavaTypeColumn
    extends ParameterTableModelBase.TypeColumn<ParameterInfoImpl, ParameterTableModelItemBase<ParameterInfoImpl>> {
        public JavaTypeColumn(Project project2) {
            super(project2, (FileType)StdFileTypes.JAVA);
        }

        @Override
        public TableCellEditor doCreateEditor(ParameterTableModelItemBase<ParameterInfoImpl> o) {
            return new JavaCodeFragmentTableCellEditor(this.myProject);
        }
    }

    private static class EditorWithExpectedType
    extends JavaCodeFragmentTableCellEditor {
        public EditorWithExpectedType(PsiElement typeContext) {
            super(typeContext.getProject());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value2, isSelected, row, column);
            PsiType type2 = JavaParameterTableModel.getRowType(table, row);
            if (type2 != null) {
                ((PsiExpressionCodeFragment)this.myCodeFragment).setExpectedType(type2);
            }
            return editor;
        }
    }

    private static class VariableCompletionTableCellEditor
    extends StringTableCellEditor {
        public VariableCompletionTableCellEditor(Project project2) {
            super(project2);
        }

        @Override
        public Component getTableCellEditorComponent(final JTable table, Object value2, boolean isSelected, final int row, int column) {
            final EditorTextField textField2 = (EditorTextField)((Object)super.getTableCellEditorComponent(table, value2, isSelected, row, column));
            textField2.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PsiType type2 = JavaParameterTableModel.getRowType(table, row);
                    if (type2 != null) {
                        VariableCompletionTableCellEditor.completeVariable(textField2, type2);
                    }
                }
            }, KeyStroke.getKeyStroke(32, 2), 2);
            textField2.setBorder(new LineBorder(table.getSelectionBackground()));
            return textField2;
        }

        private static void completeVariable(EditorTextField editorTextField, PsiType type2) {
            Editor editor = editorTextField.getEditor();
            String prefix = editorTextField.getText();
            if (prefix == null) {
                prefix = "";
            }
            LinkedHashSet<LookupElement> set2 = new LinkedHashSet<LookupElement>();
            JavaCompletionUtil.completeVariableNameForRefactoring(editorTextField.getProject(), set2, prefix, type2, VariableKind.PARAMETER);
            LookupElement[] lookupItems = set2.toArray(new LookupElement[set2.size()]);
            editor.getCaretModel().moveToOffset(prefix.length());
            editor.getSelectionModel().removeSelection();
            LookupManager.getInstance(editorTextField.getProject()).showLookup(editor, lookupItems, prefix);
        }
    }
}

