/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDialog;
import com.intellij.refactoring.encapsulateFields.JavaEncapsulateFieldHelper;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EncapsulateFieldsHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.encapsulateFields.EncapsulateFieldsHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"encapsulate.fields.title");

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
                return;
            }
            if (element instanceof PsiField) {
                if (((PsiField)element).getContainingClass() == null) {
                    String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.field.should.be.declared.in.a.class"));
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
                    return;
                }
                this.invoke(project2, new PsiElement[]{element}, dataContext);
                return;
            }
            if (element instanceof PsiClass) {
                this.invoke(project2, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            EncapsulateFieldsHandler.$$$reportNull$$$0(2);
        }
        PsiClass aClass = null;
        HashSet<PsiField> preselectedFields = new HashSet<PsiField>();
        if (((PsiField)elements).length == 1) {
            if (elements[0] instanceof PsiClass) {
                aClass = (PsiClass)elements[0];
            } else {
                if (!(elements[0] instanceof PsiField)) return;
                PsiField field2 = elements[0];
                aClass = field2.getContainingClass();
                preselectedFields.add(field2);
            }
        } else {
            for (PsiField element : elements) {
                if (!(element instanceof PsiField)) {
                    return;
                }
                PsiField field3 = element;
                if (aClass == null) {
                    aClass = field3.getContainingClass();
                    preselectedFields.add(field3);
                    continue;
                }
                if (aClass.equals(field3.getContainingClass())) {
                    preselectedFields.add(field3);
                    continue;
                }
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"fields.to.be.refactored.should.belong.to.the.same.class"));
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
                return;
            }
        }
        LOG.assertTrue(aClass != null);
        List fields = ContainerUtil.filter((Object[])aClass.getFields(), field -> !(field instanceof PsiEnumConstant));
        if (fields.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)"Class has no fields to encapsulate", (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
            return;
        }
        if (aClass.isInterface()) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"encapsulate.fields.refactoring.cannot.be.applied.to.interface"));
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.encapsulateFields");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)aClass)) {
            return;
        }
        EncapsulateFieldsDialog dialog2 = this.createDialog(project2, aClass, preselectedFields);
        dialog2.show();
    }

    protected EncapsulateFieldsDialog createDialog(Project project2, PsiClass aClass, HashSet<PsiField> preselectedFields) {
        return new EncapsulateFieldsDialog(project2, aClass, preselectedFields, new JavaEncapsulateFieldHelper());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/encapsulateFields/EncapsulateFieldsHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

