/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class ReplaceInstanceVariableIncrementDecrement
extends FixableUsageInfo {
    private final PsiUnaryExpression reference;
    @Nullable
    private final String setterName;
    @Nullable
    private final String getterName;
    private final String delegateName;
    private final String fieldName;

    public ReplaceInstanceVariableIncrementDecrement(PsiExpression reference, String delegateName, String setterName, String getterName, String name2) {
        super((PsiElement)reference);
        this.getterName = getterName;
        this.setterName = setterName;
        this.delegateName = delegateName;
        this.fieldName = name2;
        this.reference = (PsiUnaryExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiUnaryExpression.class);
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newExpression;
        PsiReferenceExpression lhs = (PsiReferenceExpression)this.reference.getOperand();
        PsiJavaToken sign = this.reference.getOperationSign();
        PsiElement qualifier = lhs.getQualifier();
        String operator2 = sign.getText();
        if (this.getterName == null && this.setterName == null) {
            newExpression = (qualifier != null ? qualifier.getText() + "." : "") + this.delegateName + "." + this.fieldName + operator2;
        } else {
            String strippedOperator = ReplaceInstanceVariableIncrementDecrement.getStrippedOperator(operator2);
            newExpression = (qualifier != null ? qualifier.getText() + "." : "") + this.delegateName + '.' + this.callSetter(this.delegateName + '.' + this.callGetter() + strippedOperator + "1");
        }
        MutationUtils.replaceExpression(newExpression, (PsiExpression)this.reference);
    }

    private String callGetter() {
        return this.getterName != null ? this.getterName + "()" : this.fieldName;
    }

    private String callSetter(String rhsText) {
        return this.setterName != null ? this.setterName + "(" + rhsText + ")" : this.fieldName + "=" + rhsText;
    }

    private static String getStrippedOperator(String operator2) {
        return operator2.substring(0, operator2.length() - 1);
    }
}

