/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaInplaceIntroducer
extends AbstractInplaceIntroducer<PsiVariable, PsiExpression> {
    protected TypeSelectorManagerImpl myTypeSelectorManager;

    public AbstractJavaInplaceIntroducer(Project project2, Editor editor, PsiExpression expr, PsiVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, String title) {
        super(project2, AbstractJavaInplaceIntroducer.getEditor(editor, expr), (PsiElement)expr, (PsiNameIdentifierOwner)localVariable, (PsiElement[])occurrences, title, (FileType)StdFileTypes.JAVA);
        this.myTypeSelectorManager = typeSelectorManager;
    }

    private static Editor getEditor(Editor editor, PsiExpression expr) {
        return expr != null && Comparing.equal((Object)InjectedLanguageUtil.getTopLevelFile((PsiElement)expr), (Object)expr.getContainingFile()) ? InjectedLanguageUtil.getTopLevelEditor(editor) : editor;
    }

    protected abstract PsiVariable createFieldToStartTemplateOn(String[] var1, PsiType var2);

    protected abstract String[] suggestNames(PsiType var1, String var2);

    protected abstract VariableKind getVariableKind();

    @Override
    protected String[] suggestNames(boolean replaceAll, PsiVariable variable) {
        JavaCodeStyleManager javaCodeStyleManager;
        String paramName;
        int idx;
        PsiType defaultType = this.getType();
        String propertyName = variable != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(variable.getName(), VariableKind.LOCAL_VARIABLE) : null;
        Object[] names = this.suggestNames(defaultType, propertyName);
        if (propertyName != null && names.length > 1 && (idx = ArrayUtil.find((Object[])names, (Object)(paramName = (javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject)).propertyNameToVariableName(propertyName, this.getVariableKind())))) > -1) {
            ArrayUtil.swap((Object[])names, (int)0, (int)idx);
        }
        return names;
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        this.myTypeSelectorManager.setAllOccurrences(replaceAll);
        return this.createFieldToStartTemplateOn(names, this.getType());
    }

    @Override
    protected void correctExpression() {
        PsiElement parent = ((PsiExpression)this.getExpr()).getParent();
        if (parent instanceof PsiExpressionStatement && parent.getLastChild() instanceof PsiErrorElement) {
            this.myExpr = ((PsiExpressionStatement)WriteAction.compute(() -> parent.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myProject).createStatementFromText(parent.getText() + ";", parent)))).getExpression();
            this.myEditor.getCaretModel().moveToOffset(((PsiExpression)this.myExpr).getTextRange().getStartOffset());
        }
    }

    @Override
    public PsiExpression restoreExpression(PsiFile containingFile, PsiVariable psiVariable, RangeMarker marker, String exprText) {
        return AbstractJavaInplaceIntroducer.restoreExpression(containingFile, psiVariable, JavaPsiFacade.getElementFactory((Project)this.myProject), marker, exprText);
    }

    @Override
    protected void restoreState(@NotNull PsiVariable psiField) {
        if (psiField == null) {
            AbstractJavaInplaceIntroducer.$$$reportNull$$$0(0);
        }
        SmartTypePointer typePointer = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(this.getType());
        super.restoreState(psiField);
        for (PsiExpression occurrence : (PsiExpression[])this.myOccurrences) {
            if (occurrence.isValid()) continue;
            return;
        }
        try {
            this.myTypeSelectorManager = this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, typePointer.getType(), (PsiExpression)this.myExpr, (PsiExpression[])this.myOccurrences) : new TypeSelectorManagerImpl(this.myProject, typePointer.getType(), (PsiExpression[])this.myOccurrences);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            AbstractJavaInplaceIntroducer.$$$reportNull$$$0(1);
        }
        TypeSelectorManagerImpl.typeSelected(psiVariable.getType(), this.getType());
        this.myTypeSelectorManager = null;
    }

    public PsiType getType() {
        return this.myTypeSelectorManager.getDefaultType();
    }

    public static String[] appendUnresolvedExprName(String[] names, PsiExpression expr) {
        if (expr instanceof PsiReferenceExpression && ((PsiReferenceExpression)expr).resolve() == null) {
            String name2 = expr.getText();
            if (PsiNameHelper.getInstance((Project)expr.getProject()).isIdentifier(name2, LanguageLevel.HIGHEST)) {
                names = ArrayUtil.mergeArrays((String[])new String[]{name2}, (String[])names);
            }
        }
        return names;
    }

    @Nullable
    public static PsiExpression restoreExpression(PsiFile containingFile, PsiVariable psiVariable, PsiElementFactory elementFactory, RangeMarker marker, String exprText) {
        PsiNewExpression expression2;
        PsiElement refVariableElementParent;
        if (exprText == null) {
            return null;
        }
        if (psiVariable == null || !psiVariable.isValid()) {
            return null;
        }
        PsiElement refVariableElement = containingFile.findElementAt(marker.getStartOffset());
        PsiElement psiElement = refVariableElementParent = refVariableElement != null ? refVariableElement.getParent() : null;
        PsiNewExpression psiNewExpression = refVariableElement instanceof PsiKeyword && refVariableElementParent instanceof PsiNewExpression ? (PsiNewExpression)refVariableElementParent : (expression2 = refVariableElementParent instanceof PsiParenthesizedExpression ? ((PsiParenthesizedExpression)refVariableElementParent).getExpression() : (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiReferenceExpression.class));
        if (expression2 instanceof PsiReferenceExpression && !(expression2.getParent() instanceof PsiMethodCallExpression)) {
            String referenceName = ((PsiReferenceExpression)expression2).getReferenceName();
            if (((PsiReferenceExpression)expression2).resolve() == psiVariable || Comparing.strEqual((String)psiVariable.getName(), (String)referenceName) || Comparing.strEqual((String)exprText, (String)referenceName)) {
                return (PsiExpression)expression2.replace((PsiElement)elementFactory.createExpressionFromText(exprText, (PsiElement)psiVariable));
            }
        }
        if (expression2 == null) {
            expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiExpression.class);
        }
        while (expression2 instanceof PsiReferenceExpression || expression2 instanceof PsiMethodCallExpression) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiMethodCallExpression && parent.getText().equals(exprText)) {
                return (PsiExpression)parent;
            }
            if (parent instanceof PsiExpression) {
                expression2 = (PsiExpression)parent;
                if (!expression2.getText().equals(exprText)) continue;
                return expression2;
            }
            if (!(expression2 instanceof PsiReferenceExpression)) break;
            return null;
        }
        if (expression2 != null && expression2.isValid() && expression2.getText().equals(exprText)) {
            return expression2;
        }
        if (refVariableElementParent instanceof PsiExpression && refVariableElementParent.getText().equals(exprText)) {
            return (PsiExpression)refVariableElementParent;
        }
        return null;
    }

    public static Expression createExpression(final TypeExpression expression2, final String defaultType) {
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult(defaultType);
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return new TextResult(defaultType);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                Object[] elements = expression2.calculateLookupItems(context);
                if (elements != null) {
                    int idx;
                    LookupElement toBeSelected = null;
                    for (LookupElement lookupElement : elements) {
                        if (!(lookupElement instanceof PsiTypeLookupItem) || !((PsiTypeLookupItem)lookupElement).getType().getPresentableText().equals(defaultType)) continue;
                        toBeSelected = lookupElement;
                        break;
                    }
                    if (toBeSelected != null && (idx = ArrayUtil.find((Object[])elements, toBeSelected)) > 0) {
                        return (LookupElement[])ArrayUtil.prepend(toBeSelected, (Object[])ArrayUtil.remove((Object[])elements, (int)idx));
                    }
                }
                return elements;
            }

            public String getAdvertisingText() {
                return null;
            }
        };
    }

    protected String chooseName(String[] names, Language language) {
        String inputName = this.getInputName();
        if (inputName != null && !this.isIdentifier(inputName, language)) {
            inputName = null;
        }
        return inputName != null ? inputName : names[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceParameter/AbstractJavaInplaceIntroducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "saveSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

