/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class AppendAccessorsUsageInfo
extends FixableUsageInfo {
    private final PsiClass myExistingClass;
    private final boolean myGenerateAccessors;
    private final ParameterInfoImpl myParameter;
    private final boolean myGetter;
    private final PsiField myField;

    public AppendAccessorsUsageInfo(PsiParameter psiParameter, PsiClass existingClass, boolean generateAccessors, ParameterInfoImpl parameter2, boolean isGetter, PsiField field) {
        super((PsiElement)psiParameter);
        this.myExistingClass = existingClass;
        this.myGenerateAccessors = generateAccessors;
        this.myParameter = parameter2;
        this.myGetter = isGetter;
        this.myField = field;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        if (this.myGenerateAccessors && this.myField != null) {
            this.myExistingClass.add((PsiElement)(this.myGetter ? GenerateMembersUtil.generateGetterPrototype(this.myField) : GenerateMembersUtil.generateSetterPrototype(this.myField)));
        }
    }

    public boolean isGetter() {
        return this.myGetter;
    }

    public ParameterInfoImpl getParameter() {
        return this.myParameter;
    }

    @Override
    public String getConflictMessage() {
        if (!this.myGenerateAccessors) {
            String fieldName = this.myParameter.getName();
            if (this.myField != null) {
                fieldName = this.myField.getName();
            }
            return (this.myGetter ? "Getter" : "Setter") + " for field '" + fieldName + "' is required";
        }
        return null;
    }

    public boolean equals(Object o) {
        return super.equals(o) && ((AppendAccessorsUsageInfo)((Object)o)).isGetter() == this.isGetter();
    }

    public int hashCode() {
        return super.hashCode() * 29 + (this.isGetter() ? 1 : 0);
    }
}

