/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MoveFilesOrDirectoriesDialog
extends DialogWrapper {
    @NonNls
    private static final String RECENT_KEYS = "MoveFile.RECENT_KEYS";
    @NonNls
    private static final String MOVE_FILES_OPEN_IN_EDITOR = "MoveFile.OpenInEditor";
    private JLabel myNameLabel;
    private TextFieldWithHistoryWithBrowseButton myTargetDirectoryField;
    private String myHelpID;
    private final Project myProject;
    private final Callback myCallback;
    private PsiDirectory myTargetDirectory;
    private JCheckBox myCbSearchForReferences;
    private JCheckBox myOpenInEditorCb;

    public MoveFilesOrDirectoriesDialog(Project project2, Callback callback) {
        super(project2, true);
        this.myProject = project2;
        this.myCallback = callback;
        this.setTitle(RefactoringBundle.message((String)"move.title"));
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            MoveFilesOrDirectoriesDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetDirectoryField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        this.myNameLabel = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        this.myTargetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
        List<String> recentEntries = RecentsManager.getInstance(this.myProject).getRecentEntries(RECENT_KEYS);
        if (recentEntries != null) {
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setHistory(recentEntries);
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"the.file.will.be.moved.to.this.directory"), this.myProject, descriptor2, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        JTextField textField2 = ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getTextEditor();
        FileChooserFactory.getInstance().installFileCompletion(textField2, descriptor2, true, this.getDisposable());
        textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MoveFilesOrDirectoriesDialog.this.validateOKButton();
            }
        });
        this.myTargetDirectoryField.setTextFieldPreferredWidth(70);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myTargetDirectoryField);
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        this.myCbSearchForReferences = new NonFocusableCheckBox(RefactoringBundle.message((String)"search.for.references"));
        this.myCbSearchForReferences.setSelected(RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE);
        this.myOpenInEditorCb = new NonFocusableCheckBox("Open moved files in editor");
        this.myOpenInEditorCb.setSelected(MoveFilesOrDirectoriesDialog.isOpenInEditor());
        return FormBuilder.createFormBuilder().addComponent((JComponent)this.myNameLabel).addLabeledComponent(RefactoringBundle.message((String)"move.files.to.directory.label"), (JComponent)this.myTargetDirectoryField, 12).addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText})).addComponentToRightColumn((JComponent)this.myCbSearchForReferences, 12).addComponentToRightColumn((JComponent)this.myOpenInEditorCb, 12).getPanel();
    }

    public void setData(PsiElement[] psiElements, PsiDirectory initialTargetDirectory, @NonNls String helpID) {
        if (psiElements.length == 1) {
            String text2 = psiElements[0] instanceof PsiFile ? RefactoringBundle.message((String)"move.file.0", (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(((PsiFile)psiElements[0]).getVirtualFile())}) : RefactoringBundle.message((String)"move.directory.0", (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(((PsiDirectory)psiElements[0]).getVirtualFile())});
            this.myNameLabel.setText(text2);
        } else {
            boolean isFile = true;
            boolean isDirectory = true;
            for (PsiElement psiElement : psiElements) {
                isFile &= psiElement instanceof PsiFile;
                isDirectory &= psiElement instanceof PsiDirectory;
            }
            this.myNameLabel.setText(isFile ? RefactoringBundle.message((String)"move.specified.files") : (isDirectory ? RefactoringBundle.message((String)"move.specified.directories") : RefactoringBundle.message((String)"move.specified.elements")));
        }
        String initialTargetPath = initialTargetDirectory == null ? "" : initialTargetDirectory.getVirtualFile().getPresentableUrl();
        ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setText(initialTargetPath);
        int lastDirectoryIdx = initialTargetPath.lastIndexOf(File.separator);
        int textLength = initialTargetPath.length();
        if (lastDirectoryIdx > 0 && lastDirectoryIdx + 1 < textLength) {
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getTextEditor().select(lastDirectoryIdx + 1, textLength);
        }
        this.validateOKButton();
        this.myHelpID = helpID;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }

    public static boolean isOpenInEditor() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(MOVE_FILES_OPEN_IN_EDITOR, false);
    }

    private void validateOKButton() {
        this.setOKActionEnabled(((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText().length() > 0);
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue(MOVE_FILES_OPEN_IN_EDITOR, this.myOpenInEditorCb.isSelected(), false);
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_KEYS, ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText());
        RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE = this.myCbSearchForReferences.isSelected();
        if (DumbService.isDumb((Project)this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)"Move refactoring is not available while indexing is in progress", (String)"Indexing", null);
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Runnable action = () -> {
                String directoryName = ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText().replace(File.separatorChar, '/');
                try {
                    this.myTargetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance((Project)this.myProject), directoryName);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
            if (this.myTargetDirectory == null) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)this.myHelpID, (Project)this.myProject);
                return;
            }
            this.myCallback.run(this);
        }, RefactoringBundle.message((String)"move.title"), null);
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesDialog", "createActions"));
    }

    public static interface Callback {
        public void run(MoveFilesOrDirectoriesDialog var1);
    }
}

