/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandlerBase;

public class DirectoryAsPackageRenameHandler
extends DirectoryAsPackageRenameHandlerBase<PsiPackage> {
    @Override
    protected VirtualFile[] occursInPackagePrefixes(PsiPackage aPackage) {
        return aPackage.occursInPackagePrefixes();
    }

    @Override
    protected boolean isIdentifier(String name2, Project project2) {
        return PsiNameHelper.getInstance((Project)project2).isIdentifier(name2);
    }

    @Override
    protected String getQualifiedName(PsiPackage aPackage) {
        return aPackage.getQualifiedName();
    }

    @Override
    protected PsiPackage getPackage(PsiDirectory psiDirectory) {
        return JavaDirectoryService.getInstance().getPackage(psiDirectory);
    }

    @Override
    protected BaseRefactoringProcessor createProcessor(final String newQName, Project project2, final PsiDirectory[] dirsToRename, boolean searchInComments, boolean searchInNonJavaFiles) {
        return new MoveDirectoryWithClassesProcessor(project2, dirsToRename, null, searchInComments, searchInNonJavaFiles, false, null){

            @Override
            public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(dir.getParentDirectory(), StringUtil.getShortName((String)newQName));
            }

            @Override
            protected String getTargetName() {
                return newQName;
            }

            @Override
            protected String getCommandName() {
                return RefactoringBundle.message((String)(dirsToRename.length == 1 ? "rename.directory.command.name" : "rename.directories.command.name"));
            }
        };
    }
}

