/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JavaNameSuggestionProvider
implements NameSuggestionProvider {
    @Nullable
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result2) {
        PsiElement parentOfParent;
        PsiElement nameSuggestionContextParent;
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return null;
        }
        String initialName = UsageViewUtil.getShortName(element);
        SuggestedNameInfo info = JavaNameSuggestionProvider.suggestNamesForElement(element, nameSuggestionContext);
        if (info != null) {
            info = JavaCodeStyleManager.getInstance((Project)element.getProject()).suggestUniqueVariableName(info, element, true, true);
        }
        String parameterName = null;
        String superMethodName = null;
        if (nameSuggestionContext instanceof PsiParameter && (nameSuggestionContextParent = nameSuggestionContext.getParent()) instanceof PsiParameterList && (parentOfParent = nameSuggestionContextParent.getParent()) instanceof PsiMethod) {
            String propName = PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)parentOfParent));
            if (propName != null) {
                parameterName = propName;
            }
            superMethodName = JavaNameSuggestionProvider.getSuperMethodName((PsiParameter)nameSuggestionContext, (PsiMethod)parentOfParent);
        }
        String[] strings = info != null ? info.names : ArrayUtil.EMPTY_STRING_ARRAY;
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList(strings));
        String[] properlyCased = JavaNameSuggestionProvider.suggestProperlyCasedName(element);
        if (properlyCased != null) {
            Collections.addAll(list2, properlyCased);
        }
        if (parameterName != null && !list2.contains(parameterName)) {
            list2.add(parameterName);
        }
        if (superMethodName != null && !list2.contains(superMethodName)) {
            list2.add(0, superMethodName);
        }
        if (!list2.contains(initialName)) {
            list2.add(initialName);
        } else {
            int i = list2.indexOf(initialName);
            list2.remove(i);
            list2.add(initialName);
        }
        ContainerUtil.removeDuplicates(list2);
        result2.addAll(list2);
        return info;
    }

    @Nullable
    private static String getSuperMethodName(PsiParameter psiParameter, PsiMethod method) {
        PsiMethod[] superMethods;
        int index = method.getParameterList().getParameterIndex(psiParameter);
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            PsiParameterList superParameters = superMethod.getParameterList();
            if (index >= superParameters.getParametersCount()) continue;
            return superParameters.getParameters()[index].getName();
        }
        return null;
    }

    @Nullable
    private static String[] suggestProperlyCasedName(PsiElement psiElement) {
        if (!(psiElement instanceof PsiNamedElement)) {
            return null;
        }
        if (psiElement instanceof PsiFile) {
            return null;
        }
        String name2 = ((PsiNamedElement)psiElement).getName();
        if (name2 == null) {
            return null;
        }
        String prefix = "";
        if (psiElement instanceof PsiVariable) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiElement.getProject());
            VariableKind kind2 = codeStyleManager.getVariableKind((PsiVariable)psiElement);
            prefix = codeStyleManager.getPrefixByVariableKind(kind2);
            if (kind2 == VariableKind.STATIC_FINAL_FIELD) {
                String[] words = NameUtil.splitNameIntoWords((String)name2);
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < words.length; ++i) {
                    String word = words[i];
                    if (i > 0) {
                        buffer.append('_');
                    }
                    buffer.append(StringUtil.toUpperCase((String)word));
                }
                return new String[]{buffer.toString()};
            }
        }
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtil.splitNameIntoWords((String)name2)));
        if (name2.startsWith(prefix) && !prefix.isEmpty()) {
            name2 = name2.substring(prefix.length());
            result2.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtil.splitNameIntoWords((String)name2)));
        }
        result2.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtil.splitNameIntoWords((String)name2.toLowerCase())));
        return ArrayUtil.toStringArray(result2);
    }

    private static String suggestProperlyCasedName(String prefix, String[] words) {
        StringBuilder buffer = new StringBuilder(prefix);
        for (int i = 0; i < words.length; ++i) {
            boolean prefixRequiresCapitalization;
            String word = words[i];
            boolean bl = prefixRequiresCapitalization = prefix.length() > 0 && !StringUtil.endsWithChar((CharSequence)prefix, (char)'_');
            if (i > 0 || prefixRequiresCapitalization) {
                buffer.append(StringUtil.capitalize((String)word));
                continue;
            }
            buffer.append(StringUtil.decapitalize((String)word));
        }
        return buffer.toString();
    }

    @Nullable
    private static SuggestedNameInfo suggestNamesForElement(PsiElement element, PsiElement nameSuggestionContext) {
        PsiIdentifier identifier;
        PsiVariable var = null;
        if (element instanceof PsiVariable) {
            var = (PsiVariable)element;
        } else if (element instanceof PsiIdentifier && (identifier = (PsiIdentifier)element).getParent() instanceof PsiVariable) {
            var = (PsiVariable)identifier.getParent();
        }
        if (var == null) {
            return null;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        VariableKind variableKind = codeStyleManager.getVariableKind(var);
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(variableKind, null, var.getInitializer(), var.getType());
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)nameSuggestionContext, PsiCallExpression.class, (boolean)false, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
        if (expression2 != null) {
            return new SuggestedNameInfo.Delegate(codeStyleManager.suggestVariableName((VariableKind)variableKind, null, (PsiExpression)expression2, (PsiType)var.getType()).names, nameInfo);
        }
        return nameInfo;
    }
}

