/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableInplaceRenameHandler
implements RenameHandler {
    private static final ThreadLocal<String> ourPreventInlineRenameFlag = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler");

    public final boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor == null || file2 == null) {
            return false;
        }
        if (ourPreventInlineRenameFlag.get() != null) {
            return false;
        }
        return this.isAvailable(element, editor, file2);
    }

    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file2) {
        PsiElement nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset());
        RefactoringSupportProvider supportProvider = element == null ? null : (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(element.getLanguage());
        return supportProvider != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceRenameAvailable(element, nameSuggestionContext);
    }

    public final boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement element;
        if (project2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if ((element = PsiElementRenameHandler.getElement(dataContext)) == null) {
            if (LookupManager.getActiveLookup(editor) != null) {
                PsiElement elementUnderCaret = file2.findElementAt(editor.getCaretModel().getOffset());
                if (elementUnderCaret != null) {
                    PsiElement parent = elementUnderCaret.getParent();
                    element = parent instanceof PsiReference ? ((PsiReference)parent).resolve() : PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PsiNamedElement.class);
                }
                if (element == null) {
                    return;
                }
            } else {
                return;
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (this.checkAvailable(element, editor, dataContext)) {
            this.doRename(element, editor, dataContext);
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project2 == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (this.checkAvailable(element, editor, dataContext)) {
            this.doRename(element, editor, dataContext);
        }
    }

    protected boolean checkAvailable(PsiElement elementToRename, Editor editor, DataContext dataContext) {
        if (!this.isAvailableOnDataContext(dataContext)) {
            LOG.error("Recursive invocation");
            RenameHandlerRegistry.getInstance().getRenameHandler(dataContext).invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
            return false;
        }
        return true;
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, Editor editor, DataContext dataContext) {
        VariableInplaceRenamer renamer;
        boolean startedRename;
        if (elementToRename == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        boolean bl = startedRename = (renamer = this.createRenamer(elementToRename, editor)) == null ? false : renamer.performInplaceRename();
        if (!startedRename) {
            VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, renamer != null ? renamer.myInitialName : null);
        }
        return renamer;
    }

    protected static void performDialogRename(PsiElement elementToRename, Editor editor, DataContext dataContext) {
        VariableInplaceRenameHandler.performDialogRename(elementToRename, editor, dataContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void performDialogRename(PsiElement elementToRename, Editor editor, DataContext dataContext, String initialName) {
        try {
            ourPreventInlineRenameFlag.set(initialName == null ? "" : initialName);
            RenameHandler handler2 = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
            assert (handler2 != null) : elementToRename;
            handler2.invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
        }
        finally {
            ourPreventInlineRenameFlag.set(null);
        }
    }

    @Nullable
    public static String getInitialName() {
        String str = ourPreventInlineRenameFlag.get();
        return StringUtil.isEmpty((String)str) ? null : str;
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        if (elementToRename == null) {
            VariableInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        return new VariableInplaceRenamer((PsiNamedElement)elementToRename, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doRename";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

