/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticUsageRenamer;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.util.IncorrectOperationException;
import java.util.List;

public abstract class PsiNamedElementAutomaticRenamer<T extends PsiNamedElement>
extends AutomaticUsageRenamer<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.naming.PsiNamedElementAutomaticRenamer");

    protected PsiNamedElementAutomaticRenamer(List<? extends T> elements, String oldName, String newName) {
        super(elements, oldName, newName);
    }

    @Override
    protected String getName(T element) {
        return element.getName();
    }

    @Override
    protected void doRenameElement(T t) throws IncorrectOperationException {
        t.setName(this.getNewElementName(t));
    }

    @Override
    protected String suggestName(T element) {
        String canonicalName;
        String elementName = this.getName(element);
        NameSuggester suggester = new NameSuggester(this.getOldName(), this.getNewName());
        String newCanonicalName = suggester.suggestName(canonicalName = this.nameToCanonicalName(elementName, element));
        if (newCanonicalName.length() == 0) {
            LOG.error("oldName = " + this.getOldName() + ", newName = " + this.getNewName() + ", name = " + elementName + ", canonicalName = " + canonicalName + ", newCanonicalName = " + newCanonicalName);
        }
        return this.canonicalNameToName(newCanonicalName, element);
    }

    protected String canonicalNameToName(String canonicalName, T element) {
        return canonicalName;
    }

    protected String nameToCanonicalName(String name2, T element) {
        return name2;
    }
}

