/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.refactoring.typeMigration.intentions.ConvertFieldToAtomicIntention;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertFieldToThreadLocalIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(ConvertFieldToThreadLocalIntention.class);

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert to ThreadLocal" == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(1);
        }
        return "Convert to ThreadLocal";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return false;
        }
        if (psiField.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (psiField.getTypeElement() == null) {
            return false;
        }
        PsiType fieldType = psiField.getType();
        PsiClass fieldTypeClass = PsiUtil.resolveClassInType((PsiType)fieldType);
        if (fieldType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)fieldType) || fieldType instanceof PsiArrayType) {
            return true;
        }
        return fieldTypeClass != null && !Comparing.strEqual((String)fieldTypeClass.getQualifiedName(), (String)ThreadLocal.class.getName()) && AllowedApiFilterExtension.isClassAllowed(ThreadLocal.class.getName(), element);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiField psiField;
        if (project2 == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class)) != null);
        PsiType fromType = psiField.getType();
        PsiClassType toType = ConvertFieldToThreadLocalIntention.getMigrationTargetType(fromType, project2, element);
        if (toType == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiField})) {
            return;
        }
        ConvertFieldToAtomicIntention.addExplicitInitializer((PsiVariable)psiField);
        String toTypeCanonicalText = toType.getCanonicalText();
        TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable((PsiVariable)psiField, (PsiType)toType, editor, false, false);
        ConvertFieldToAtomicIntention.postProcessVariable((PsiVariable)psiField, toTypeCanonicalText);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiClassType getMigrationTargetType(@NotNull PsiType fromType, @NotNull Project project2, @NotNull PsiElement context) {
        JavaPsiFacade psiFacade;
        PsiClass threadLocalClass;
        if (fromType == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(8);
        }
        if ((threadLocalClass = (psiFacade = JavaPsiFacade.getInstance((Project)project2)).findClass(ThreadLocal.class.getName(), GlobalSearchScope.allScope((Project)project2))) == null) {
            return null;
        }
        HashMap substitutor = ContainerUtil.newHashMap();
        PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiType type2 = fromType;
            if (fromType instanceof PsiPrimitiveType) {
                type2 = ((PsiPrimitiveType)fromType).getBoxedType(context);
            }
            substitutor.put(typeParameters[0], type2);
        }
        PsiElementFactory factory = psiFacade.getElementFactory();
        return factory.createType(threadLocalClass, factory.createSubstitutor((Map)substitutor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationTargetType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

