/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGuavaTypeConversionRule
extends TypeConversionRule {
    private final SoftLazyValue<Map<String, TypeConversionDescriptorBase>> mySimpleDescriptors = new SoftLazyValue<Map<String, TypeConversionDescriptorBase>>(){

        @NotNull
        protected Map<String, TypeConversionDescriptorBase> compute() {
            HashMap map = new HashMap();
            BaseGuavaTypeConversionRule.this.fillSimpleDescriptors((Map<String, TypeConversionDescriptorBase>)map);
            HashMap hashMap = map;
            if (hashMap == null) {
                1.$$$reportNull$$$0(0);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule$1", "compute"));
        }
    };

    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        if (method == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@Nullable PsiExpression context) {
        return null;
    }

    @NotNull
    public abstract String ruleFromClass();

    @NotNull
    public abstract String ruleToClass();

    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        Set<String> set2 = Collections.emptySet();
        if (set2 == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @Override
    @Nullable
    public final TypeConversionDescriptorBase findConversion(@Nullable PsiType from, @Nullable PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiElement resolvedElement;
        if (from != null && to != null && !BaseGuavaTypeConversionRule.canConvert(from, to, this.ruleFromClass(), this.ruleToClass())) {
            return null;
        }
        if (member instanceof PsiMethod) {
            TypeConversionDescriptorBase descriptor2;
            PsiMethod method = (PsiMethod)member;
            String methodName = method.getName();
            PsiClass aClass = method.getContainingClass();
            if (this.isValidMethodQualifierToConvert(aClass) && (descriptor2 = (TypeConversionDescriptorBase)((Map)this.mySimpleDescriptors.getValue()).get(methodName)) != null) {
                return descriptor2;
            }
            TypeConversionDescriptorBase conversionForMethod = this.findConversionForMethod(from, to, method, methodName, context, labeler);
            return conversionForMethod != null ? conversionForMethod : this.getUnknownMethodConversion();
        }
        if (context instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)context).getAnonymousClass();
            return anonymousClass == null ? null : this.findConversionForAnonymous(anonymousClass, labeler.getSettings(GuavaConversionSettings.class));
        }
        if (context instanceof PsiMethodReferenceExpression) {
            PsiType methodReferenceType = context.getType();
            if (methodReferenceType != null && to != null && to.isAssignableFrom(methodReferenceType)) {
                return new TypeConversionDescriptorBase();
            }
        } else if (context instanceof PsiReferenceExpression && (resolvedElement = ((PsiReferenceExpression)context).resolve()) instanceof PsiVariable) {
            return this.findConversionForVariableReference(context);
        }
        return null;
    }

    protected abstract TypeConversionDescriptorBase getUnknownMethodConversion();

    @Nullable
    protected TypeConversionDescriptorBase findConversionForAnonymous(@NotNull PsiAnonymousClass anonymousClass, @Nullable GuavaConversionSettings settings) {
        Set<String> ignoredAnnotations;
        if (anonymousClass == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(3);
        }
        Set<String> set2 = ignoredAnnotations = settings != null ? settings.getIgnoredAnnotations() : Collections.emptySet();
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymousClass, false, ignoredAnnotations)) {
            return new TypeConversionDescriptorBase(){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    if (evaluator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression2, false, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule$2", "replace"));
                }
            };
        }
        return null;
    }

    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return aClass != null && (this.ruleFromClass().equals(aClass.getQualifiedName()) || this.getAdditionalUtilityClasses().contains(aClass.getQualifiedName()));
    }

    static boolean canConvert(@Nullable PsiType from, @Nullable PsiType to, @NotNull String fromClassName, @NotNull String toClassName) {
        if (fromClassName == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(4);
        }
        if (toClassName == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(5);
        }
        if (!(from instanceof PsiClassType)) {
            return false;
        }
        if (!(to instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult fromResolveResult = ((PsiClassType)from).resolveGenerics();
        PsiClass fromClass = fromResolveResult.getElement();
        if (fromClass instanceof PsiAnonymousClass) {
            fromClass = ((PsiAnonymousClass)fromClass).getBaseClassType().resolve();
        }
        if (fromClass == null || !fromClassName.equals(fromClass.getQualifiedName())) {
            return false;
        }
        PsiClassType.ClassResolveResult toResolveResult = ((PsiClassType)to).resolveGenerics();
        PsiClass toClass = toResolveResult.getElement();
        return toClass != null && toClassName.equals(toClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUtilityClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForMethod";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForAnonymous";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canConvert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

