/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class EnumConstantsUtil {
    private EnumConstantsUtil() {
    }

    public static boolean isSuitableForEnumConstant(PsiType constantType, PsiClass enumClass) {
        if (enumClass != null && enumClass.isEnum()) {
            for (PsiMethod constructor : enumClass.getConstructors()) {
                PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
                if (parameters2.length != 1 || !TypeConversionUtil.isAssignable((PsiType)parameters2[0].getType(), (PsiType)constantType)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiEnumConstant createEnumConstant(PsiClass enumClass, String constantName, PsiExpression initializerExpr) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)enumClass.getProject()).getElementFactory();
        String enumConstantText = initializerExpr != null ? constantName + "(" + initializerExpr.getText() + ")" : constantName;
        return elementFactory.createEnumConstantFromText(enumConstantText, (PsiElement)enumClass);
    }

    public static PsiEnumConstant createEnumConstant(PsiClass enumClass, PsiLocalVariable local, String fieldName) throws IncorrectOperationException {
        return EnumConstantsUtil.createEnumConstant(enumClass, fieldName, local.getInitializer());
    }

    @Nullable
    public static PsiStatement isEnumSwitch(PsiSwitchStatement switchStatement, PsiType enumValueType, Set<Object> enumValues) {
        PsiExpression expression2 = switchStatement.getExpression();
        if (expression2 != null) {
            PsiType expressionType = expression2.getType();
            if (expressionType != null && !TypeConversionUtil.isAssignable((PsiType)expressionType, (PsiType)enumValueType)) {
                return switchStatement;
            }
            PsiConstantEvaluationHelper evaluationHelper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getConstantEvaluationHelper();
            PsiCodeBlock body2 = switchStatement.getBody();
            if (body2 != null) {
                for (PsiStatement statement2 : body2.getStatements()) {
                    PsiSwitchLabelStatement labelStatement;
                    Object caseValue;
                    if (!(statement2 instanceof PsiSwitchLabelStatement) || (caseValue = evaluationHelper.computeConstantExpression((PsiElement)(labelStatement = (PsiSwitchLabelStatement)statement2).getCaseValue())) == null || enumValues.contains(caseValue)) continue;
                    return statement2;
                }
                return null;
            }
        }
        return switchStatement;
    }
}

