/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.duplicates.BreakReturnValue;
import com.intellij.refactoring.util.duplicates.ComplexityHolder;
import com.intellij.refactoring.util.duplicates.ConditionalReturnStatementValue;
import com.intellij.refactoring.util.duplicates.ContinueReturnValue;
import com.intellij.refactoring.util.duplicates.ExpressionReturnValue;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnStatementReturnValue;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesFinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.duplicates.DuplicatesFinder");
    public static final Key<Pair<PsiVariable, PsiType>> PARAMETER = Key.create((String)"PARAMETER");
    @NotNull
    private final PsiElement[] myPattern;
    private final InputVariables myParameters;
    private final List<? extends PsiVariable> myOutputParameters;
    private final List<PsiElement> myPatternAsList;
    private boolean myMultipleExitPoints;
    @Nullable
    private final ReturnValue myReturnValue;
    private final boolean myWithExtractedParameters;
    private final Set<PsiVariable> myEffectivelyLocal;
    private ComplexityHolder myPatternComplexityHolder;
    private ComplexityHolder myCandidateComplexityHolder;

    public DuplicatesFinder(@NotNull PsiElement[] pattern, InputVariables parameters2, @Nullable ReturnValue returnValue, @NotNull List<? extends PsiVariable> outputParameters, boolean withExtractedParameters, @Nullable Set<PsiVariable> effectivelyLocal) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(0);
        }
        if (outputParameters == null) {
            DuplicatesFinder.$$$reportNull$$$0(1);
        }
        this.myReturnValue = returnValue;
        LOG.assertTrue(pattern.length > 0);
        this.myPattern = pattern;
        this.myPatternAsList = Arrays.asList(this.myPattern);
        this.myParameters = parameters2;
        this.myOutputParameters = outputParameters;
        this.myWithExtractedParameters = withExtractedParameters;
        this.myEffectivelyLocal = effectivelyLocal != null ? effectivelyLocal : Collections.emptySet();
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(pattern[0]);
        try {
            int endOffset;
            int startOffset;
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeFragment.getProject()).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false);
            int i = 0;
            while ((startOffset = controlFlow.getStartOffset(pattern[i++])) < 0 && i < pattern.length) {
            }
            int j = pattern.length - 1;
            while ((endOffset = controlFlow.getEndOffset(pattern[j--])) < 0 && j >= 0) {
            }
            IntArrayList exitPoints = new IntArrayList();
            Collection<PsiStatement> exitStatements = ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, exitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
            boolean bl = this.myMultipleExitPoints = exitPoints.size() > 1;
            if (this.myMultipleExitPoints) {
                this.myParameters.removeParametersUsedInExitsOnly(codeFragment, exitStatements, controlFlow, startOffset, endOffset);
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    public DuplicatesFinder(@NotNull PsiElement[] pattern, InputVariables parameters2, @Nullable ReturnValue returnValue, @NotNull List<? extends PsiVariable> outputParameters) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(2);
        }
        if (outputParameters == null) {
            DuplicatesFinder.$$$reportNull$$$0(3);
        }
        this(pattern, parameters2, returnValue, outputParameters, false, null);
    }

    public DuplicatesFinder(PsiElement[] pattern, InputVariables psiParameters, List<? extends PsiVariable> psiVariables) {
        this(pattern, psiParameters, null, psiVariables);
    }

    public InputVariables getParameters() {
        return this.myParameters;
    }

    @NotNull
    public PsiElement[] getPattern() {
        if (this.myPattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(4);
        }
        return this.myPattern;
    }

    @Nullable
    public ReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    public List<Match> findDuplicates(PsiElement scope) {
        this.annotatePattern();
        ArrayList<Match> result2 = new ArrayList<Match>();
        this.findPatternOccurrences(result2, scope);
        this.deannotatePattern();
        return result2;
    }

    @Nullable
    public Match isDuplicate(@NotNull PsiElement element, boolean ignoreParameterTypesAndPostVariableUsages) {
        if (element == null) {
            DuplicatesFinder.$$$reportNull$$$0(5);
        }
        this.annotatePattern();
        Match match = this.isDuplicateFragment(element, ignoreParameterTypesAndPostVariableUsages);
        this.deannotatePattern();
        return match;
    }

    private void annotatePattern() {
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    PsiElement qualifier;
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiVariable) {
                        PsiVariable variable = (PsiVariable)element;
                        PsiType type2 = variable.getType();
                        DuplicatesFinder.this.myParameters.annotateWithParameter(reference);
                        if (DuplicatesFinder.this.myOutputParameters.contains(element)) {
                            reference.putUserData(PARAMETER, (Object)Pair.create((Object)variable, (Object)type2));
                        }
                    }
                    if ((qualifier = reference.getQualifier()) != null) {
                        qualifier.accept((PsiElementVisitor)this);
                    }
                }
            });
        }
    }

    private void deannotatePattern() {
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    if (reference.getUserData(PARAMETER) != null) {
                        reference.putUserData(PARAMETER, null);
                    }
                }
            });
        }
    }

    private void findPatternOccurrences(List<Match> array, PsiElement scope) {
        PsiElement[] children2;
        for (PsiElement child : children2 = scope.getChildren()) {
            Match match = this.isDuplicateFragment(child, false);
            if (match != null) {
                array.add(match);
                continue;
            }
            this.findPatternOccurrences(array, child);
        }
    }

    @Nullable
    private Match isDuplicateFragment(@NotNull PsiElement candidate, boolean ignoreParameterTypesAndPostVariableUsages) {
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(6);
        }
        if (this.isSelf(candidate)) {
            return null;
        }
        PsiElement sibling = candidate;
        ArrayList<PsiElement> candidates = new ArrayList<PsiElement>();
        for (PsiElement element : this.myPattern) {
            if (sibling == null) {
                return null;
            }
            if (!DuplicatesFinder.canBeEquivalent(element, sibling) || this.isSelf(sibling)) {
                return null;
            }
            candidates.add(sibling);
            sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)sibling, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class, PsiEmptyStatement.class});
        }
        LOG.assertTrue(this.myPattern.length == candidates.size());
        if (this.myPattern.length == 1 && this.myPattern[0] instanceof PsiExpression) {
            if (candidates.get(0) instanceof PsiExpression) {
                PsiExpression candidateExpression = (PsiExpression)candidates.get(0);
                if (PsiUtil.isAccessedForWriting((PsiExpression)candidateExpression)) {
                    return null;
                }
                PsiType patternType = ((PsiExpression)this.myPattern[0]).getType();
                PsiType candidateType = candidateExpression.getType();
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiMethod method = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)this.myPattern[0], (Class[])new Class[]{PsiMethod.class});
                if (method != null) {
                    PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)candidate.getProject()).getResolveHelper();
                    substitutor = resolveHelper.inferTypeArguments(method.getTypeParameters(), new PsiType[]{patternType}, new PsiType[]{candidateType}, PsiUtil.getLanguageLevel((PsiElement)method));
                }
                if (!DuplicatesFinder.canTypesBeEquivalent(substitutor.substitute(patternType), candidateType)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        Match match = new Match((PsiElement)candidates.get(0), (PsiElement)candidates.get(candidates.size() - 1), ignoreParameterTypesAndPostVariableUsages);
        for (int i = 0; i < this.myPattern.length; ++i) {
            if (this.matchPattern(this.myPattern[i], candidates.get(i), candidates, match)) continue;
            return null;
        }
        if (!ignoreParameterTypesAndPostVariableUsages && this.checkPostVariableUsages(candidates, match)) {
            return null;
        }
        return match;
    }

    protected boolean isSelf(@NotNull PsiElement candidate) {
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(7);
        }
        for (PsiElement pattern : this.myPattern) {
            if (!PsiTreeUtil.isAncestor((PsiElement)pattern, (PsiElement)candidate, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPostVariableUsages(ArrayList<PsiElement> candidates, Match match) {
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(candidates.get(0));
        try {
            int endOffset;
            int startOffset;
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeFragment.getProject()).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false);
            int i = 0;
            while ((startOffset = controlFlow.getStartOffset(candidates.get(i++))) < 0 && i < candidates.size()) {
            }
            int j = candidates.size() - 1;
            while ((endOffset = controlFlow.getEndOffset(candidates.get(j--))) < 0 && j >= 0) {
            }
            IntArrayList exitPoints = new IntArrayList();
            ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, exitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
            PsiVariable[] outVariables = ControlFlowUtil.getOutputVariables(controlFlow, startOffset, endOffset, exitPoints.toArray());
            if (outVariables.length > 0) {
                if (outVariables.length == 1) {
                    ReturnValue value2;
                    ReturnValue returnValue = match.getReturnValue();
                    if (returnValue == null) {
                        returnValue = this.myReturnValue;
                    }
                    if (returnValue instanceof VariableReturnValue && (value2 = match.getOutputVariableValue(((VariableReturnValue)returnValue).getVariable())) != null) {
                        PsiExpression expression2;
                        if (value2.isEquivalent(new VariableReturnValue(outVariables[0]))) {
                            return false;
                        }
                        if (value2 instanceof ExpressionReturnValue && (expression2 = ((ExpressionReturnValue)value2).getExpression()) instanceof PsiReferenceExpression) {
                            PsiElement variable = ((PsiReferenceExpression)expression2).resolve();
                            return variable == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)outVariables[0]);
                        }
                    }
                }
                return true;
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return false;
    }

    private static boolean canTypesBeEquivalent(PsiType type1, PsiType type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (!type2.isAssignableFrom(type1)) {
            if (type1 instanceof PsiImmediateClassType && type2 instanceof PsiImmediateClassType) {
                PsiClass psiClass1 = ((PsiImmediateClassType)type1).resolve();
                PsiClass psiClass2 = ((PsiImmediateClassType)type2).resolve();
                if (!(psiClass1 instanceof PsiAnonymousClass && psiClass2 instanceof PsiAnonymousClass && psiClass1.getManager().areElementsEquivalent((PsiElement)((PsiAnonymousClass)psiClass1).getBaseClassType().resolve(), (PsiElement)((PsiAnonymousClass)psiClass2).getBaseClassType().resolve()))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean canBeEquivalent(PsiElement pattern, PsiElement candidate) {
        if (pattern instanceof PsiReturnStatement && candidate instanceof PsiExpressionStatement) {
            return true;
        }
        if (pattern instanceof PsiReturnStatement && candidate instanceof PsiDeclarationStatement) {
            return true;
        }
        if (pattern instanceof PsiThisExpression && candidate instanceof PsiReferenceExpression) {
            return true;
        }
        ASTNode node1 = pattern.getNode();
        ASTNode node2 = candidate.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        if (pattern instanceof PsiUnaryExpression) {
            return ((PsiUnaryExpression)pattern).getOperationTokenType() == ((PsiUnaryExpression)candidate).getOperationTokenType();
        }
        if (pattern instanceof PsiPolyadicExpression) {
            return ((PsiPolyadicExpression)pattern).getOperationTokenType() == ((PsiPolyadicExpression)candidate).getOperationTokenType();
        }
        return true;
    }

    private boolean matchPattern(PsiElement pattern, PsiElement candidate, List<PsiElement> candidates, Match match) {
        PsiExpression lExpression;
        Boolean matchedExtractablePart;
        if (pattern == null || candidate == null) {
            return pattern == candidate;
        }
        if (pattern.getUserData(PARAMETER) != null) {
            Pair parameter2 = (Pair)pattern.getUserData(PARAMETER);
            if (!this.myWithExtractedParameters || ((PsiType)parameter2.second).equals(((PsiVariable)parameter2.first).getType())) {
                return match.putParameter((Pair<PsiVariable, PsiType>)parameter2, candidate);
            }
        }
        if ((matchedExtractablePart = this.matchExtractableExpression(pattern, candidate, candidates, match, false)) != null) {
            return matchedExtractablePart;
        }
        if (!DuplicatesFinder.canBeEquivalent(pattern, candidate)) {
            return false;
        }
        if (pattern instanceof PsiExpressionList && candidate instanceof PsiExpressionList) {
            PsiElement resolved;
            PsiExpression[] expressions2 = ((PsiExpressionList)pattern).getExpressions();
            PsiExpression[] childExpressions = ((PsiExpressionList)candidate).getExpressions();
            if (expressions2.length > 0 && expressions2[expressions2.length - 1] instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)expressions2[expressions2.length - 1]).resolve()) instanceof PsiParameter && ((PsiParameter)resolved).getType() instanceof PsiEllipsisType) {
                for (int i = 0; i < expressions2.length - 1; ++i) {
                    Pair parameter3 = (Pair)expressions2[i].getUserData(PARAMETER);
                    if (!(parameter3 == null ? !this.matchPattern((PsiElement)expressions2[i], (PsiElement)childExpressions[i], candidates, match) : !match.putParameter((Pair<PsiVariable, PsiType>)parameter3, (PsiElement)childExpressions[i]))) continue;
                    return false;
                }
                Pair param = (Pair)expressions2[expressions2.length - 1].getUserData(PARAMETER);
                if (param == null) {
                    return false;
                }
                for (int i = expressions2.length - 1; i < childExpressions.length; ++i) {
                    if (match.putParameter((Pair<PsiVariable, PsiType>)param, (PsiElement)childExpressions[i])) continue;
                    return false;
                }
                return true;
            }
        }
        if (pattern instanceof PsiAssignmentExpression ? (lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)pattern).getLExpression())).getType() instanceof PsiPrimitiveType && lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() instanceof PsiParameter : pattern instanceof PsiUnaryExpression && DuplicatesFinder.checkParameterModification(((PsiUnaryExpression)pattern).getOperand(), ((PsiUnaryExpression)pattern).getOperationTokenType(), ((PsiUnaryExpression)candidate).getOperand())) {
            return false;
        }
        if (pattern instanceof PsiJavaCodeReferenceElement) {
            PsiElement resolveResult1 = ((PsiJavaCodeReferenceElement)pattern).resolve();
            PsiElement resolveResult2 = ((PsiJavaCodeReferenceElement)candidate).resolve();
            if (resolveResult1 instanceof PsiClass && resolveResult2 instanceof PsiClass) {
                return true;
            }
            if (DuplicatesFinder.isUnder(resolveResult1, this.myPatternAsList) && DuplicatesFinder.isUnder(resolveResult2, candidates)) {
                DuplicatesFinder.traverseParameter(resolveResult1, resolveResult2, match);
                return match.putDeclarationCorrespondence(resolveResult1, resolveResult2);
            }
            if (resolveResult1 instanceof PsiVariable && this.myEffectivelyLocal.contains((PsiVariable)resolveResult1)) {
                return (resolveResult2 instanceof PsiLocalVariable || resolveResult2 instanceof PsiParameter) && match.putDeclarationCorrespondence(resolveResult1, resolveResult2);
            }
            PsiElement qualifier2 = ((PsiJavaCodeReferenceElement)candidate).getQualifier();
            if (!DuplicatesFinder.equivalentResolve(resolveResult1, resolveResult2, qualifier2)) {
                return this.matchExtractableVariable(pattern, candidate, match);
            }
            PsiElement qualifier1 = ((PsiJavaCodeReferenceElement)pattern).getQualifier();
            if (qualifier1 instanceof PsiReferenceExpression && qualifier2 instanceof PsiReferenceExpression && !match.areCorrespond(((PsiReferenceExpression)qualifier1).resolve(), ((PsiReferenceExpression)qualifier2).resolve())) {
                return false;
            }
            if (qualifier1 == null && qualifier2 == null) {
                PsiClass patternClass = RefactoringChangeUtil.getThisClass(pattern);
                PsiClass candidateClass = RefactoringChangeUtil.getThisClass(candidate);
                if (resolveResult1 == resolveResult2 && resolveResult1 instanceof PsiMember) {
                    PsiClass containingClass = ((PsiMember)resolveResult1).getContainingClass();
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)candidateClass, (PsiClass)patternClass, (boolean)true) && InheritanceUtil.isInheritorOrSelf((PsiClass)candidateClass, (PsiClass)containingClass, (boolean)true) && InheritanceUtil.isInheritorOrSelf((PsiClass)patternClass, (PsiClass)containingClass, (boolean)true)) {
                        return false;
                    }
                }
            }
        }
        if (pattern instanceof PsiTypeCastExpression) {
            PsiType type2;
            PsiType type1;
            PsiTypeElement castTypeElement1 = ((PsiTypeCastExpression)pattern).getCastType();
            PsiTypeElement castTypeElement2 = ((PsiTypeCastExpression)candidate).getCastType();
            if (castTypeElement1 != null && castTypeElement2 != null && !(type1 = TypeConversionUtil.erasure((PsiType)castTypeElement1.getType())).equals(type2 = TypeConversionUtil.erasure((PsiType)castTypeElement2.getType()))) {
                return false;
            }
        } else if (pattern instanceof PsiNewExpression) {
            PsiType type1 = ((PsiNewExpression)pattern).getType();
            PsiType type2 = ((PsiNewExpression)candidate).getType();
            if (type1 == null || type2 == null) {
                return false;
            }
            PsiMethod constructor1 = ((PsiNewExpression)pattern).resolveConstructor();
            PsiMethod constructor2 = ((PsiNewExpression)candidate).resolveConstructor();
            if (constructor1 != null && constructor2 != null ? !pattern.getManager().areElementsEquivalent((PsiElement)constructor1, (PsiElement)constructor2) : !DuplicatesFinder.canTypesBeEquivalent(type1, type2)) {
                return false;
            }
        } else {
            PsiTypeElement operand2;
            PsiTypeElement operand1;
            if (pattern instanceof PsiClassObjectAccessExpression) {
                operand1 = ((PsiClassObjectAccessExpression)pattern).getOperand();
                operand2 = ((PsiClassObjectAccessExpression)candidate).getOperand();
                return operand1.getType().equals(operand2.getType());
            }
            if (pattern instanceof PsiInstanceOfExpression) {
                operand1 = ((PsiInstanceOfExpression)pattern).getCheckType();
                operand2 = ((PsiInstanceOfExpression)candidate).getCheckType();
                if (operand1 == null || operand2 == null) {
                    return false;
                }
                if (!operand1.getType().equals(operand2.getType())) {
                    return false;
                }
            } else {
                PsiJavaCodeReferenceElement candidateQualifier;
                PsiElement contextClass;
                PsiJavaCodeReferenceElement qualifier;
                if (pattern instanceof PsiReturnStatement) {
                    PsiReturnStatement patternReturnStatement = (PsiReturnStatement)pattern;
                    return this.matchReturnStatement(patternReturnStatement, candidate, candidates, match);
                }
                if (pattern instanceof PsiContinueStatement) {
                    match.registerReturnValue(new ContinueReturnValue());
                } else if (pattern instanceof PsiBreakStatement) {
                    match.registerReturnValue(new BreakReturnValue());
                } else if (pattern instanceof PsiMethodCallExpression) {
                    PsiMethod patternMethod = ((PsiMethodCallExpression)pattern).resolveMethod();
                    PsiMethod candidateMethod = ((PsiMethodCallExpression)candidate).resolveMethod();
                    if (patternMethod != null && candidateMethod != null && !MethodSignatureUtil.areSignaturesEqual((PsiMethod)patternMethod, (PsiMethod)candidateMethod)) {
                        return false;
                    }
                } else if (pattern instanceof PsiReferenceExpression) {
                    PsiReferenceExpression patternRefExpr = (PsiReferenceExpression)pattern;
                    PsiReferenceExpression candidateRefExpr = (PsiReferenceExpression)candidate;
                    PsiExpression patternQualifier = patternRefExpr.getQualifierExpression();
                    PsiExpression candidateQualifier2 = candidateRefExpr.getQualifierExpression();
                    if (patternQualifier == null) {
                        PsiElement resolved;
                        PsiClass contextClass2 = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)pattern, (Class[])new Class[]{PsiClass.class});
                        if (candidateQualifier2 instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)candidateQualifier2).resolve()) instanceof PsiClass && contextClass2 != null && InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass2, (PsiClass)((PsiClass)resolved), (boolean)true)) {
                            return true;
                        }
                        return contextClass2 != null && match.registerInstanceExpression(candidateQualifier2, contextClass2);
                    }
                    if (candidateQualifier2 == null) {
                        PsiClass contextClass3;
                        if (patternQualifier instanceof PsiThisExpression) {
                            PsiJavaCodeReferenceElement qualifier2 = ((PsiThisExpression)patternQualifier).getQualifier();
                            if (candidate instanceof PsiReferenceExpression) {
                                contextClass3 = qualifier2 == null ? PsiTreeUtil.getContextOfType((PsiElement)pattern, (Class[])new Class[]{PsiClass.class}) : qualifier2.resolve();
                                return contextClass3 instanceof PsiClass && match.registerInstanceExpression(((PsiReferenceExpression)candidate).getQualifierExpression(), contextClass3);
                            }
                        } else {
                            PsiType type2 = patternQualifier.getType();
                            contextClass3 = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
                            try {
                                PsiClass classContext;
                                PsiElement resolved;
                                Pair parameter4 = (Pair)patternQualifier.getUserData(PARAMETER);
                                if (parameter4 != null) {
                                    PsiClass thisCandidate;
                                    PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)parameter4.first);
                                    if (contextClass3 != null && InheritanceUtil.isInheritorOrSelf((PsiClass)thisClass, (PsiClass)contextClass3, (boolean)true)) {
                                        contextClass3 = thisClass;
                                    }
                                    if ((thisCandidate = RefactoringChangeUtil.getThisClass(candidate)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)thisCandidate, (PsiClass)contextClass3, (boolean)true)) {
                                        contextClass3 = thisCandidate;
                                    }
                                    return contextClass3 != null && match.putParameter((Pair<PsiVariable, PsiType>)parameter4, (PsiElement)RefactoringChangeUtil.createThisExpression(patternQualifier.getManager(), contextClass3));
                                }
                                return patternQualifier instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)patternQualifier).resolve()) instanceof PsiClass && (classContext = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)candidate, (Class[])new Class[]{PsiClass.class})) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)classContext, (PsiClass)((PsiClass)resolved), (boolean)true);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    } else if (patternQualifier instanceof PsiThisExpression && candidateQualifier2 instanceof PsiThisExpression) {
                        PsiJavaCodeReferenceElement thisPatternQualifier = ((PsiThisExpression)patternQualifier).getQualifier();
                        PsiElement patternContextClass = thisPatternQualifier == null ? PsiTreeUtil.getContextOfType((PsiElement)patternQualifier, (Class[])new Class[]{PsiClass.class}) : thisPatternQualifier.resolve();
                        PsiJavaCodeReferenceElement thisCandidateQualifier = ((PsiThisExpression)candidateQualifier2).getQualifier();
                        PsiElement candidateContextClass = thisCandidateQualifier == null ? PsiTreeUtil.getContextOfType((PsiElement)candidateQualifier2, (Class[])new Class[]{PsiClass.class}) : thisCandidateQualifier.resolve();
                        return patternContextClass == candidateContextClass;
                    }
                } else if (pattern instanceof PsiThisExpression) {
                    qualifier = ((PsiThisExpression)pattern).getQualifier();
                    PsiElement psiElement = contextClass = qualifier == null ? PsiTreeUtil.getContextOfType((PsiElement)pattern, (Class[])new Class[]{PsiClass.class}) : qualifier.resolve();
                    if (candidate instanceof PsiReferenceExpression) {
                        PsiElement parent = candidate.getParent();
                        return parent instanceof PsiReferenceExpression && contextClass instanceof PsiClass && match.registerInstanceExpression(((PsiReferenceExpression)parent).getQualifierExpression(), (PsiClass)contextClass);
                    }
                    if (candidate instanceof PsiThisExpression) {
                        candidateQualifier = ((PsiThisExpression)candidate).getQualifier();
                        PsiElement candidateContextClass = candidateQualifier == null ? PsiTreeUtil.getContextOfType((PsiElement)candidate, (Class[])new Class[]{PsiClass.class}) : candidateQualifier.resolve();
                        return contextClass == candidateContextClass;
                    }
                } else if (pattern instanceof PsiSuperExpression) {
                    qualifier = ((PsiSuperExpression)pattern).getQualifier();
                    PsiElement psiElement = contextClass = qualifier == null ? PsiTreeUtil.getContextOfType((PsiElement)pattern, (Class[])new Class[]{PsiClass.class}) : qualifier.resolve();
                    if (candidate instanceof PsiSuperExpression) {
                        candidateQualifier = ((PsiSuperExpression)candidate).getQualifier();
                        return contextClass == (candidateQualifier != null ? candidateQualifier.resolve() : PsiTreeUtil.getContextOfType((PsiElement)candidate, (Class[])new Class[]{PsiClass.class}));
                    }
                } else if (pattern instanceof PsiModifierList) {
                    return candidate instanceof PsiModifierList && DuplicatesFinder.matchModifierList((PsiModifierList)pattern, (PsiModifierList)candidate);
                }
            }
        }
        PsiElement[] children1 = DuplicatesFinder.getFilteredChildren(pattern);
        PsiElement[] children2 = DuplicatesFinder.getFilteredChildren(candidate);
        if (children1.length != children2.length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (this.matchPattern(child1, child2, candidates, match) || (matchedExtractablePart = this.matchExtractableExpression(child1, child2, candidates, match, true)) != null && matchedExtractablePart.booleanValue()) continue;
            return false;
        }
        if (children1.length == 0) {
            if (pattern.getParent() instanceof PsiVariable && ((PsiVariable)pattern.getParent()).getNameIdentifier() == pattern) {
                return match.putDeclarationCorrespondence(pattern.getParent(), candidate.getParent());
            }
            if (!pattern.textMatches(candidate)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Boolean matchExtractableExpression(PsiElement pattern, PsiElement candidate, List<PsiElement> candidates, Match match, boolean withFolding) {
        ExtractableExpressionPart candidatePart;
        ExtractableExpressionPart patternPart;
        if (!(pattern instanceof PsiExpression) || !(candidate instanceof PsiExpression) || withFolding && !this.myWithExtractedParameters) {
            return null;
        }
        if (this.myPattern.length == 1 && this.myPattern[0] == pattern || candidates.size() == 1 && candidates.get(0) == candidate) {
            return null;
        }
        ComplexityHolder patternComplexity = null;
        if (withFolding) {
            if (this.myPatternComplexityHolder == null) {
                this.myPatternComplexityHolder = new ComplexityHolder(this.myPatternAsList);
            }
            patternComplexity = this.myPatternComplexityHolder;
        }
        if ((patternPart = ExtractableExpressionPart.match((PsiExpression)pattern, this.myPatternAsList, patternComplexity)) == null) {
            return null;
        }
        ComplexityHolder candidatesComplexity = null;
        if (withFolding) {
            if (this.myCandidateComplexityHolder == null || this.myCandidateComplexityHolder.getScope() != candidates) {
                this.myCandidateComplexityHolder = new ComplexityHolder(candidates);
            }
            candidatesComplexity = this.myCandidateComplexityHolder;
        }
        if ((candidatePart = ExtractableExpressionPart.match((PsiExpression)candidate, candidates, candidatesComplexity)) == null) {
            return null;
        }
        if (patternPart.myValue != null && patternPart.myValue.equals(candidatePart.myValue)) {
            return true;
        }
        if (patternPart.myVariable == null || candidatePart.myVariable == null) {
            return this.myWithExtractedParameters && match.putExtractedParameter(patternPart, candidatePart);
        }
        return null;
    }

    private boolean matchExtractableVariable(PsiElement pattern, PsiElement candidate, Match match) {
        if (!(this.myWithExtractedParameters && pattern instanceof PsiReferenceExpression && candidate instanceof PsiReferenceExpression)) {
            return false;
        }
        ExtractableExpressionPart part1 = ExtractableExpressionPart.matchVariable((PsiReferenceExpression)pattern, null);
        if (part1 == null || part1.myVariable == null) {
            return false;
        }
        ExtractableExpressionPart part2 = ExtractableExpressionPart.matchVariable((PsiReferenceExpression)candidate, null);
        if (part2 == null || part2.myVariable == null) {
            return false;
        }
        return match.putExtractedParameter(part1, part2);
    }

    private static boolean matchModifierList(PsiModifierList modifierList1, PsiModifierList modifierList2) {
        if (!(modifierList1.getParent() instanceof PsiLocalVariable)) {
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!(modifierList1.hasModifierProperty(modifier) ? !modifierList2.hasModifierProperty(modifier) : modifierList2.hasModifierProperty(modifier))) continue;
                return false;
            }
        }
        return AnnotationUtil.equal((PsiAnnotation[])modifierList1.getAnnotations(), (PsiAnnotation[])modifierList2.getAnnotations());
    }

    private static boolean checkParameterModification(PsiExpression expression2, IElementType sign, PsiExpression candidate) {
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        candidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)candidate);
        if (expression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).resolve() instanceof PsiParameter && (sign.equals(JavaTokenType.MINUSMINUS) || sign.equals(JavaTokenType.PLUSPLUS))) {
            return !(candidate instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)candidate).resolve() instanceof PsiParameter);
        }
        return false;
    }

    private static void traverseParameter(PsiElement pattern, PsiElement candidate, Match match) {
        PsiElement[] children2;
        if (pattern == null || candidate == null) {
            return;
        }
        if (pattern.getUserData(PARAMETER) != null) {
            Pair parameter2 = (Pair)pattern.getUserData(PARAMETER);
            match.putParameter((Pair<PsiVariable, PsiType>)parameter2, candidate);
            return;
        }
        PsiElement[] children1 = DuplicatesFinder.getFilteredChildren(pattern);
        if (children1.length != (children2 = DuplicatesFinder.getFilteredChildren(candidate)).length) {
            return;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            DuplicatesFinder.traverseParameter(child1, child2, match);
        }
    }

    private boolean matchReturnStatement(PsiReturnStatement patternReturnStatement, PsiElement candidate, List<PsiElement> candidates, Match match) {
        if (candidate instanceof PsiExpressionStatement) {
            PsiExpression expression2 = ((PsiExpressionStatement)candidate).getExpression();
            if (expression2 instanceof PsiAssignmentExpression) {
                PsiExpression rExpression;
                PsiExpression returnValue = patternReturnStatement.getReturnValue();
                if (!this.matchPattern((PsiElement)returnValue, (PsiElement)(rExpression = ((PsiAssignmentExpression)expression2).getRExpression()), candidates, match)) {
                    return false;
                }
                PsiExpression lExpression = ((PsiAssignmentExpression)expression2).getLExpression();
                return match.registerReturnValue(new ExpressionReturnValue(lExpression));
            }
            return false;
        }
        if (candidate instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements = ((PsiDeclarationStatement)candidate).getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            if (!(declaredElements[0] instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElements[0];
            if (!this.matchPattern((PsiElement)patternReturnStatement.getReturnValue(), (PsiElement)variable.getInitializer(), candidates, match)) {
                return false;
            }
            return match.registerReturnValue(new VariableReturnValue(variable));
        }
        if (candidate instanceof PsiReturnStatement) {
            PsiExpression returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiReturnStatement)candidate).getReturnValue());
            if (this.myMultipleExitPoints) {
                return match.registerReturnValue(new ConditionalReturnStatementValue(returnValue));
            }
            PsiElement classOrLambda = PsiTreeUtil.getContextOfType((PsiElement)returnValue, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)match.getMatchStart(), (PsiElement)match.getMatchEnd());
            if (!(classOrLambda != null && PsiTreeUtil.isAncestor((PsiElement)commonParent, (PsiElement)classOrLambda, (boolean)false) || returnValue == null || match.registerReturnValue(ReturnStatementReturnValue.INSTANCE))) {
                return false;
            }
            return this.matchPattern((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)patternReturnStatement.getReturnValue()), (PsiElement)returnValue, candidates, match);
        }
        return false;
    }

    private static boolean equivalentResolve(PsiElement resolveResult1, PsiElement resolveResult2, PsiElement qualifier2) {
        if (Comparing.equal((Object)resolveResult1, (Object)resolveResult2)) {
            return true;
        }
        if (resolveResult1 instanceof PsiMethod && resolveResult2 instanceof PsiMethod) {
            PsiMethod method1 = (PsiMethod)resolveResult1;
            PsiMethod method2 = (PsiMethod)resolveResult2;
            if (method1.hasModifierProperty("static")) {
                return false;
            }
            if (ArrayUtil.find((Object[])method1.findSuperMethods(), (Object)method2) >= 0) {
                return true;
            }
            if (ArrayUtil.find((Object[])method2.findSuperMethods(), (Object)method1) >= 0) {
                return true;
            }
            if (method1.getName().equals(method2.getName())) {
                Object[] methods;
                PsiClass resolvedClass;
                PsiType type2;
                PsiClass class2 = method2.getContainingClass();
                if (qualifier2 instanceof PsiReferenceExpression && (type2 = ((PsiReferenceExpression)qualifier2).getType()) instanceof PsiClassType && !((resolvedClass = PsiUtil.resolveClassInType((PsiType)type2)) instanceof PsiTypeParameter)) {
                    class2 = resolvedClass;
                }
                if (class2 != null && PsiUtil.isAccessible((PsiMember)method1, (PsiElement)class2, null) && ArrayUtil.find((Object[])(methods = class2.getAllMethods()), (Object)method1) != -1) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    static boolean isUnder(@Nullable PsiElement element, @NotNull List<PsiElement> parents2) {
        if (parents2 == null) {
            DuplicatesFinder.$$$reportNull$$$0(8);
        }
        if (element == null) {
            return false;
        }
        for (PsiElement parent : parents2) {
            if (!PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiElement[] getFilteredChildren(PsiElement element1) {
        PsiElement[] children1 = element1.getChildren();
        ArrayList<Object> array = new ArrayList<Object>();
        for (PsiElement child : children1) {
            if (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiEmptyStatement) continue;
            if (child instanceof PsiBlockStatement) {
                child = ((PsiBlockStatement)child).getCodeBlock();
            }
            if (child instanceof PsiCodeBlock) {
                PsiStatement[] statements;
                for (PsiStatement statement2 : statements = ((PsiCodeBlock)child).getStatements()) {
                    if (statement2 instanceof PsiBlockStatement) {
                        Collections.addAll(array, DuplicatesFinder.getFilteredChildren((PsiElement)statement2));
                        continue;
                    }
                    if (statement2 instanceof PsiEmptyStatement) continue;
                    array.add(statement2);
                }
                continue;
            }
            if (child instanceof PsiParenthesizedExpression) {
                array.add(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiParenthesizedExpression)child)));
                continue;
            }
            array.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            DuplicatesFinder.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputParameters";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/DuplicatesFinder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/DuplicatesFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicateFragment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSelf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

