/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudGitAgent;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudDeploymentConfiguratorBase;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudGitApplicationRuntime;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudMultiSourceServerRuntimeInstance<DC extends CloudDeploymentNameConfiguration, AC extends CloudAgentConfigBase, A extends CloudGitAgent<AC, ?>, SC extends AC>
extends CloudServerRuntimeInstance<DC, A, SC> {
    private static final Logger LOG = Logger.getInstance(CloudMultiSourceServerRuntimeInstance.class);
    private final ServerType<?> myServerType;

    public CloudMultiSourceServerRuntimeInstance(ServerType<?> serverType, SC configuration, ServerTaskExecutor tasksExecutor, List<File> libraries, List<Class<?>> commonJarClasses, String specificsModuleName, String specificJarPath, Class<A> agentInterface, String agentClassName) throws Exception {
        super(configuration, tasksExecutor, libraries, commonJarClasses, specificsModuleName, specificJarPath, agentInterface, agentClassName);
        this.myServerType = serverType;
    }

    @Override
    public A getAgent() {
        return (A)((CloudGitAgent)super.getAgent());
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source) {
        if (source == null) {
            CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(0);
        }
        String string = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(source);
        if (string == null) {
            CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void connect(final ServerConnector.ConnectionCallback<DC> callback) {
        this.getAgentTaskExecutor().execute(() -> {
            this.doConnect(this.getConfiguration(), new CloudAgentLogger(){

                public void debugEx(Exception e) {
                    LOG.debug((Throwable)e);
                }

                public void debug(String message2) {
                    LOG.debug(message2);
                }
            });
            return null;
        }, new CallbackWrapper(){

            public void onSuccess(Object result2) {
                callback.connected((ServerRuntimeInstance)CloudMultiSourceServerRuntimeInstance.this);
            }

            @Override
            public void onError(String message2) {
                callback.errorOccurred(message2);
            }
        });
    }

    public void deploy(@NotNull DeploymentTask<DC> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(2);
        }
        if (logManager == null) {
            CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(4);
        }
        this.getTaskExecutor().submit(() -> {
            if (task == null) {
                CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(5);
            }
            if (logManager == null) {
                CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(6);
            }
            if (callback == null) {
                CloudMultiSourceServerRuntimeInstance.$$$reportNull$$$0(7);
            }
            this.createDeploymentRuntime(task, logManager).deploy(callback);
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(() -> this.getAgent().disconnect());
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeployToServerRunConfiguration<?, DC> runConfiguration) throws ServerRuntimeException {
        return this.createDeploymentRuntime(runConfiguration.getDeploymentSource(), (CloudDeploymentNameConfiguration)runConfiguration.getDeploymentConfiguration(), runConfiguration.getProject());
    }

    public CloudDeploymentRuntime createDeploymentRuntime(final DeploymentSource source, DC configuration, Project project2) throws ServerRuntimeException {
        return this.createDeploymentRuntime(new DeploymentTask<DC>((CloudDeploymentNameConfiguration)configuration, project2){
            final /* synthetic */ CloudDeploymentNameConfiguration val$configuration;
            final /* synthetic */ Project val$project;
            {
                this.val$configuration = cloudDeploymentNameConfiguration;
                this.val$project = project2;
            }

            @NotNull
            public DeploymentSource getSource() {
                DeploymentSource deploymentSource = source;
                if (deploymentSource == null) {
                    3.$$$reportNull$$$0(0);
                }
                return deploymentSource;
            }

            @NotNull
            public DC getConfiguration() {
                CloudDeploymentNameConfiguration cloudDeploymentNameConfiguration = this.val$configuration;
                if (cloudDeploymentNameConfiguration == null) {
                    3.$$$reportNull$$$0(1);
                }
                return cloudDeploymentNameConfiguration;
            }

            @NotNull
            public Project getProject() {
                Project project2 = this.val$project;
                if (project2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return project2;
            }

            public boolean isDebugMode() {
                return false;
            }

            @NotNull
            public ExecutionEnvironment getExecutionEnvironment() {
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfiguration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProject";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }, null);
    }

    private CloudDeploymentRuntime createDeploymentRuntime(DeploymentTask<DC> deploymentTask, @Nullable DeploymentLogManager logManager) throws ServerRuntimeException {
        DeploymentSource source = deploymentTask.getSource();
        for (CloudDeploymentRuntimeProvider provider : CloudDeploymentConfiguratorBase.getDeploymentRuntimeProviders(this.myServerType)) {
            CloudDeploymentRuntime result2 = provider.createDeploymentRuntime(source, this, deploymentTask, logManager);
            if (result2 == null) continue;
            return result2;
        }
        throw new ServerRuntimeException("Unknown deployment source");
    }

    @Override
    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        return new CloudGitApplicationRuntime(this, application.getName(), null);
    }

    protected abstract void doConnect(SC var1, CloudAgentLogger var2);

    public ServerType<?> getCloudType() {
        return this.myServerType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentName";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deploy$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

